import React, { PureComponent } from "react";
import { connect } from "dva";
// import { routerRedux, Link } from 'dva/router';
import { Form, Button, Steps, Icon } from "antd";
// import { NavLink } from "dva/router";
import "./PersonalRegistrationResult.less";
import TwoDimensionCode from "../../assets/images/two_dimension_code.png";
import IconS from "../../components/IconS";

const { Step } = Steps;

@connect(state => ({
  register: state.register
}))
@Form.create()
export default class PersonalRegistrationResult extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // count: 0,
    };
  }
  /******************************生命周期******************************/

  componentDidMount = () => { };
  /******************************ajax请求******************************/

  /******************************相关事件******************************/

  /******************************render******************************/

  renderRegister = () => {
    return (
      <div className="PersonalRegistrationResult">
        <div className="enroll-header">
          <div className="head-portrait">
            {/*<span className="head-portrait-con" />*/}
            <IconS type="logo-" />
            <span className="head-portrait-text">
              <span style={{ fontSize: "18px" }}>百保盾</span>
              <br />
              <span style={{ fontSize: "12px" }}>改变工作 改变你</span>
            </span>
          </div>
          <div className="head-portrait-register">
            <span
              style={{ cursor: "pointer" }}
              onClick={() => this.props.history.push("LogOn")}
            >
              登录{" "}
            </span>
          </div>
        </div>
        <div className="enroll-content">
          <div className="main">
            <h3>个人注册</h3>
            <div className="progress-bar">
              <Steps current={1}>
                <Step title="填写注册资料" />
                <Step title="注册成功" />
              </Steps>
            </div>
            <div className="enterprise-registration-content">
              <div>
                <Icon
                  className="enterprise-registration-icon"
                  type="check-circle"
                />
              </div>
              <h4 className="enterprise-registration-text">
                <span>注册成功</span>
              </h4>
              <div className="enterprise-registration-description">
                <p>
                  恭喜您已注册成功
                  <br />
                  账号和密码已发在联系手机上了，您现在可以开始扫码下载app体验啦。
                </p>
              </div>
              <div className="two-dimension-code">
                <img src={TwoDimensionCode} alt="" />
              </div>
              <div>
                <Button type="primary" onClick={() => this.props.history.push('./LogOn')}>开始体验</Button>
              </div>
            </div>
          </div>
        </div>
      </div>
    );
  };

  renderPersonalLogin = () => {
    return (
      <div className="PersonalRegistrationResult">
        <div className="enroll-header">
          <div className="head-portrait">
            {/*<span className="head-portrait-con" />*/}
            <IconS type="logo-" />
            <span className="head-portrait-text">
              <span style={{ fontSize: "18px" }}>百保盾</span>
              <br />
              <span style={{ fontSize: "12px" }}>改变工作 改变你</span>
            </span>
          </div>
          <div className="head-portrait-register">
            <span
              style={{ cursor: "pointer" }}
              onClick={() => this.props.history.push("LogOn")}
            >
              登录{" "}
            </span>
          </div>
        </div>
        <div className="enroll-content">
          <div className="main">
            <div className="enterprise-registration-content">
              <div>
                <Icon style={{ color: "#faad14" }} className="enterprise-registration-icon" type="info-circle" />
              </div>
              <h4 className="enterprise-registration-text" style={{ marginBottom: 0 }}>
                <span>您当前暂无企业关系，不能享受企业服务</span>
              </h4>
              <div className="enterprise-registration-description">
                <p>您现在可以扫二维码下载百保盾app体验个人服务</p>
              </div>
              <div className="two-dimension-code">
                <img src={TwoDimensionCode} alt="" />
              </div>
              <div>
                {/* <Button type="primary" onClick={() => this.props.history.push('./LogOn')}>开始体验</Button>*/}
              </div>
            </div>
          </div>
        </div>
      </div>
    );
  };

  render() {
    // const title = <div className="title">提交成功</div>;
    // const actions = (
    //     <div className="actions">
    //         <a href=""><Button size="large" type="primary">查看邮箱</Button></a>
    //         <Link to="/"><Button size="large">返回首页</Button></Link>
    //     </div>
    // );

    console.log(this.props.location.search.indexOf("download") !== -1);
    if (this.props.location.search.indexOf("download") !== -1) {
      return this.renderPersonalLogin();
    } else {
      return this.renderRegister();
    }
  }
}
