import React, { PureComponent } from 'react';
import { connect } from 'dva';
// import { routerRedux, Link } from 'dva/router';
import { Form, Button, Steps, Icon } from 'antd';
// import { NavLink } from "dva/router";
import './EnterpriseRegistrationResult.less';
import IconS from '../../components/IconS';
import { gup } from '../../utils/utils';

const { Step } = Steps;

@connect(state => ({
  register: state.register
}))
@Form.create()
export default class EnterpriseRegistrationResult extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      institution: gup('institution') || ''
    };
  }
  /******************************生命周期******************************/

  componentDidMount = () => {};
  /******************************ajax请求******************************/

  /******************************相关事件******************************/

  /******************************render******************************/

  render() {
    // const title = <div className="title">提交成功</div>;
    // const actions = (
    //     <div className="actions">
    //         <a href=""><Button size="large" type="primary">查看邮箱</Button></a>
    //         <Link to="/"><Button size="large">返回首页</Button></Link>
    //     </div>
    // );

    return (
      <div className='EnterpriseRegistrationResult'>
        <div className='enroll-header'>
          <div className='head-portrait'>
            {/*<span className="head-portrait-con" />*/}
            <IconS type='logo-' />
            <span className='head-portrait-text'>
              <span style={{ fontSize: '18px' }}>百保盾</span>
              <br />
              <span style={{ fontSize: '12px' }}>改变工作 改变你</span>
            </span>
          </div>
          <div className='head-portrait-register'>
            <span
              style={{ cursor: 'pointer' }}
              onClick={() => this.props.history.push('LogOn')}
            >
              登录{' '}
            </span>
          </div>
        </div>
        <div className='enroll-content'>
          <div className='main'>
            <h3>企业注册</h3>
            <div className='progress-bar'>
              <Steps current={1}>
                <Step title='填写注册资料' />
                <Step title='开始体验' />
              </Steps>
            </div>
            <div className='enterprise-registration-content'>
              <div>
                <Icon
                  className='enterprise-registration-icon'
                  type='check-circle'
                />
              </div>
              <h4 className='enterprise-registration-text'>
                <span>提交成功</span>
              </h4>
              <div className='enterprise-registration-description'>
                {this.state.institution !== '0201' && (
                  <p>
                    恭喜您的入驻申请已提交
                    <br />
                    管理员账号和密码已发在联系手机上了，您现在可以开始体验啦。
                  </p>
                )}
                {this.state.institution === '0201' && (
                  <p>
                    您的入驻申请已提交，管理员的账号及密码已发送至联系手机，稍后会有工作人员与您联系。
                  </p>
                )}
              </div>
              <div>
                <Button
                  type='primary'
                  onClick={() => this.props.history.push('./LogOn')}
                >
                  开始体验
                </Button>
              </div>
            </div>
          </div>
        </div>
      </div>
    );
  }
}
