import React, { PureComponent } from 'react';
import { Form, Input, Button, message, Modal, Icon } from 'antd';
import style from "styled-components";
import IconS from "../../components/IconS";
import {
  systemPlatNewsSendVerificationCode,
  systemPlatNewsVerificationCode,
  systemPerAccountInfoUpdatePassword,
  systemPerBaseInfoCheckAdmin,
  systemPerBaseInfoUpdatePassWord

} from "../../services/api";
import "./ForgetPassword.less";

const FormItem = Form.Item;
@Form.create()
export default class ChangeUserPassword extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      visible: false
    };
  }


  //判断两次密码是否一致
  checkPassword = (rule, value, callback) => {
    const password = this.props.form.getFieldValue("newPassWord");
    const repassword = this.props.form.getFieldValue("repassword");
    if (password !== repassword) {
      message.error("两次输入的新密码不一致，请重新输入!");
    } else {
      callback();
    }
  }
  //判断新密码和旧密码密码是否一致
  checkNewPassword = (rule, value, callback) => {
    const password = this.props.form.getFieldValue("oldPassWord");
    const repassword = this.props.form.getFieldValue("newPassWord");
    if (password === repassword && password !== undefined && repassword !== undefined) {
      message.error("新旧密码相同，请重新输入！");
    } else {
      callback();
    }
  }
  // 表单提交
  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, { oldPassWord, newPassWord }) => {
      if (!err) {
        systemPerBaseInfoUpdatePassWord({ oldPassWord, newPassWord })
          .then((data) => {
            message.success(data.msg);
          },
            (err) => {
              console.log(err);
            }
          );
      }
    }, err => {
      console.log(err);
    });
  }

  //重置
  handleReset = () => {
    this.setState({
      visible: true,
    });
  }
  resetFrom = () => {
    const { setFieldsValue } = this.props.form;
    setFieldsValue({
      newPassWord: '',
      oldPassWord: '',
      repassword: '',
    });
    this.setState({
      visible: false,
    });
  }
  modelCancel = () => {
    this.setState({
      visible: false,
    });
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 7 },
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 16 },
      },
    };
    const tailFormItemLayout = {
      wrapperCol: {
        xs: {
          span: 24,
          offset: 0,
        },
        sm: {
          span: 17,
          offset: 7,
        },
      },
    };
    return (
      <UserPassword>
        <div className="password-wrap" >
          <div className="password-content">
            <Form onSubmit={this.handleSubmit} >
              <FormItem
                {...formItemLayout}
                label="当前密码:"
              >
                {getFieldDecorator('oldPassWord', {
                  rules: [{
                    required: true, message: '请输入您的密码!',
                  }],
                })(
                  <Input placeholder="请输入" style={{ width: 400 }} type="password" />
                )}
              </FormItem>
              <FormItem
                {...formItemLayout}
                label=" 新管理密码:"
              >
                {getFieldDecorator('newPassWord', {
                  rules: [{
                    required: true, message: '请输入您的密码!',
                  }, {
                    validator: this.checkNewPassword,
                  }],
                })(
                  <Input placeholder="请输入" style={{ width: 400 }} type="password" />
                )}
              </FormItem>
              <FormItem
                {...formItemLayout}
                label=" 确认管理密码:"
              >
                {getFieldDecorator('repassword', {
                  rules: [{
                    required: true, message: '请输入您密码!'
                  },
                  { validator: this.checkPassword, }
                  ],
                })(
                  <Input placeholder="请输入" style={{ width: 400 }} type="password" />
                )}
              </FormItem>
              <FormItem {...tailFormItemLayout}>
                <Button style={{ marginRight: 16 }} onClick={this.handleReset}>重置</Button>
                <Button type="primary" htmlType="submit">确定</Button>
              </FormItem>
            </Form>
            <Modal
              title="提示"
              visible={this.state.visible}
              onOk={this.resetFrom}
              onCancel={this.modelCancel}
              okText="确认"
              cancelText="取消"
            >
              <p style={text}>
                <Icon type="exclamation-circle"
                  style={{ fontSize: 24, color: '#fdd214', marginRight: 15 }} />
                您确认重置恢复原来的配置？</p>
            </Modal>
          </div>
        </div>
      </UserPassword>
    );
  }
}
/******************style*********************/
const UserPassword = style.div`{
  .password-wrap{
    background: #FFFFFF;
    border-radius: 8px;
  }
}`;
const text = {
  textAlign: 'center'
};
