import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import { withRouter } from 'dva/router';
import {
  Button, Alert, Popover,
  Tabs,
} from 'antd';
import BTable from '../../../../components/Pro/BTable';
import SearchForm from './SearchForm';
import columnFun from './columns';
import SubDrawer from './SubDrawer';
import store from 'store';
const { TabPane } = Tabs;
@connect(state => ({
  global: state.global
}))
@withRouter
export default class StudentManagement extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false, //刷新数据
      // 搜索部分
      searchData: {  // 表格数据请求参数
        pageNumber: 1,  // 页	
        pageSize: 10  //条目
      },
      //抽屉
      drawerVisble: false,
      personApplyId: '',  //当前选中的id
    };
  }

  componentDidMount() {
    //获取部门树数据
    // this.__getDepart();
    // this.__getTable(this.state.searchData, data => {
    // });
  }
  _search = values => {
    this.setState({
      searchData: {
        ...this.state.searchData,
        ...values
      },
      isInit: true
    });
  }
  _updateTable = () => {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
  }
  // 表格渲染
  renderOrderList = () => {
    const columns = columnFun.call(this);
    if (!this.state.isInit) return;
    return (
      <BTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="adapt_trainAdaptApplyTrainPage"
        pageParm={this.state.searchData}
        forceUpdate={this.state.forceUpdate}
        scroll={{ x: '2000px' }}
        dateChange={(e) => { }}
      />
    );
  };

  render() {

    return (
      <div style={{ margin: 15 }}>
        <Tabs>
          <TabPane tab="岗位适应性培训学员管理" key="1" />
        </Tabs>
        <Alert
          message={<div style={{ color: '#333' }}>
            材料核对：您需要为每一条报名记录核对材料信息；若核对不通过，将终止该学员继续学习课程；若核对通过，则该学员可以继续学习。
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <SearchForm
          onSearch={this._search}
        />
        <Btns>
          <Popover content={<span style={{ display: 'block', padding: 10 }}>搜索后可导出搜索结果</span>}>
            <Button
              type="primary"
              onClick={() => {
                const { searchData } = this.state;
                let queryStr = '';
                Object.keys(searchData).forEach(key => {
                  queryStr += `${key}=${searchData[key]}&`;
                });
                queryStr = '?' + queryStr.slice(0, -1);
                window.open('/bkt_api/train/adapt/apply/export/train/apply' + queryStr + '&sessionId=' + store.get('saas')['sessionId']);
              }}
            >
              导出人员数据
              </Button>
          </Popover>

        </Btns>
        {/* 表格 */}
        {this.renderOrderList()}

        {/* 修改弹窗 */}
        <SubDrawer
          personApplyId={this.state.personApplyId}
          setParentState={this.setState.bind(this)}
        />
      </div >
    );
  }
}

const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;