
// import style from "styled-components";
// import $modal from '../../../../utils/modal';
const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
export default function () {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
      width: 80,
      fixed: 'left'
    },
    {
      title: '姓名',
      dataIndex: 'fullName',
      key: 'fullName',
      width: 80,
      fixed: 'left',
      render: value => value || '-'
    },
    {
      title: '身份证号',
      dataIndex: 'identityNumber',
      key: 'identityNumber',
      render: value => value || '-'
    },
    {
      title: '手机号码',
      dataIndex: 'mobile',
      key: 'mobile',
      render: value => value || '-'
    },
    {
      title: '报名时间',
      dataIndex: 'applyDate',
      key: 'applyDate',
      render: value => value || '-'
    },
    {
      title: '申报状态',
      dataIndex: 'applyStatus',
      key: 'applyStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            text = '申报中';
            color = warnColor;
            break;
          case value == 1:
            text = '申报通过';
            color = okColor;
            break;
          case value == 2:
            text = '申报不通过';
            color = errColor;
            break;
          case value == 3:
            text = '已撤销';
            color = errColor;
            break;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '背景筛查状态',
      dataIndex: 'backgroundStatus',
      key: 'backgroundStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            text = '审核中';
            color = warnColor;
            break;
          case value == 1:
            text = '正常';
            color = okColor;
            break;
          case value == 2:
            color = errColor;
            text = '关注';
            break;
          case value == 3:
            color = okColor;
            text = '申诉通过';
            break;
          case value == 4:
            color = errColor;
            text = '申诉不通过';
            break;
          case value == 5:
            color = warnColor;
            text = '申诉中';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '缴费状态',
      dataIndex: 'orderStatus',
      key: 'orderStatus',
      render: (value) => {
        let text = '未缴费';
        let color = '';
        switch (true) {
          case value == 0:
            color = errColor;
            text = '未缴费';
            break;
          case value == 1:
            color = okColor;
            text = '已缴费';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '材料核对状态',
      dataIndex: 'materialApproveStatus',
      key: 'materialApproveStatus',
      render: (value) => {
        let text = '未核对';
        let color = '';
        switch (true) {
          case value == 0:
            color = warnColor;
            text = '未核对';
            break;
          case value == 1:
            color = okColor;
            text = '核对通过';
            break;
          case value == 2:
            color = errColor;
            text = '核对不通过';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '理论学习进度',
      dataIndex: 'progress',
      key: 'progress',
      render: value => {
        if (value) {
          return value + '%';
        } else {
          return '0%'
        }
      }
    },
    {
      title: '报名保安公司',
      dataIndex: 'learnName',
      key: 'learnName',
      render: value => value || '-'
    },
    {
      title: '培训机构名称',
      dataIndex: 'organName',
      key: 'organName',
      render: value => value || '-'
    },
    {
      title: '缴费时间',
      dataIndex: 'payDate',
      key: 'payDate',
      render: value => value || '-'
    },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      fixed: 'right',
      width: 120,
      render: (text, record) => {
        const { materialApproveStatus, personApplyId } = record;
        return (
          <a onClick={() => {
            this.setState({
              personApplyId
            });
          }}>{materialApproveStatus == '0'?'核对处理':'查看'}</a>
        );
      }
    }
  ];
}
