import React, { Component } from "react";
import {
  Button,
  Form,
  Input,
  Select,
  DatePicker
} from "antd";
// import moment from 'moment';
const dateFomate = 'YYYY-MM-DD';
import {
  
} from '../../../../services/api';
const { Option } = Select;
const { RangePicker } = DatePicker;
@Form.create()
export default class SearchForm extends Component {
  constructor(props) {
    super(props);
    this.state = {
    }
  }
  componentDidMount() {
    this._search();
  }

  _search = (e) => {
    e && e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        // 缴费时间
        if(values.payDate.length == 0) {
          values.payStartDate = '';
          values.payEndDate = '';
        }else {
          values.payStartDate = values.payDate[0].format(dateFomate);
          values.payEndDate = values.payDate[1].format(dateFomate);
        }
        Reflect.deleteProperty(values, 'payDate');
        values.pageNumber = 1;
        this.props.onSearch(values);
      }
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    this._search();
}
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}> 
        <Form.Item style={{marginTop: 10}} label="关键词">
          {getFieldDecorator('keyword', {
            initialValue: ''
          })(
            <Input placeholder="请输入学员名称/身份证/手机号码" />
          )}
        </Form.Item>
        {/* 0未审核，1审核通过，2审核不通过 */}
        <Form.Item style={{marginTop: 10}} label="材料核对状态">
          {getFieldDecorator('materialApproveStatus', {
            initialValue: ''
          })(
            <Select style={{minWidth: 200}} >
              <Option value="">全部</Option>
              <Option value="0">未核对</Option>
              <Option value="1">核对通过</Option>
              <Option value="2">核对不通过</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label="保安公司名称">
          {getFieldDecorator('learnName', {
            initialValue: ''
          })(
            <Input placeholder="" />
          )}
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label="缴费时间">
          {getFieldDecorator('payDate', {
            initialValue: []
          })(
            <RangePicker
              disabledDate={current => {
                // return current > moment().endOf('day')
                // return current && current > moment().endOf('day')
              }}
              // disabledTime={}
              format="YYYY-MM-DD"
            />
          )}
        </Form.Item>

        {/* btns */}
        <Form.Item style={{marginTop: 10}} label=" " colon={false}>
          <Button type="primary" onClick={this._search}>搜索</Button>
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>
      </Form>
    );
  }
}
