import React, { PureComponent } from 'react';
import { Tabs } from 'antd';
import style from "styled-components";

const store = require("store");

const { TabPane } = Tabs;

export default class StudentManagement extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      currentURL: "http://localhost:8888/center?switchArea=already&systype=saas&sessionId=4B9B34CD9602CF7E26B867BB14AD038CF0FAFAFF00222F4AA3E93D5B2E599803C58A742583D735795C6EB085D5CA84BC81D7F7B84CFB265FF40D7D7055D0D9A1&areaCode=110100",
    };
  }
  componentWillMount() {
    const NODE_EVN = process.env.NODE_ENV;
    if(NODE_EVN != 'development') { 
      this.setState({
        currentURL: store.get("studentManagementURL")["studentManagementURL"]
      })
    }
  }
  componentDidMount = () => {
    //sessionId
  }
  render() {
    return (
      <Container>
        <Tabs>
          <TabPane tab="资格证学员管理" key="1" />
        </Tabs>
        {this.state.currentURL !== undefined ? (
          <div style={{ height: "inherit" }}>
            <iframe
              title="资格证学员管理"
              src={this.state.currentURL}
              width="100%"
              height="100%"
              frameBorder="0"
              allowFullScreen={true}
              allowtransparency="true">
              您的浏览器不支持iframe，请升级
              </iframe>
          </div>
        ) : ''
        }
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
`;
