import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import { withRouter } from 'dva/router';
import {
  Input,
  Select,
  DatePicker,
} from 'antd';
import tablePage from '../../../../utils/hoc/tablePage';
import columnFun from './columns';
import moment from 'moment';

const { RangePicker } = DatePicker;
const dateFormat = 'YYYY-MM-DD';
@connect(state => ({
  global: state.global
}))
@tablePage({ type: 'bkt' })
@withRouter
export default class FaceRecognition extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
    };
  }

  componentDidMount() {

  }

  // 表格渲染
  renderOrderList = () => {
    const columns = columnFun.call(this);
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="grade_learnTrackAuthQualifyOrganPage"
        // scroll={{ x: '2000px' }}
        dateChange={(data) => {

        }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <div style={{ padding: '0 24px' }}>
        {/* <Alert
          message={<div style={{ color: '#333' }}>
            <span>1、是否自然人：‘是’指通过培训学校报名的学员；“否“指服务公司报名的学员。</span>
            <br />
            <span>2、该页面展示的是所有已缴费的学员名单。</span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        /> */}
        <SearchForm
          arrange={values => {
            // values
            const { date } = values;
            // 认证时间
            if (date.length == 2) {
              values.authStartDate = moment(date[0]).format(dateFormat);
              values.authEndDate = moment(date[1]).format(dateFormat);
            } else {
              values.authStartDate = '';
              values.authEndDate = '';
            }
            Reflect.deleteProperty(values, 'date');
            return values;
          }}
        >
          <>
            <Form.Item label="姓名">
              {getFieldDecorator('fullName', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入姓名" />
              )}
            </Form.Item>
            <Form.Item label="身份证号">
              {getFieldDecorator('identityNumber', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入身份证号" />
              )}
            </Form.Item>
            <Form.Item label="手机号">
              {getFieldDecorator('mobile', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入手机号" />
              )}
            </Form.Item>
            <Form.Item label="现职企业">
              {getFieldDecorator('learnName', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入现职企业" />
              )}
            </Form.Item>

            {/* <Form.Item label="所学课程名称">
              {getFieldDecorator('orderStatus', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入所学课程名称" />
              )}
            </Form.Item> */}
            <Form.Item label="认证时间">
              {getFieldDecorator('date', {
                initialValue: []
              })(
                <RangePicker
                  format={dateFormat}
                />
              )}
            </Form.Item>
          </>
        </SearchForm>
        
        {/* 表格 */}
        {this.renderOrderList()}
        
      </div >
    );
  }
}

const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;