/* 
*visible 显示
*setParentState 设置父组件的state
*gradeClassId 班级id 新增的时候为''
 */

import React, { Component } from "react";
import st from "styled-components";
import { trainGradeCreateClass, trainQuestionTestpaperList, trainGradeClassInfo ,trainGradeCreateClassRole} from '../../../../services/bkt/apis';
import { publicCommonFileUploadFile } from '../../../../services/api';
import $modal from '../../../../utils/modal';
import SelectStudents from './SelectStudents';
import Turnover from './Turnover'; 
// import PFromUpload from '../../../../components/Pro/PFromUpload';
// import bcx_utils from '../../../../common/bcx_utils';
import $loading from '../../../../utils/loading';
import {
  // Drawer,
  Input,
  Row,
  Col,
  Button,
  Form,
  DatePicker,
  Modal,
  Select,
  InputNumber,
  Upload,
  Icon,
  message,
  // notification 
} from "antd";
import moment from 'moment';
const { RangePicker } = DatePicker;
const { Option } = Select;
const dateFomate = 'YYYY-MM-DD';
const timeFomate = 'YYYY-MM-DD HH:mm:ss';
@Form.create()
export default class ClassInfo extends Component {
  constructor(props) {
    super(props);
    this.state = {
      outFormData: {  //不包含在rc-form中的字段
        graduateComputerScoreLimit: '',
        graduatePracticeScoreLimit: '',
        identifyComputerScoreLimit: '',
        identifyPracticeScoreLimit: '',
      },
      licked: false, //用户是否点击过下一步，如果有，开始校验字段，显示必填字段错误
      papers: [], //试卷（下拉列表）
      info: null,
      gradeClassId: '',
      destroyOnClose: false, //新增的时候不销毁组件，修改时销毁组件
      nextButton: true, // true的时候右下角按钮为下一步，false为确定
      selectStudentsShow: false, //选择人员弹窗
      classPersonsShow:false,//班级成员弹窗
      practiceUrllist: [], //实操培训课程表
      requestDate: moment(),  //请求接口的时间用于控制时间控件
      submitedData:null,//保存后返回的信息数据
    }
  }
  componentWillReceiveProps(nextProps) {
    const { gradeClassId, visible, form } = nextProps;
    const preGradeClassId = this.state.gradeClassId;
    const outFormData = { ...this.state.outFormData };

    if (visible) {
      this.setState({
        gradeClassId
      }, () => {
        //传入的id不等于保存的id
        if (gradeClassId != '' ) {  //编辑模式
          //id变化的时候
          // 获取到新数据
          trainGradeClassInfo({ data: { gradeClassId } }).then(res => {
            Object.keys(outFormData).forEach(key => {
              outFormData[key] = res.data && res.data[key] || '';
            });
            // 渲染接口数据
            this.setState({
              info: res.data,
              outFormData
            }, () => {
              this.setState({
                practiceUrllist: [{
                  uid: moment().valueOf(),
                  name: this._getDefaultValue('practiceScheduleUrl'),
                  status: 'done',
                  response: '无效链接', 
                }]
              });
              // 详情的时候重置表单内容
              form.resetFields();
            });
          });
          // 编辑模式按钮为确定
          this.setState({
            nextButton: false
          });
        }
        // 新增的模式
        if ( gradeClassId == '') {
          let info = this.state.info
          //新增时候重置字段（如果之前的字段还留着，重置）
          if(preGradeClassId != ''){
            form.resetFields();
            form.setFieldsValue({className: null})
            Object.keys(outFormData).forEach(key => {
              outFormData[key] = '';
            });
            this.setState({
              info: null,
              outFormData,
              practiceUrllist: []
            });
            info= null
          }
          const { setFieldsValue,getFieldValue } = this.props.form;
          //获取班级名称字段，如果有班级已在审批，就不让新建
          if(!getFieldValue('className') ){
            trainGradeCreateClassRole({}).then(res=>{
              if(res.retType=='0'){
                // this.setState({
                //   info: res.data ? { className:res.data }:null
                // })
                setFieldsValue({ className: res.data ? res.data : null });
              }
            }).catch(err=>{
              return this.props.setParentState && this.props.setParentState({ classInfoShow: false });
            })
          }
        }
      });
    } else {
      this.props.form.resetFields();
      this.setState({
        licked: false
      });
    }
  }
  componentDidMount() {
    this.__getExamsPapers();
  }
  // 获取试卷下拉列表
  __getExamsPapers = () => {
    trainQuestionTestpaperList({ data: {} }).then(res => {
      this.setState({
        requestDate: res.date,
        papers: res.data
      });
    })
  }

  // 获取默认值
  _getDefaultValue(fields, defaultValue = '') {
    let result = '';
    const { info } = this.state;
    // const getType = obj => Object.prototype.toString.call(obj).slice(8, -1);
    const type = Object.prototype.toString.call(fields).slice(8, -1);
    const returnEmpty = () => {
      if (type == 'Array') {
        return [];
      } else {
        return defaultValue;
      }
    }
    if (!!info) {
      if (type == 'String') {
        result = info[fields];
      } else if (type == 'Array') {
        result = [];
        fields.forEach(key => {
          if(info[key]) {
            result.push(moment(info[key], timeFomate));
          }else {
            result.push('');
          }
        });
      } else {
        result = returnEmpty();
      }
    } else {
      result = returnEmpty();
    }
    return result;
  }

  // 校验数据并且保存课程
  _next = () => {
    this.setState({
      licked: true
    }, () => {
      this.props.form.validateFields((err, values) => {
        const { outFormData } = this.state;
        const outFormDataHasEmpty = Object.keys(outFormData).some(key => !outFormData[key]);
        // 存在空值
        if (outFormDataHasEmpty) {
          return $modal('成绩应为1-100的整数', '', null, 'error');;
        }
        if (!err) {
          /**
           * 有id的情况是查看，保存之后关闭弹窗就行
           * 没有id是新建，保存之后要选择人员
           */ 
          if (!!this.props.gradeClassId) {
            this.props.setParentState && this.props.setParentState({
              classInfoShow: false,  // 关闭弹窗
            });
          } else {
            this._submitData()
            // this.setState({
            //   // selectStudentsShow: true
            //   classPersonsShow:true
            // });
          }
        }
      });
    });
  }
  // 提交数据
  _submitData = (cb) => {
    this.props.form.validateFields((err, values) => {
      const { outFormData } = this.state;
      // 实操培训时间
      values.practiceStartDate = values.practiceDate[0].format(timeFomate);
      values.practiceEndDate = values.practiceDate[1].format(timeFomate);
      Reflect.deleteProperty(values, 'practiceDate');
      // 结业理论考试时间
      values.graduateComputerStartDate = values.graduateComputerDate[0].format(timeFomate);
      values.graduateComputerEndDate = values.graduateComputerDate[1].format(timeFomate);
      Reflect.deleteProperty(values, 'graduateComputerDate');
      // 结业实操考试时间
      values.graduatePracticeStartDate = values.graduatePracticeDate[0].format(timeFomate);
      values.graduatePracticeEndDate = values.graduatePracticeDate[1].format(timeFomate);
      Reflect.deleteProperty(values, 'graduatePracticeDate');
      // 鉴定理论考试时间
      values.identifyComputerStartDate = values.identifyComputerDate[0].format(timeFomate);
      values.identifyComputerEndDate = values.identifyComputerDate[1].format(timeFomate);
      Reflect.deleteProperty(values, 'identifyComputerDate');
      // 鉴定实操考试时间
      values.identifyPracticeStartDate = values.identifyPracticeDate[0].format(timeFomate);
      values.identifyPracticeEndDate = values.identifyPracticeDate[1].format(timeFomate);
      Reflect.deleteProperty(values, 'identifyPracticeDate');
      
      values = {
        ...values,
        ...outFormData,
        createClassType:4,//开班状态（待提交）
      }
      trainGradeCreateClass({ data: values }).then(res => {
        const gradeClassId = res.data;
        cb && cb(gradeClassId);
        this.setState({
          gradeClassId,
        },()=>{
          this.setState({
            classPersonsShow:true,
          })
        })
      });
    });
  }
  // 设置outFormData的字段
  _setOutField = (key, value) => {
    this.setState({
      outFormData: {
        ...this.state.outFormData,
        [key]: value
      }
    });
  }
  _isErrorScore = (value) => {
    if (/(^[1-9]$)|(^[1-9][0-9]$)|(^100$)/.test(value + '')) {
      return false;
    }
    return true;
  }
  _setParentState = (obj = {}, cb) => {
    this.setState(obj);
    setTimeout(() => {
      cb && cb();
    });
    this.props.setParentState && this.props.setParentState({ classInfoShow: false });
    this.props._updateTable()
  }
  render() {
    const { getFieldDecorator, setFieldsValue } = this.props.form;
    const { outFormData } = this.state;
    const formItemLayout = {
      labelCol: {
        span: 10
      },
      wrapperCol: {
        span: 14
      },
      labelAlign: 'right'
    };
    const formItemLayout1 = {
      labelCol: {
        span: 5
      },
      wrapperCol: {
        span: 19
      },
      labelAlign: 'right'
    };
    const formItemLayout2 = {
      labelCol: {
        span: 5
      },
      wrapperCol: {
        span: 19
      },
      labelAlign: 'right'
    };
    
    return (
      <Modal
        title={!!this.props.gradeClassId ? '班级信息' : '新建班级'}
        width={800}
        visible={this.props.visible}
        destroyOnClose={this.state.destroyOnClose}
        // okText={!!this.props.gradeClassId ? '确定' : '下一步'}
        // cancelText="取消"
        footer={!!this.props.gradeClassId ?null:[<Button key="back" onClick={()=>{ this.props.setParentState && this.props.setParentState({ classInfoShow: false });}}>
          取消
        </Button>,
        <Button key="submit" type="primary" onClick={()=>this._next()}>
          保存
        </Button>,]}
        okButtonProps={{
          disabled: this.props.classStatus == '1' || this.props.classStatus == ''? false: true
        }}
        onCancel={() => {
          this.props.setParentState && this.props.setParentState({ classInfoShow: false });
        }}
      >
        <Form layout="horizontal" style={{paddingRight: 30}}>
          <Row gutter={16}>
            <Col span={5}>
              <Title>基础信息</Title>
            </Col>
            <Col span={19}>
              <Em>注：1、班级信息提交后，需经公安人员审核，预计1~2个工作日完成审核，审核期间不可对班级信息及班级成员进行操作；
2、若需要修改班级信息，需要等开班审核出结果后，取消本班级，重新发起开班申请。因此，请注意核对开班申请信息，以免影响业务正常开展。</Em>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout2} label="班级名称" extra={
                <span style={{color: 'orange'}}>
                  请认真核对本期班级编号确保无误，如有问题可手动修改。<br/>
                  班级命名规则：学校简称+五级培训+年份+xxx期，xxx从001开始随着每期有效期数增加而递增，如遇跨年则又从001开始。如百川信五级培训2020001期，2021年第一次开班则为百川信五级培训2021001期.
                </span>
              }>
                {getFieldDecorator('className', {
                  initialValue: this._getDefaultValue('className'),
                  rules: [{ required: true, message: '请输入班级名称' }],
                })(<Input placeholder="请输入班级名称" />)}
              </Form.Item>
            </Col>
          </Row>
          {/* <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout2} label="开班时间">
                {getFieldDecorator('date', {
                  initialValue: this._getDefaultValue(['startDate', 'endDate'], []),
                  // initialValue: this.state.info? moment(this.state.info.startDate): moment(),
                  rules: [{ required: true, message: '请选择开班时间' }],
                })(
                // <DatePicker format="YYYY-MM-DD" style={{width: '100%'}}  placeholder="请选择开班时间" />
                <RangePicker
                  style={{width: '100%'}}
                  // renderExtraFooter={() => ''} showTime
                  disabledDate={current => {
                  }}
                  showTime
                  format={timeFomate}
                />
                )}
              </Form.Item>
            </Col>
            </Row> */}
            <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout2} label="实操开班培训时间">
                {getFieldDecorator('practiceDate', {
                  initialValue: this._getDefaultValue(['practiceStartDate', 'practiceEndDate'], []),
                  rules: [{ required: true, message: '请选择实操开班培训时间' }],
                })(<RangePicker
                  style={{width: '100%'}}
                  // renderExtraFooter={() => ''} showTime
                  disabledDate={current => {
                    return current < moment(this.state.requestDate).add(9,'days').endOf('day');
                  }}
                  showTime
                  format={timeFomate}
                />)}
              </Form.Item>
            </Col>
          </Row>

          <Row gutter={16}>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="考场联系人">
                {getFieldDecorator('contactName', {
                  initialValue: this._getDefaultValue('contactName'),
                  rules: [{ required: true, message: '请输入考场联系人' }],
                })(<Input placeholder="请输入考场联系人" />)}
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="联系电话">
                {getFieldDecorator('contactPhone', {
                  initialValue: this._getDefaultValue('contactPhone'),
                  rules: [{ required: true, message: '请输入联系电话' }, {
                    pattern: /^((0\d{2,3}-\d{7,8})|(1[0-9]{10}))$/,
                    message: '联系电话格式错误！'
                  }],
                })(<Input placeholder="请输入联系电话" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="其他联系方式">
                {getFieldDecorator('otherContactPhone', {
                  initialValue: this._getDefaultValue('otherContactPhone'),
                  rules: [{ required: false }],
                })(<Input placeholder="其他联系方式" />)}
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="联系人邮箱">
                {getFieldDecorator('contactEmail', {
                  initialValue: this._getDefaultValue('contactEmail'),
                  rules: [{
                    validator: (rule, value, cb) => {
                      if (
                        value.length > 0 &&
                        !/^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*\.[a-zA-Z0-9]{2,6}$/.test(
                          value
                        )
                      ) {
                        cb('请输入正确的邮箱地址!');
                      }
                      cb();
                    }
                  }],
                })(<Input placeholder="联系人邮箱" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={24}>
              <Form.Item extra={<span style={{color: 'orange'}}>文件格式支持：.rar .zip .doc .docx .pdf .xls .xlsx</span>} {...formItemLayout1} label="实操培训课程表">
                {getFieldDecorator('practiceScheduleUrl', {
                  value: this._getDefaultValue('practiceScheduleUrl'),
                  rules: [{ required: true, message: '请上传实操培训课程表' }],
                })(
                  <Upload 
                    showUploadList={true}
                    fileList={this.state.practiceUrllist}
                    onChange={info => {
                      const file = info.file;
                      if(!(file.name + '').toLocaleLowerCase().match(/(\.rar)|(\.zip)|(\.doc)|(\.docx)|(\.pdf)|(\.xls)|(\.xlsx文件)/)) {
                        message.error('请上传拓展名为.rar .zip .doc .docx .pdf .xls .xlsx文件!');
                        return;
                      }
                      $loading.open('正在导入数据，请稍后...');
                      const formData = new FormData();
                      formData.append('xfile', file.originFileObj);
                      publicCommonFileUploadFile(formData, false).then(res => {
                        $loading.close();
                        file.url = res.data;
                        file.status = 'done';
                        this.setState({ practiceUrllist: [file] }, () => {
                          setFieldsValue({'practiceScheduleUrl': res.data});
                        });
                        
                      }).catch(ex => {
                        console.log(ex);
                        $loading.close();
                      });
                    }}
                    onRemove={() => {
                      this.setState({practiceUrllist: []});
                      setFieldsValue({'practiceScheduleUrl': ''});
                    }}
                  >
                    <Button>
                      <Icon type="upload" /> 上传文件
                    </Button>
                  </Upload>
                )}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout1} label="实操培训地点">
                {getFieldDecorator('address', {
                  initialValue: this._getDefaultValue('address'),
                  rules: [
                    {
                      required: true,
                      message: '请输入实操培训地点',
                    },
                  ],
                })(<Input.TextArea rows={4} placeholder="请输入实操培训地点" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout1} label="注意事项">
                {getFieldDecorator('attention', {
                  initialValue: this._getDefaultValue('attention'),
                  rules: [
                    {
                      required: true,
                      message: '注意事项',
                    },
                  ],
                })(<Input.TextArea rows={4} placeholder="注意事项" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={5}>
              <Title>结业考试</Title>
            </Col>
            <Col span={19}>
              <Em>结业-理论考试默认采用App考试，请到“培训考试-试卷管理”创建考试试卷；人员可在理论考试时间内通过App在线考试。</Em>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout2} label="理论考试时间">
                {getFieldDecorator('graduateComputerDate', {
                  initialValue: this._getDefaultValue(['graduateComputerStartDate', 'graduateComputerEndDate']),
                  rules: [{ required: true, message: '请选择理论考试时间' }],
                })(<RangePicker
                  style={{width: '100%'}}
                  renderExtraFooter={() => ''} showTime
                  disabledDate={current => {
                    return current < moment(this.state.requestDate).add(9,'days').endOf('day');
                  }}
                  // disabledTime={}
                  format="YYYY-MM-DD HH:mm:ss"
                />)}
              </Form.Item>
            </Col>
            </Row>
            <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout2} label="理论考试地点">
                {getFieldDecorator('graduateComputerAddress', {
                  initialValue: this._getDefaultValue('graduateComputerAddress'),
                  rules: [{ required: true, message: '请输入理论考试地点' }],
                })(<Input placeholder="理论考试地点" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="考试方式">
                {getFieldDecorator('graduateComputerMode', {
                  initialValue: this._getDefaultValue('graduateComputerMode', '3'),
                  rules: [{ required: true, message: '请选择考试方式' }],
                })(
                  <Select>
                    <Option disabled value="1">线下</Option>
                    <Option disabled value="2">web</Option>
                    <Option value="3">app</Option>
                  </Select>
                )}
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="考试试卷">
                {getFieldDecorator('paperId', {
                  initialValue: this._getDefaultValue('paperId'),
                  rules: [{ required: true, message: '考试试卷' }],
                })(
                  <Select>
                    {
                      this.state.papers.map((item, index) => {
                        return (
                          <Option key={index} value={item.paperID}>{item.paperName}</Option>
                        );
                      })
                    }
                  </Select>
                )}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout2} label="实操考试时间">
                {getFieldDecorator('graduatePracticeDate', {
                  initialValue: this._getDefaultValue(['graduatePracticeStartDate', 'graduatePracticeEndDate']),
                  rules: [{ required: true, message: '请选择实操考试时间' }],
                })(<RangePicker
                  style={{width: '100%'}}
                  renderExtraFooter={() => ''} showTime
                  disabledDate={current => {
                    return current < moment(this.state.requestDate).add(9,'days').endOf('day');
                  }}
                  // disabledTime={}
                  format="YYYY-MM-DD HH:mm:ss"
                />)}
              </Form.Item>
            </Col>
            </Row>
            <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout2} label="实操考试地点">
                {getFieldDecorator('graduatePracticeAddress', {
                  initialValue: this._getDefaultValue('graduatePracticeAddress'),
                  rules: [{ required: true, message: '请输入实操考试地点' }],
                })(<Input placeholder="请输入实操考试地点" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={5} style={{ textAlign: 'right', marginTop: 5 }}>
              <em>
                <span style={{ color: '#f5222d' }}>*</span>
                合格条件:
              </em>
            </Col>
            <Col span={19} style={{ textAlign: 'left' }}>
              <label>
                理论成绩>=
                <InputNumber
                  min={1} max={100} step={1}
                  value={outFormData.graduateComputerScoreLimit}
                  onChange={(value) => {
                    this._setOutField('graduateComputerScoreLimit', value);
                  }}
                  style={{ width: 80, border: (this.state.licked && this._isErrorScore(outFormData.graduateComputerScoreLimit)) ? '1px solid #f5222d' : '1px solid #d9d9d9' }} placeholder="" />
              </label>
              <label>
                分且实操成绩>=
                <InputNumber
                  value={outFormData.graduatePracticeScoreLimit}
                  min={1} max={100} step={1}
                  onChange={value => {
                    this._setOutField('graduatePracticeScoreLimit', value);
                  }}
                  style={{ width: 80, border: (this.state.licked && this._isErrorScore(outFormData.graduatePracticeScoreLimit)) ? '1px solid #f5222d' : '1px solid #d9d9d9' }} placeholder=""
                />
              </label>
              分，则为合格。
            </Col>
          </Row>

          <br />
          <Row gutter={16}>
            <Col span={5}>
              <Title>鉴定考试</Title>
            </Col>
            <Col span={19}>
              <Em>注：鉴定-理论考试默认采用线下纸质考试，届时考试成绩产出后，可导入到系统中。</Em>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout2} label="理论考试时间">
                {getFieldDecorator('identifyComputerDate', {
                  initialValue: this._getDefaultValue(['identifyComputerStartDate', 'identifyComputerEndDate']),
                  rules: [{ required: true, message: '请选择理论考试时间' }],
                })(<RangePicker
                  style={{width: '100%'}}
                  renderExtraFooter={() => ''} showTime
                  disabledDate={current => {
                    return current < moment(this.state.requestDate).add(14,'days').endOf('day');
                  }}
                  // disabledTime={}
                  format="YYYY-MM-DD HH:mm:ss"
                />)}
              </Form.Item>
            </Col>
            </Row>
            <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout2} label="理论考试地点">
                {getFieldDecorator('identifyComputerAddress', {
                  initialValue: this._getDefaultValue('identifyComputerAddress'),
                  rules: [{ required: true, message: '请输入理论考试地点' }],
                })(<Input placeholder="请输入理论考试地点" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout2} label="实操考试时间">
                {getFieldDecorator('identifyPracticeDate', {
                  initialValue: this._getDefaultValue(['identifyPracticeStartDate', 'identifyPracticeEndDate']),
                  rules: [{ required: true, message: '请输入实操考试时间' }],
                })(<RangePicker
                  style={{width: '100%'}}
                  renderExtraFooter={() => ''} showTime
                  disabledDate={current => {
                    return current < moment(this.state.requestDate).add(14,'days').endOf('day');
                  }}
                  // disabledTime={}
                  format="YYYY-MM-DD HH:mm:ss"
                />)}
              </Form.Item>
            </Col>
          </Row>
            <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout2} label="实操考试地点">
                {getFieldDecorator('identifyPracticeAddress', {
                  initialValue: this._getDefaultValue('identifyPracticeAddress'),
                  rules: [{ required: true, message: '请输入实操考试地点' }],
                })(<Input placeholder="请输入实操考试地点" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16} style={{ textAlign: 'left' }}>
            <Col span={5} style={{ textAlign: 'right', marginTop: 5 }}>
              <em>
                <span style={{ color: '#f5222d' }}>*</span>
                合格条件:
              </em>
            </Col>
            <Col span={19}>
              <label>
                理论成绩>=
                <InputNumber
                  min={1} max={100} step={1}
                  value={outFormData.identifyComputerScoreLimit}
                  onChange={value => {
                    this._setOutField('identifyComputerScoreLimit', value);
                  }}
                  style={{ width: 80, border: (this.state.licked && this._isErrorScore(outFormData.identifyComputerScoreLimit)) ? '1px solid #f5222d' : '1px solid #d9d9d9' }} placeholder="" />
              </label>
              <label>
                分且实操成绩>=
                <InputNumber
                  min={1} max={100} step={1}
                  value={outFormData.identifyPracticeScoreLimit}
                  onChange={value => {
                    this._setOutField('identifyPracticeScoreLimit', value);
                  }}
                  style={{ width: 80, border: (this.state.licked && this._isErrorScore(outFormData.identifyPracticeScoreLimit)) ? '1px solid #f5222d' : '1px solid #d9d9d9' }} placeholder="" />
              </label>
              分，则为合格。
            </Col>
            <Col span={3}><span></span></Col>
          </Row>

        </Form>

        <Turnover
          classStatus={this.state.classStatus}
          scoreState={this.state.scoreState}
          gradeClassId={this.state.gradeClassId}
          visible={this.state.classPersonsShow}
          fromType='new'
          setParentState={this._setParentState}
        />   
       

        {/* <SelectStudents
          gradeClassId={this.state.gradeClassId}
          visible={this.state.selectStudentsShow}
          setParentState={this.setState.bind(this)}
          onSub={this._submitData}
          onOk={() => {
            this.setState({info:null})
            this.props.setParentState && this.props.setParentState({
              classInfoShow: false,  // 关闭弹窗
              forceUpdate: true,
            }, () => {
              this.props.setParentState({
                forceUpdate: false
              });
            });
            $modal('提交成功！', '', null, 'success');
          }}
        /> */}
      </Modal>
    );
  }
}

const Title = st.div`
  font-size: 16px;
  text-align: right;
  font-weight: bold;
`;
const Em = st.em`
  color: #F59A23;
  // margin-left: 15px;
  margin-bottom: 15px;
  font-size: 14px;
  display: block; 
  text-align: left;
`