import React, { PureComponent } from 'react';
import { Tabs } from 'antd';
import style from "styled-components";

const store = require("store");

const { TabPane } = Tabs;

export default class ComparisonPersonnel extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // currentURL: "http://114.116.191.105:8010/ars-web/user/saas/toPage.json?pageType=014&sessionId=1250641839AC7A71729102674272AD1013B6750B71834A438C66C3A573CC823340CA7E981C9EE0BC4979E9FADE17972DF26AE9406B441762EA190ABAB1B3BD61",
    };
  }

  componentDidMount = () => {
  }
  render() {
    return (
      <Container>
        <Tabs>
          <TabPane tab="资格证比对人员名单" key="1" />
        </Tabs>
        {store.get("comparisonPersonnelUrl") !== undefined ? 
          (
          <div style={{ height: "inherit" }}>
            <iframe
              title="打印记录"
              src={store.get("comparisonPersonnelUrl")["comparisonPersonnelUrl"]}
              // src={this.state.currentURL}
              width="100%"
              height="100%"
              frameBorder="0"
              allowFullScreen={true}
              allowtransparency="true">
              您的浏览器不支持iframe，请升级
            </iframe>
          </div>
        ) 
        : ''
        }
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
`;
