import React, { Component } from 'react';
import { connect } from 'dva';
import { withRouter } from 'dva/router';

import PTable from '../../../components/Pro/PTable';
import SearchForm from './SearchForm';
import PersonModal from './PersonModal';
import ContranctModal from './ContranctModal';
import PlaceModal from './PlaceModal';
import SchedulingModal from './SchedulingModal';
import BaseInfoModal from './BaseInfoModal';
import columnsFun from './columns';
import ExcelButtonOline from '../../../components/ExcelButtonOline';
import {
  Alert,
  Button,
  Modal,
  Tabs
} from "antd";
const { TabPane } = Tabs;
@connect(state => ({
  global: state.global
}))
@withRouter
export default class Uninsured extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false,
      pageParm: { //任务列表请求参数
        pageSize: '10',
        pageNumber: '1'
      },
      paramsInit: false, //参数是否准备好

      taskName: '', //任务名称
      comTaskId: '',  //查看详情的id,
      personCountVisible: false, //驻勤人数弹窗
      ontranctVisible: false,  //合同弹窗
      placeVisible: false,  //考勤点弹窗
      schedulingVisible: false,  //排班弹窗
      baseInfoVisible: false, // 驻勤基础信息弹窗
      taskStatusValue: '', //当前的驻勤状态
    }
  }


  componentWillReceiveProps(props) {

  }
  componentDidMount() {

  }
  _search = (values) => {
    // console.log(values)
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values,
        province:values.taskAddress?values.taskAddress[0]:'',
        city:values.taskAddress?values.taskAddress[1]:'',
        area:values.taskAddress?values.taskAddress[2]:'',
      },
      paramsInit: true
    });
  }
  // 任务id， 类型， 任务名称， 任务状态
  _showModal = (comTaskId, type, taskName, taskStatusValue, recordDate) => {
    taskName =  taskName? taskName: '',
    this.setState({
      comTaskId,
      taskName,
      taskStatusValue,
      recordDate
    }, () => {
      switch (type) {
        case '0':
          this.setState({
            personCountVisible: true, //驻勤人数弹窗
          });
          break;
        case '1':
          this.setState({
            ontranctVisible: true,  //合同弹窗
          });
          break;
        case '2':
          this.setState({
            placeVisible: true,  //考勤点弹窗
          });
          break;
        case '3':
          this.setState({
            schedulingVisible: true  //人员排班
          });
          break;
        case '4':
          this.setState({
            baseInfoVisible: true  //编辑
          });
      }
    });
  }
  _updateTable = () => {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
  }
  render() {
    const columns = columnsFun.call(this);
    return (
      <div style={{ padding: "0 20px" }}>
        <Tabs>
          <TabPane tab="驻勤值守" key="1"/>
        </Tabs>
        <Alert
          message={<div>
            <span>
              驻勤：适用于机动人员/驻勤人员/保安执勤/灵活上下班时间、地点的人员考勤，支持自由排班、轨迹记录。
            </span>
            {/* <br />
            <span style={{ color: 'red' }}>
              保安员考勤任务，推荐请使用本功能！
            </span> */}
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <SearchForm
          style={{ marginLeft: 10 }}
          onSearch={this._search}
        />

        {/* <section style={{ marginTop: 15 }}>
          <Button
            type="primary"
            onClick={() => {
              this.props.history.push('/taskmanager/tasklist/newtask');
            }}
          >
            创建驻勤值守
          </Button>
          <ExcelButtonOline 
            style={{marginLeft:'15px'}}
            params={this.state.pageParm}
            apiurl="/task/export-task-list" 
            downloadname={'驻勤点信息'}
            >
            导出驻勤点信息
          </ExcelButtonOline>
        </section> */}
        {
          this.state.paramsInit &&
          <PTable
            scroll={{ x: 1600 }}
            style={{ marginTop: 20 }}
            columns={columns}
            url="taskManagementList"
            pageParm={this.state.pageParm}
            forceUpdate={this.state.forceUpdate}
            pagination={{ showTotal: total => `总共 ${total} 条` }}
          />
        }

        
        {/* 弹窗内容 */}


        {/* 驻勤人员管理 */}
        <PersonModal
          taskName={this.state.taskName}
          visible={this.state.personCountVisible}
          comTaskId={this.state.comTaskId}
          taskStatusValue={this.state.taskStatusValue}
          updateTable={this._updateTable}
          onCancel={() => {
            this.setState({
              comTaskId: '',
              personCountVisible: false
            });
          }}
        />

        {/* 合同关联 */}
        <ContranctModal
          taskName={this.state.taskName}
          visible={this.state.ontranctVisible}
          comTaskId={this.state.comTaskId}
          updateTable={this._updateTable}
          onCancel={() => {
            this.setState({
              comTaskId: '',
              ontranctVisible: false
            });
          }}
        />

          {/* 地址管理 */}
        <PlaceModal
          taskName={this.state.taskName}
          visible={this.state.placeVisible}
          taskStatusValue={this.state.taskStatusValue}
          comTaskId={this.state.comTaskId}
          updateTable={this._updateTable}
          onCancel={() => {
            this.setState({
              comTaskId: '',
              placeVisible: false
            });
          }}
        />

        
          {/* 人员排班 */}
        <SchedulingModal 
          taskName={this.state.taskName}
          visible={this.state.schedulingVisible}
          taskStatusValue={this.state.taskStatusValue}
          comTaskId={this.state.comTaskId}
          shiftDate={this.state.recordDate}
          destroyOnClose={true}
          onCancel={() => {
            this.setState({
              comTaskId: '',
              schedulingVisible: false
            });
          }}
        />
          {/* baseInfoModal */}
        <BaseInfoModal 
          visible={this.state.baseInfoVisible}
          comTaskId={this.state.comTaskId}
          updateTable={this._updateTable}
          onCancel={() => {
            this.setState({
              comTaskId: '',
              baseInfoVisible: false
            });
          }}
        />
        
      </div>
    );
  }
}
