import React, {PureComponent} from 'react';

import CreateTaskAttendance from './CreateTask/CreateTaskAttendance';//创建驻勤-出勤设置
import UpdateTaskAttendance from './CreateTask/UpdateTaskAttendance';//创建驻勤-出勤设置

import PLoading from '../../components/Pro/PLoading'

import {taskGetStepTwoDetail, taskSaveStepTwoDetail, taskComShiftPage} from "../../services/api";

/**
 * 配置角色及权限
 */
export default class SecondStep extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      status: 0,//0加载中，1创建，2修改
      dataSource: {},
      comTaskId: this.props.dataSource.comTaskId,
      canEdit: 0,//修改范围 （0全部不可修改，1全部可以修改，2部分可以修改）
      taskStatus: this.props.dataSource.taskStatus || ''//驻勤状态
    };

  }

  /******************************生命周期******************************/

  componentWillReceiveProps = (nextProps) => {
    console.log('nextProps', nextProps.dataSource);
    let dataSource = nextProps.dataSource;
    if (dataSource.comTaskId != undefined) {
      this.setState({
        comTaskId: dataSource.comTaskId,
        taskStatus: dataSource.taskStatus
      }, () => {
        this.taskGetStepTwoDetail(this.state.comTaskId);
      });
    }
  }
  componentWillMount = () => {
    console.log('props', this.props);
    let dataSource = this.props.dataSource;
    if (dataSource.comTaskId != undefined) {
      this.setState({
        comTaskId: dataSource.comTaskId
      }, () => {
        this.taskGetStepTwoDetail(this.state.comTaskId)
      });
    }
  }
  //驻勤详情
  taskGetStepTwoDetail = (comTaskId) => {
    console.log('驻勤Id', this.state.comTaskId);
    taskGetStepTwoDetail({comTaskId}).then(({data}) => {
      console.log("驻勤详情", data);
      if (!data) {
        throw "数据异常";
      }
      console.log(data);
      //判断是否创建模式
      // （1是新增的，0是修改的）
      if (data.ISNEW === "0") {
        this.setState({
          status: 2,
          dataSource: data,
          canEdit: data.canEdit || 1
        });
      }
      if (data.ISNEW === "1") {
        console.log('是创建模式')
        this.setState({
          status: 1,
          dataSource: data,
          canEdit: data.canEdit || 1
        });
      }
    }, (err) => {
      console.log(err);
    });
  }

  //驻勤-出勤设置/编辑-第二步新增或修改
  taskSaveStepTwoDetail = (ajaxPara, resolve) => {
    console.log(ajaxPara);
    taskSaveStepTwoDetail(ajaxPara).then((data) => {
      console.log(data);
      resolve(this.props.switchStep(1));

    }, (err) => {
      console.log(err);
      resolve();
    });

  }


  /******************************ajax请求******************************/


  /******************************相关事件******************************/


  /******************************render******************************/

  render() {

    const {status, dataSource, comTaskId, canEdit} = this.state;
    console.log('往下传ID', comTaskId);
    return (
      <div>
        {status === 0 && <PLoading/>}

        {status === 1 &&
        <CreateTaskAttendance
          dataSource={dataSource}
          comTaskId={comTaskId}
          switchStep={this.props.switchStep}
          taskSaveStepTwoDetail={this.taskSaveStepTwoDetail}/>
        }

        {status === 2 &&
        <CreateTaskAttendance
          dataSource={dataSource}
          canEdit={canEdit}
          taskStatus={this.state.taskStatus}
          comTaskId={comTaskId}
          switchStep={this.props.switchStep}
          taskSaveStepTwoDetail={this.taskSaveStepTwoDetail}/>
        }
        {/*预留 修改和创建模式分开流程 */}
        {/*{status === 2 &&*/}
        {/*<UpdateTaskAttendance*/}
        {/*dataSource={dataSource}*/}
        {/*taskSaveStepTwoDetail={this.taskSaveStepTwoDetail}/>*/}
        {/*}*/}
      </div>

    );
  }
}
