import React, { Component } from "react";
import { Button, Form, Input, TreeSelect, Select, Popover } from "antd";
import {
  systemComDepartGetDepartTree,
  getPerType,
} from "../../../services/api";
import PSelect from "../../../components/Pro/PSelect";
const { Option } = Select;
@Form.create()
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // cascaderOptions: [], //驻勤级联数据
      treeData: [
        //树
        { title: "", key: "" },
      ],
      perTypeList: [], // 人员类别
    };
  }
  componentDidMount() {
    // this.__taskTreeTaskType();
    this.props.onSearch(this.props.form.getFieldsValue());
    this.departList();
    this.getPerType();
  }
  //选择部门
  departList = () => {
    const recursion = (treeData) => {
      // TreeSelect组件所需值： title， value, key, children disabled
      return treeData.map((item) => {
        item.title = item.departName;
        item.key = item.departId;
        item.value = item.departId;
        // "isExistsDataAuth": "1",  //权限 1有权限 0：没权限
        // item.disabled = item.isExistsDataAuth == 0;
        if (item.childDepart) {
          item.children = recursion(item.childDepart);
        }
        return item;
      });
    };
    // 获取到组织架构列表
    systemComDepartGetDepartTree().then((res) => {
      const DATA = recursion(res.data);
      this.setState({
        treeData: DATA,
        departId: DATA[0].key,
      });
    });
  };
  // 获取人员类别
  getPerType = (cb) => {
    getPerType({ codeType: "perType" }).then(
      (response) => {
        if (response.data) {
          if (response.data) {
            const firstValue = {
              codeType: "perType",
              codeValue: "",
              label: "全部",
            };
            const perTypeList = [firstValue, ...response.data];
            this.setState({
              perTypeList,
              // perType: perTypeList[0].codeValue
            });
            cb && cb();
          }
        }
      },
      (err) => {
        console.log(err);
      }
    );
  };
  _search = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      // 搜索的时候重置为第一页
      values.pageNumber = 1;
      values.departIds = values.departIds ? values.departIds.join(",") : "";
      this.props.onSearch(values);
    });
  };
  _reset = () => {
    this.props.form.resetFields();
    const data = this.props.form.getFieldsValue();
    this.props.onSearch(data);
  };
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}>
        <Form.Item label="关键词">
          {getFieldDecorator("keyWord", {
            initialValue: "",
          })(<Input placeholder="请输入姓名/身份证号/手机号" />)}
        </Form.Item>
        <Form.Item label="所属部门">
          {getFieldDecorator(
            "departIds",
            {}
          )(
            <TreeSelect
              style={{ width: 240 }}
              treeData={this.state.treeData}
              placeholder="请选择部门"
              allowClear
              multiple
              treeDefaultExpandAll
            />
          )}
        </Form.Item>
        <Form.Item label="人员类别">
          {getFieldDecorator("perType", {
            initialValue: "",
          })(
            <Select style={{ width: 200 }} placeholder="请选择">
              {this.state.perTypeList.map((val, key) => {
                return (
                  <Option key={key} value={val.codeValue + ""}>
                    {val.label}
                  </Option>
                );
              })}
            </Select>
          )}
        </Form.Item>
        <Form.Item label="是否安排驻勤点">
          {getFieldDecorator("isFixTask", {
            initialValue: "",
          })(
            <Select style={{ minWidth: 200 }}>
              <Option value="">全部</Option>
              <Option value="0">否</Option>
              <Option value="1">是</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="是否排班">
          {getFieldDecorator("isSchedul", {
            initialValue: "",
          })(
            <Select style={{ minWidth: 200 }}>
              <Option value="">全部</Option>
              <Option value="0">否</Option>
              <Option value="1">是</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="驻勤点名称">
          {getFieldDecorator("taskName", {
            initialValue: "",
          })(<Input placeholder="请输入" />)}
        </Form.Item>
        <Form.Item label="驻勤点状态">
          {getFieldDecorator("taskEffect", {
            initialValue: "",
          })(
            <Select style={{ minWidth: 200 }}>
              <Option value="">全部</Option>
              <Option value="0">未生效</Option>
              <Option value="1">生效</Option>
              <Option value="2">终止</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Popover
            content={(() => {
              return <p style={{ padding: 10 }}>搜索后可导出搜索结果</p>;
            })()}
            title="温馨提示："
          >
            <Button type="primary" onClick={this._search}>
              搜索
            </Button>
          </Popover>
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>
      </Form>
    );
  }
}
