import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Form, Input, Select, Button, Radio, Steps, Checkbox, InputNumber, Icon, Switch, RangePicker
} from 'antd';

import '../Task.less';

const FormItem = Form.Item;
const { Option } = Select;
const { Step } = Steps;


@connect(state => ({
  profile: state.profile,
}))


@Form.create()

export default class Information extends Component {

  state = {
    selectedTags: [],
    pagenav: {
      current: 1,
      pageSize: 10,
      showQuickJumper: true,
      showSizeChanger: true,
      showTotal: total => `总共 ${total} 条`,
      onShowSizeChange: (current, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = current;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.bbdExampersonPage();
        });
      },
      onChange: (page, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = page;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.bbdExampersonPage();
        });
      },
      total: 0,
    }
  }

  componentDidMount() {
    /* const { dispatch } = this.props;
    dispatch({
      type: 'profile/fetchBasic',
    }); */
  }

  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: 'form/submitRegularForm',
          payload: values,
        });
      }
    });
  };
  callback = (key) => {
    console.log(key);
  };

  handleChange(tag, checked) {
    const { selectedTags } = this.state;
    const nextSelectedTags = checked ?
      [...selectedTags, tag] :
      selectedTags.filter(t => t !== tag);
    console.log('You are interested in: ', nextSelectedTags);
    this.setState({ selectedTags: nextSelectedTags });
  }

  /* 验证手机号码 */
  checkPhone = (rule, value, callback) => {
    if (value && !(/^1[0-9]{10}$/).test(value)) {
      callback('请输入正确的手机号码！');
    } else {
      callback();
    }
  };


  render() {
    const { submitting } = this.props;
    const { getFieldDecorator } = this.props.form;

    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 7 },
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 12 },
        md: { span: 10 },
      },
    };

    const submitFormLayout = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 10, offset: 7 },
      },
    };

    return (
      <div className="CreateTask">
        <div className="Steps">
          <Steps current={2}>
            <Step title="基本信息" />
            <Step title="考勤配置" />
            <Step title="发布设置" />
          </Steps>
        </div>
        <Form
          onSubmit={this.handleSubmit}
          style={{ marginTop: 24 }}
        >
          <FormItem
            {...formItemLayout}
            label="选择推送范围"
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <Checkbox.Group>
                <Checkbox style={{ display: 'block' }} value="1">推送给内部员工 <span className="exclamation"><Icon type="exclamation-circle" />适用于：团队任务</span></Checkbox>
                <Checkbox style={{ display: 'block', "marginLeft": 0 }} disabled value="2">全网推送 (共享)<span className="exclamation"><Icon type="exclamation-circle" />适用于：共享任务</span></Checkbox>
              </Checkbox.Group>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="任务负责人"
          >
            {getFieldDecorator('company', {
              rules: [{
                required: true, message: '请输入',
              }],
            })(
              <div className="fjr">
                <div className="row">
                  <Button type="primary" ghost>选择人员</Button> <span className="exclamation"><Icon type="exclamation-circle" />人数限制：1人</span>
                </div>
                <div className="fjr-list"><span>负责人:<Icon type="user" />陈小二</span></div>
              </div>
              )}
          </FormItem>
          <div className="card">全网推送规则</div>
          <FormItem
            {...formItemLayout}
            label="设置共享区域"
          >
            {getFieldDecorator('address', {
              rules: [{ required: true, message: '请选择' }],
            })(
              <Select placeholder="请选择">
                <Option value="xiao">付晓晓</Option>
                <Option value="mao">周毛毛</Option>
              </Select>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="设置共享人数"
          >
            {getFieldDecorator('address', {
              rules: [{ required: true, message: '请选择' }],
            })(
              <InputNumber min={1} max={10} />
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="中心扩散范围"
          >
            {getFieldDecorator('address', {
              rules: [{ required: true, message: '请选择' }],
            })(
              <Input />
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="共享起止时间"
          >
            {getFieldDecorator('dateRange', {
              rules: [{ required: true, message: '请选择生效日期' }],
            })(
              <RangePicker placeholder={['开始日期', '结束日期']} style={{ width: '100%' }} />
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="任务性质"
            style={{ marginBottom: 0 }}
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <Radio.Group>
                <Radio className="radioStyle" value="1">固定价位(元/人) <Input style={{ display: "block" }} placeholder="请输入" /> </Radio>
                <Radio className="radioStyle" value="2">时长计价(元/小时) <Input style={{ display: "block" }} placeholder="请输入" /> </Radio>
              </Radio.Group>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="任务投保"
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <Radio.Group>
                <Radio className="radioStyle" value="1">需个人购买 <span className="exclamation"><Icon type="exclamation-circle" />适用于：团队任务</span></Radio>
                <Radio className="radioStyle" value="2">企业赠送保险</Radio>
                <Radio className="radioStyle" value="3">无需投保</Radio>
              </Radio.Group>
              )}
          </FormItem>
          <div className="card">推送给内部员工</div>
          <FormItem
            {...formItemLayout}
            label="选择参与人员"
          >
            {getFieldDecorator('fax', {
              rules: [{
                required: false,
              }, {
                validator: this.checkPhone
              }],
            })(
              <div>
                <Button type="primary" onClick={this.showModal} ghost>选择人员</Button>
                <div>参与人员</div>
              </div>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="选择抄送人员"
          >
            {getFieldDecorator('fax', {
              rules: [{
                required: false,
              }, {
                validator: this.checkPhone
              }],
            })(
              <div>
                <Button type="primary" onClick={this.showModal} ghost>选择人员</Button>
                <div>抄送人员</div>
              </div>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="任务投保"
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <Radio.Group>
                <Radio className="radioStyle" value="1">企业赠送保险 </Radio>
                <Radio className="radioStyle" value="2">无需投保</Radio>
                <Radio className="radioStyle" value="3">需个人购买</Radio>
              </Radio.Group>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="开关控制"
          >
            <div className="Switch-box">
              <div>任务实名啐证:<Switch checkedChildren="开" unCheckedChildren="关" defaultChecked /></div>
              <div>参与人员上报:<Switch checkedChildren="开" unCheckedChildren="关" defaultChecked /></div>
              <div>任务轨迹上报:<Switch checkedChildren="开" unCheckedChildren="关" defaultChecked /></div>
              <div>热力图呈现:<Switch checkedChildren="开" unCheckedChildren="关" defaultChecked /></div>
              <div>任务步数记录:<Switch checkedChildren="开" unCheckedChildren="关" defaultChecked /></div>
            </div>
          </FormItem>
          <FormItem {...submitFormLayout} style={{ marginTop: 32 }}>
            <Button loading={submitting}>
              暂存
            </Button>
            <Button type="primary" style={{ marginLeft: 8 }} htmlType="submit">确认发布</Button>
          </FormItem>
        </Form>
      </div >
    );
  }
}

