import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import {
  Input,
  DatePicker,
  Alert
} from 'antd';
import { withRouter } from 'dva/router';
import moment from 'moment';
import { getYffSubsidyInfo } from '../../../../services/api';
import columnFun from './columns';
import tablePage from '../../../../utils/hoc/tablePage';

const { RangePicker } = DatePicker;
@connect(state => ({
  global: state.global
}))
@tablePage()
@withRouter
export default class Issued extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      params: null,
      perTypeList: [], // 人员类别
      agesRange: [], //年龄范围
      statisticsData: null,//统计数据
      updateIssued: false
    };
  }

  componentDidMount() {
    //获取搜索结果统计数据
    getYffSubsidyInfo({ subsidyType: '1' }).then(res => {
      this.setState({
        statisticsData: res.data
      })
    })
  }
  componentWillReceiveProps(nextProps) {
    if (this.state.updateIssued !== nextProps.updateIssued) {
      this.setState({
        updateIssued: nextProps.updateIssued
      },()=>{
        if(this.state.updateIssued){
          this.props.updateTable()
        }
      })
    }
  }

  // 表格渲染
  __renderOrderList = () => {
    const columns = columnFun.call(this);
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        columns={columns}
        url="getYffSubsidyList"
        // scroll={{ x: '3200px' }}
        pagination={{ showTotal: total => `总共 ${total} 条` }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator, setFieldsValue } = this.props.form;
    const { statisticsData } = this.state
    return (
      <div className="tab_inner">
        <Alert
          message={<div style={{ color: '#333' }}>
            <span>本页面可查看已发放的记录，若需要查询企业钱包交易的电子回单，请访问企业钱包-收支明细页面查询。</span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <SearchForm
          arrange={values => {
            values.subsidyType = '1'
            const { date } = values;
            if (date.length == 2) {
              values.startTime = moment(date[0]).format('YYYY-MM-DD');
              values.endTime = moment(date[1]).format('YYYY-MM-DD');
            } else {
              values.startTime = '';
              values.endTime = '';
            }
            Reflect.deleteProperty(values, 'date');
            return values;
          }}
        >
          <Form>
            <Form.Item label="批次名称">
              {getFieldDecorator('batchName', {
                initialValue: ''
              })(
                <Input style={{ width: 240 }} placeholder="请输入批次名称" />
              )}
            </Form.Item>
            <Form.Item label="补贴对象名称">
              {getFieldDecorator('subsidyObject', {
                initialValue: []
              })(
                <Input style={{ width: 240 }} placeholder="请输入补贴对象名称" />
              )}
            </Form.Item>
            <Form.Item label="申请时间">
              {getFieldDecorator('date', {
                initialValue: []
              })(
                <RangePicker
                  style={{ width: 240 }}
                  format={'YYYY-MM-DD'}
                />
              )}
            </Form.Item>
          </Form>
        </SearchForm>
        {
          statisticsData && <div style={{ paddingTop: '10px' }}>
            搜索结果统计：待发放总笔数：<Yellow>{statisticsData.grantCount}</Yellow> | 待发放总金额（元）：<Yellow>{statisticsData.grantAmount}</Yellow>
          </div>
        }
        {/* 表格 */}
        {this.__renderOrderList()}
      </div >
    );
  }
}

const Yellow = st.span`
  color: orange
`;