// 陕西的新增报名页面
import React, { Component } from 'react';
import style from 'styled-components';
import { connect } from 'dva';
import {
  Breadcrumb,
  Alert,
  Form,
  Row,
  Col,
  Input,
  Upload,
  Icon,
  InputNumber,
  Cascader,
  Table,
  DatePicker,
  Select,
  Button,
  Popconfirm,
  Modal,
  message
} from 'antd';
import { Link } from 'dva/router';
import {
  getBayBaseInfo,
  getTreeperBydepart,
  checkIsSetRegulator,
  getDistrictData,
  getConfigBayzgzSb,
  bayzgzTempSave,
  bayzgzSave,
  getBayzgzSbInfoById,
  bayzgzCheckResubmit,
  getPerAuthRecordbyId,
  checkIsExistsEffectBayzgz,
  getComContractListByPerId
} from '../../../services/api';
import PFromUpload from '../../../components/Pro/PFromUpload';
import $perModal from '../../../utils/modal/perModal';
import moment from 'moment';
import PSelect from '../../../components/Pro/PSelect';
import { withRouter } from 'dva/router';
import SelectContactByPerId, { colFn } from '../../../components/contranct/SelectContactByPerId';
import { checkMember, checkPerCanSignUp } from '../../../utils/utils';
import PCascader from '../../../components/Pro/PCascader';

const formItemLayout = {
  labelCol: {
    span: 6
  },
  wrapperCol: {
    span: 18
  }
};
const tipLayout = {
  labelCol: {
    span: 3
  },
  wrapperCol: {
    span: 21
  }
};
const photoItemLayout = {
  labelCol: {
    xl: {
      span: 12
    },
    xxl: {
      span: 8
    }
  },
  wrapperCol: {
    xl: {
      span: 12
    },
    xxl: {
      span: 16
    }
  }
};

const addressLayout = {
  labelCol: {
    lg: {
      span: 0
    },
    xl: {
      span: 0
    },
    xxl: {
      span: 0
    }
  },
  wrapperCol: {
    lg: {
      span: 24
    },
    xl: {
      span: 24
    },
    xxl: {
      span: 24
    }
  }
};

const dateFormat = 'YYYY-MM-DD';
const { Option } = Select;
@connect(state => ({
  companyInfo: state.global.companyInfo
}))
@Form.create()
@withRouter
export default class FillIn extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      isAddOrEdit: true, //编辑或者是新增页面（true是新增，false是编辑，默认是新增页面）
      basicInfoStatus: false, //基础信息是否展示（新增页面要判断有无选择人员，修改页面默认展示）
      bayzgzSbId: '', //
      treeData: [
        // 部门数据
        //树
        { title: '', key: '' }
      ],
      comName: this.props.companyInfo.comName,
      areas: [], //省市区
      perInfo: {
        //人员基础信息
        name: null,
        mobilePhone: null,
        idCardNo: null,
        birthday: null,
        sex: null,
        height: null,
        education: null,
        residenceAddress: null,
        domicileProvince: null,
        domicileCity: null,
        domicileArea: null,
        domicileAddress: null,
        nation: null
      },
      perId: null,
      perIdName: '', //perId对应的人名
      bayConfigInfo: [], //保安员的配置信息
      photo: {
        colourPhotoUrl: '',
        idCardFrontUrl: '',
        idCardReverseUrl: '',
        eduCerUrl: '',
        hospitalExamProveUrl: ''
      },
      isConfig: true, //新增页面判断是否有配置
      key: 0, //用来重置图片的路径用
      repetitionStatus: false, //选中的人员是否重复
      buttonStatus: false, //提交按钮是否置灰

      // comContractList: [], //选中的合同列表
    };
  }
  componentWillMount() {
    this.__getDepart();
    // this.__getDistrict();
    this.__getConfigBayzgzSb();
    if (this.props.location.bayzgzSbId) {
      //是编辑页面
      // this._getBayzgzSbInfoById(this.props.location.bayzgzSbId); //获取人员的详细信息
      this.getPersonInfo(this.props.location.bayzgzSbId); //获取人员的详细信息
      this.setState({
        isAddOrEdit: false,
        bayzgzSbId: this.props.location.bayzgzSbId,
        basicInfoStatus: true
      });
    } else {
      //是新增页面
      /**
       *先判断该企业是否有配置
       *0：代表未设置 1：代表已设置
       */
      this.__checkIsSetRegulator();
      this.setState({
        isAddOrEdit: true,
        basicInfoStatus: false,
      }, () => {
        if (this.props.location.perInfo) { //未持证列表跳转过来的页面
          const info = JSON.parse(this.props.location.perInfo);
          this.setState({
            perId: info.perId || null,
            perIdName: info.perIdName || '',
            perInfo: {
              ...this.state.perInfo,
              ...info
            },
            basicInfoStatus: true,
          }, () => {
            // this.__getComContractListByPerId();
          });
        }
      });
    }
  }
  componentDidMount() {
  }
  //该企业是否有配置
  __checkIsSetRegulator() {
    checkIsSetRegulator({
      regulatorType: '2'
    }).then(data => {
      const that = this;
      if (data.retType === '0') {
        if (data.data === '1') {
          this.setState({
            isConfig: true
          });
        } else {
          this.setState({
            isConfig: false
          });
          Modal.warning({
            title: '该企业暂未设置监管机构，请先设置',
            okText: '前往设置',
            onOk() {
              that.props.history.replace('/enterprise/regulator-set');
            }
          });
        }
      }
    });
  }
  // 获取人员合同列表
  // __getComContractListByPerId() {
  //   const { perId, comContractId } = this.state;
  //   getComContractListByPerId({ perId, pageNumber: 1, pageSize: 100 }).then(res => {
  //     const contractInfo = res.data.data.find(item => item.comContractId == comContractId);
  //     const comContractList = [];
  //     contractInfo && comContractList.push(contractInfo);
  //     this.setState({ comContractList });
  //   });
  // }
  //修改页面中获取详情信息
  _getBayzgzSbInfoById(bayzgzSbId) {
    getBayzgzSbInfoById({
      bayzgzSbId
    }).then(res => {
      log(res.data, 'res.data')
      if (res.retType === '0') {
        const { comContractId } = res.data;
        this.setState({
          perInfo: {
            ...res.data
          },
          perId: bayzgzSbId,
          comContractId,
          photo: {
            colourPhotoUrl: res.data.colourPhotoUrl || '',
            idCardFrontUrl: res.data.idCardFrontUrl || '',
            idCardReverseUrl: res.data.idCardReverseUrl || '',
            eduCerUrl: res.data.eduCerUrl || '',
            hospitalExamProveUrl: res.data.hospitalExamProveUrl || ''
          },
          perIdName: res.data.name
        }, () => {
          if (comContractId) {
            this.props.form.setFieldsValue({
              idCardFrontUrl: res.data.idCardFrontUrl || '',
              idCardReverseUrl: res.data.idCardReverseUrl || ''
            });
            // this.__getComContractListByPerId();
          }
        });
      }
    });
  }
  //获取部门树数据
  __getDepart = cb => {
    getTreeperBydepart().then(
      response => {
        const responseData = checkMember(response.data);
        this.setState({ treeData: responseData });
      },
      err => {
        this.setState({
          loading: false
        });
        console.log(err, 'err-部门人员-getTreeperBydepart');
      }
    );
  };
  //获取人员信息
  getPersonInfo(perId) {
    getBayBaseInfo({ perId }).then(res => {
      const that = this;
      if (res.retType === '0') {
        that.setState({
          perInfo: res.data,
          basicInfoStatus: true,
          perId,
          photo: {
            colourPhotoUrl: res.data.colourPhotoUrl || '',
            idCardFrontUrl: res.data.idCardFrontUrl || '',
            idCardReverseUrl: res.data.idCardReverseUrl || '',
            eduCerUrl: res.data.eduCerUrl || '',
            hospitalExamProveUrl: res.data.hospitalExamProveUrl || ''
          },
        }, () => {
          const { setFieldsValue } = this.props.form;
          this.props.form.resetFields()
          setFieldsValue({
            perIdName: this.state.perInfo.name,
            name: this.state.perInfo.name,
            mobilePhone: this.state.perInfo.mobilePhone,
            idCardNo: this.state.perInfo.idCardNo,
            colourPhotoUrl: res.data.colourPhotoUrl,
            birthday: this.state.perInfo.birthday ? moment(this.state.perInfo.birthday, dateFormat) : null,
            sex: this.state.perInfo.sex,
            height: this.state.perInfo.height,
            nation: this.state.perInfo.nation,
            education: this.state.perInfo.education,
            residentFullAddress: this.state.perInfo.residentFullAddress,
            domicile: this.state.perInfo.domicileProvince ? [
              this.state.perInfo.domicileProvince,
              this.state.perInfo.domicileCity,
              this.state.perInfo.domicileArea
            ] : [],
            domicileAddress: this.state.perInfo.domicileAddress,
            idCardFrontUrl: this.state.photo.idCardFrontUrl,
            idCardReverseUrl: this.state.photo.idCardReverseUrl,
          });
          this.setState({
            key: Math.random(),
          });
        });
        if (!!!res.data.colourPhotoUrl) {
          Modal.warning({
            title:
              '此人暂未有一寸免冠白底彩照，请通知该员工登录App-工作-证件照采集页面进行采集。'
          });
        }
      }
    });
  }
  //获取保安员配置是否必填
  __getConfigBayzgzSb() {
    getConfigBayzgzSb().then(res => {
      if (res.retType === '0') {
        this.setState({
          bayConfigInfo: res.data
        });
      }
    });
  }
  //校验该保安员资格证是否重复提交
  _bayzgzCheckResubmit(perId, cb) {
    bayzgzCheckResubmit({ perId }).then(res => {
      // const that = this
      if (res.retType === '0') {
        if (res.data === 0) {
          //不可以报名
          this.props.form.resetFields();
          this.setState({
            repetitionStatus: 0,
            perId: null,
            perIdName: ''
          });
          Modal.warning({
            title: '不可以报名:报名已经审核通过或者审核中',
            okText: '确定',
            onOk() {
            }
          });
        } else if (res.data === 2) {
          //不可以报名
          this.props.form.resetFields();
          this.setState({
            // basicInfoStatus: false
            repetitionStatus: 2,
            perId: null,
            perIdName: ''
          });
          Modal.warning({
            title: '不可以报名:此人报名存在暂存未提交记录',
            okText: '确定',
            onOk() {
            }
          });
        } else {
          //可以报名
          this.setState({
            // basicInfoStatus: false
            repetitionStatus: false
          });

          cb && cb();
          //可以提交的时候再去请求人员数据信息
          // this.getPersonInfo(perId);
        }
      }
    });
  }
  //通过身份证计算出年龄
  _getAge(idCardNo) {
    const len = idCardNo.length;
    if (len == 0) {
      return '';
    } else {
      if ((len != 15) && (len != 18))//身份证号码只能为15位或18位其它不合法
      {
        return '';
      }
    }
    let strBirthday = "";
    if (len == 18)//处理18位的身份证号码从号码中得到生日和性别代码
    {
      strBirthday = idCardNo.substr(6, 4) + "/" + idCardNo.substr(10, 2) + "/" + idCardNo.substr(12, 2);
    }
    if (len == 15) {
      strBirthday = "19" + idCardNo.substr(6, 2) + "/" + idCardNo.substr(8, 2) + "/" + idCardNo.substr(10, 2);
    }
    //时间字符串里，必须是“/”
    var birthDate = new Date(strBirthday);
    var nowDateTime = new Date();
    var age = nowDateTime.getFullYear() - birthDate.getFullYear();
    //再考虑月、天的因素;.getMonth()获取的是从0开始的，这里进行比较，不需要加1
    if (nowDateTime.getMonth() < birthDate.getMonth() || (nowDateTime.getMonth() == birthDate.getMonth() && nowDateTime.getDate() < birthDate.getDate())) {
      age--;
    }
    return age;
  }
  errModal(param) {
    Modal.warning({
      title: param,
      okText: '知道了'
    });
    this.setState({
      buttonStatus: false
    });
  }
  //提交（跟提交并添加）
  async _submit(param) {
    if (!!!this.state.perId) {
      this.errModal('请先选择人员');
      return;
    }
    if (!!!this.state.photo.colourPhotoUrl) {
      this.errModal(
        '此人暂未有一寸免冠彩照，请通知该员工登录App-工作-证件照采集页面进行采集。'
      );
      return;
    }
    let param2 = true;
    if (this.props.location.bayzgzSbId !== '') {
      //是编辑页面，1、有暂存过的，可以提交。2、有提交过的，不能提交
      if (this.state.repetitionStatus === 2) {
        //有提交过的
        param2 = false;
        this.errModal('不可以报名:此人报名存在暂存未提交记录');
        return;
      }
    } else {
      //是新增页面。1、有暂存过的，不能提交。2、有提交过的，不能提交
      if (this.state.repetitionStatus === 0) {
        //有暂存过的
        param2 = false;
        this.errModal('不可以报名:报名已经审核通过或者审核中');
        return;
      }
      if (this.state.repetitionStatus === 2) {
        //有提交过的
        param2 = false;
        this.errModal('不可以报名:此人报名存在暂存未提交记录');
        return;
      }
    }
    if (param2) {
      this.props.form.validateFields((err, values) => {
        let data = values;
        let hasError = false;
        if (!err) {
          if (values.education == '1') {
            this.errModal('学历必须是初中及初中以上');
            hasError = true;
            return;
          }
          if (!!!hasError) {
            //信息都完善的情况下
            if (
              data.birthday &&
              data.birthday !== undefined &&
              data.birthday !== null
            ) {
              data.birthday = data['birthday'].format(dateFormat);
            } else {
              data.birthday = '';
            }
            let value = {
              perId: this.state.perId,
              name: data.name,
              idCardNo: data.idCardNo,
              sex: data.sex,
              birthday: data.birthday,
              mobilePhone: data.mobilePhone,
              domicileProvince: data.domicile[0],
              domicileCity: data.domicile[1],
              domicileArea: data.domicile[2],
              domicileAddress: data.domicileAddress,
              residenceAddress: data.residentFullAddress,
              education: data.education,
              height: data.height,
              comName: data.comName,
              ...this.state.photo,
              residentPlaceType: data.residentPlaceType,
              // comContractId: this.state.comContractList.length > 0 ? this.state.comContractList[0].comContractId : '',
              hospitalExamProveUrl: data.hospitalExamProveUrl,
              nation: data.nation,
              // officeArea: data.officeArea
            };
            console.log(value)
            bayzgzSave(value)
              .then(data => {
                const that = this;
                if (data.retType === '0') {
                  //提交完成之后放开按钮的可提交状态
                  this.setState({
                    buttonStatus: false
                  });
                  if (param === 'goOn') {
                    Modal.success({
                      title: '提交成功！',
                      content: '您可以在报名列表查看该人员的报名信息。',
                      // okText: '到《未持证人员》列表中接续报名',
                      okText: '到列表中接续报名',
                      onOk() {
                        // that.props.history.push('/PoliceDeclare/sign-up?tab=2');
                        that.props.history.push('/PoliceDeclare/qualifications');
                      }
                    });
                  } else {
                    Modal.success({
                      title: '提交成功！',
                      content: '您可以在报名列表查看该人员的报名信息。',
                      okText: '返回报名列表',
                      onOk() {
                        that.props.history.push('/PoliceDeclare/qualifications');
                      }
                    });
                  }
                }
              })
              .catch(() => {
                //提交完成之后放开按钮的可提交状态
                this.setState({
                  buttonStatus: false
                });
              });
          }
        } else {
          this.setState({
            buttonStatus: false
          });
        }
      });
    }
  }
  //验证手机号码
  checkPhone = (rule, value, callback) => {
    if (value && !/^1[0-9]{10}$/.test(value)) {
      callback('请输入正确的手机号码！');
    } else {
      callback();
    }
  };
  //验证证件号
  checkIdCardNo = (rule, value, callback) => {
    const { form } = this.props;
    const cardNoValue = form.getFieldValue('idCardType');
    if (
      cardNoValue === '1' &&
      value &&
      !/(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value)
    ) {
      callback('请输入正确的身份证号码！');
    } else {
      callback();
    }
  };
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Box style={{ margin: '16px 0 8px 24px' }}>
        <Breadcrumb>
          <Breadcrumb.Item>
            <Link to="/PoliceDeclare/qualifications">报名记录</Link>
          </Breadcrumb.Item>
          <Breadcrumb.Item>
            {this.state.isAddOrEdit ? '新增报名' : '修改报名'}
          </Breadcrumb.Item>
        </Breadcrumb>
        <Alert
          message={
            <div style={{ color: '#333' }}>
              <span>
                人员若存在申报中/申报通过的报名记录，则无法再重新报名；申报不通过/已撤销的可以重新提交报名。
              </span>
            </div>
          }
          type="warning"
          showIcon
          style={{ marginBottom: 15, marginTop: 10 }}
        />
        {/* form表单 */}
        <Form>
          <div className="basic_container">
            <h3>报名基础信息</h3>
            <Row>
              <Col span={9}>
                <Form.Item {...formItemLayout} label="所属企业">
                  {getFieldDecorator('comName', {
                    initialValue: this.props.companyInfo.comName,
                    rules: [
                      {
                        required: true
                      }
                    ]
                  })(
                    <Input
                      placeholder="请输入"
                      // maxLength={30}
                      disabled
                    />
                  )}
                </Form.Item>
              </Col>
              <Col span={9} offset={1}>
                {
                  !this.state.basicInfoStatus &&
                  <Form.Item {...formItemLayout} label="选择人员">
                    {getFieldDecorator('perIdName', {
                      initialValue: this.state.perIdName || '',
                      rules: [
                        {
                          required: true,
                          message: '请先选择人员'
                        }
                      ]
                    })(
                      <Input
                        placeholder="请选择"
                        maxLength={30}
                        readOnly
                        onClick={() => {
                          $perModal({
                            type: 'radio',
                            onOk: async (values, close) => {
                              const { perId } = values[0]
                              // const { regProvince } = this.props.companyInfo;
                              checkIsExistsEffectBayzgz({ perId }).then(res => {
                                // if(res.data != 0) {
                                if (res.data == 1) {
                                  return;
                                  // Modal.warning({
                                  //   title: '该人员已存在保安员资格证，无法报名。'
                                  // });
                                } else {
                                  getPerAuthRecordbyId({ perId }).then(result => {
                                    if (result.data.authStatus != 1) {
                                      Modal.warning({
                                        title: '该人员尚未完成实名认证，无法报名。需通过实名认证，才可进行报名。'
                                      });
                                    } else {
                                      this._bayzgzCheckResubmit(perId, () => {
                                        this.setState({
                                          perId,
                                          perIdName: values[0].name,
                                          key: Math.random()
                                        }, () => {
                                          this.getPersonInfo(perId, res.data);
                                          // this.__getComContractListByPerId();
                                          close();
                                        });
                                      });
                                    }
                                  });
                                }
                              });
                            }
                          });
                        }}
                      />
                    )}
                  </Form.Item>
                }
              </Col>
            </Row>

            <Row>
              <Col span={9}>
                <div
                  style={{ display: this.state.basicInfoStatus ? 'block' : 'none' }}
                >
                  <Form.Item
                    {...photoItemLayout}
                    label="一寸免冠白底彩照"
                    extra={<span style={{ color: 'orange' }}>注：支持上传1M以内的jpeg|jpg文件</span>}
                    style={{ marginBottom: 0 }}
                  >
                    {getFieldDecorator(`colourPhotoUrl`, {
                      initialValue: this.state.photo.colourPhotoUrl || '',
                      rules: [
                        {
                          required:
                            this.state.bayConfigInfo.isColourPhotoRequired ===
                              '1'
                              ? true
                              : false,
                          message: `请上传一寸免冠白底彩照`
                        }
                      ]
                    })(
                      <PFromUpload
                        key={this.state.key}
                        num={1}
                        size={1}
                        types={['image/jpeg', 'image/jpg']}
                        onChange={url => {
                          this.setState({
                            photo: {
                              ...this.state.photo,
                              colourPhotoUrl: url
                            }
                          });
                        }}
                      />
                    )}
                  </Form.Item>
                </div>
              </Col>
            </Row>
            <Row>
              <Col span={9}>
                <Form.Item {...formItemLayout} label="姓名">
                  {getFieldDecorator('name', {
                    initialValue: this.state.perInfo.name || '',
                    rules: [
                      {
                        required: true,
                        message: '请输入姓名'
                      }
                    ]
                  })(<Input placeholder="请输入" disabled={true} />)}
                </Form.Item>
              </Col>
              <Col span={9} offset={1}>
                <Form.Item {...formItemLayout} label="手机号码">
                  {getFieldDecorator('mobilePhone', {
                    initialValue: this.state.perInfo.mobilePhone || '',
                    rules: [
                      {
                        required: true,
                        message: '请输入手机号码'
                      }
                    ]
                  })(<Input placeholder="请输入" disabled={true} />)}
                </Form.Item>
              </Col>
            </Row>
            <Row>
              <Col span={9}>
                <Form.Item {...formItemLayout} label="身份证号">
                  {getFieldDecorator('idCardNo', {
                    initialValue: this.state.perInfo.idCardNo,
                    rules: [
                      {
                        required: true,
                        message: '请输入身份证号'
                      }
                    ]
                  })(<Input placeholder="请输入" disabled={true} />)}
                </Form.Item>
              </Col>
              <Col span={9} offset={1}>
                <Form.Item {...formItemLayout} label="出生年月">
                  {getFieldDecorator('birthday', {
                    initialValue: this.state.perInfo.birthday
                      ? moment(this.state.perInfo.birthday, dateFormat)
                      : null,
                    rules: [
                      {
                        required: true,
                        message: '请选择出生年月'
                      }
                    ]
                  })(<DatePicker style={{ width: 214 }} format={dateFormat} />)}
                </Form.Item>
              </Col>
            </Row>

            <Row>
              <Col span={9}>
                <Form.Item {...formItemLayout} label="性别">
                  {getFieldDecorator('sex', {
                    initialValue: this.state.perInfo.sex,
                    rules: [
                      {
                        required: true,
                        message: '请选择性别'
                      }
                    ]
                  })(
                    <Select style={{ width: 214 }}>
                      <Option value="1">男</Option>
                      <Option value="2">女</Option>
                    </Select>
                  )}
                </Form.Item>
              </Col>
              <Col span={9} offset={1}>
                <Form.Item {...formItemLayout} label="身高(cm)">
                  {getFieldDecorator('height', {
                    initialValue: this.state.perInfo.height,
                    rules: [
                      {
                        required:
                          this.state.bayConfigInfo.isHeightRequired === '1'
                            ? true
                            : false,
                        message: '请输入身高'
                      }
                    ]
                  })(<InputNumber style={{ width: 214 }} placeholder="请输入" min={1} max={300} />)}
                </Form.Item>
              </Col>
            </Row>

            <Row>
              <Col span={9}>
                <Form.Item {...formItemLayout} label="文化程度">
                  {getFieldDecorator('education', {
                    initialValue: this.state.perInfo.education,
                    rules: [
                      {
                        required: true,
                        message: '请选择文化程度'
                      }
                    ]
                  })(<PSelect type="education" />)}
                </Form.Item>
              </Col>
              {/* <Col span={9} offset={1}>
                <Form.Item {...formItemLayout} label="办事区域">
                  {getFieldDecorator('officeArea', {
                    initialValue: this.state.perInfo.officeArea,
                    rules: [
                      {
                        required: true,
                        message: '请输入办事区域'
                      }
                    ]
                  })(<Input style={{ width: 214 }} placeholder="请输入办事区域" />)}
                </Form.Item>
              </Col> */}
            </Row>

            <Row>
              <Col span={18}>
                <Form.Item
                  {...tipLayout}
                  label={<div style={{ lineHeight: 1.2, display: 'inline-block' }}>户籍地址</div>}
                  style={{ paddingRight: '-10px' }}
                >
                  {getFieldDecorator('residentFullAddress', {
                    initialValue: this.state.perInfo.residentFullAddress,
                    rules: [
                      {
                        required:
                          this.state.bayConfigInfo.isResidenceRequired === '1'
                            ? true
                            : false,
                        message: '请输入保安员户籍地址信息'
                      }
                    ]
                  })(
                    <Input placeholder="请输入保安员户籍地址信息" maxLength={100} />
                  )}
                </Form.Item>
              </Col>

            </Row>
            <NoTipRow>
              <Row>
                <Col span={9}>
                  <Form.Item
                    {...formItemLayout}
                    label="现住地址"
                  >
                    {getFieldDecorator('domicile', {
                      initialValue: this.state.perInfo.domicileProvince
                        ? [
                          this.state.perInfo.domicileProvince,
                          this.state.perInfo.domicileCity,
                          this.state.perInfo.domicileArea
                        ]
                        : [],
                      rules: [
                        {
                          required:
                            this.state.bayConfigInfo.isDomicileRequired === '1'
                              ? true
                              : false,
                          message: '请选择您的现住地址!'
                        }
                      ]
                    })(
                      <PCascader placeholder="请选择" />
                    )}

                  </Form.Item>
                </Col>
                <Col span={9}>
                  <Form.Item {...addressLayout}>
                    {getFieldDecorator('domicileAddress', {
                      initialValue: this.state.perInfo.domicileAddress,
                      rules: [
                        {
                          required:
                            this.state.bayConfigInfo.isDomicileRequired === '1'
                              ? true
                              : false,
                          message: '请输入现住地址街道信息！'
                        }
                      ]
                    })(
                      <Input placeholder="现住地址街道信息(请勿重复填写省市区)" maxLength={100} />
                    )}
                  </Form.Item>
                </Col>
              </Row>
            </NoTipRow>
            <NoTipRow>
              <Row>
                <Col span={19} style={{}}>
                  <Form.Item
                    {...tipLayout}
                    label={' '}
                    colon={false}
                    extra={<span style={{ color: 'orange' }}>
                      注：请报名人员仔细核对地址，在填写框不要重复省市信息，以免证书打印的时候出现重复，造成证件作废。
                    </span>}
                  >
                  </Form.Item>
                </Col>
              </Row>
            </NoTipRow>

            <Row>
              <Col span={9}>
                <Form.Item {...photoItemLayout} label="图像材料">
                  (每张不超过:8M,格式为:jpg，jpeg，png)
                </Form.Item>
              </Col>
            </Row>
            <Row>
              <Col span={9} offset={2}>
                <Form.Item {...photoItemLayout} label="身份证人像面">
                  {getFieldDecorator(`idCardFrontUrl`, {
                    initialValue: this.state.photo.idCardFrontUrl,
                    rules: [
                      {
                        required:
                          this.state.bayConfigInfo.isIdCardFrontRequired ===
                            '1'
                            ? true
                            : false,
                        message: `请上传身份证人像面`
                      }
                    ]
                  })(
                    <PFromUpload
                      key={this.state.key}
                      num={1}
                      size={8}
                      onChange={url => {
                        this.setState({
                          photo: {
                            ...this.state.photo,
                            idCardFrontUrl: url
                          }
                        });
                      }}
                    />
                  )}
                </Form.Item>
              </Col>
              <Col span={9}>
                <Form.Item {...photoItemLayout} label="身份证国徽面">
                  {getFieldDecorator(`idCardReverseUrl`, {
                    initialValue: this.state.photo.idCardReverseUrl,
                    rules: [
                      {
                        required:
                          this.state.bayConfigInfo.isIdCardReverseRequired ===
                            '1'
                            ? true
                            : false,
                        message: `请上传身份证国徽面`
                      }
                    ]
                  })(
                    <PFromUpload
                      key={this.state.key}
                      num={1}
                      size={8}
                      onChange={url => {
                        this.setState({
                          photo: {
                            ...this.state.photo,
                            idCardReverseUrl: url
                          }
                        });
                      }}
                    />
                  )}
                </Form.Item>

              </Col>
            </Row>
            <Row>
              <Col span={9} offset={2}>
                <Form.Item {...photoItemLayout} label="初中以上学历证明原件">
                  {getFieldDecorator(`eduCerUrl`, {
                    initialValue: this.state.photo.eduCerUrl,
                    rules: [
                      {
                        required:
                          this.state.bayConfigInfo.isEduProveRequired === '1'
                            ? true
                            : false,
                        message: `请上传初中以上学历证明原件`
                      }
                    ]
                  })(
                    <PFromUpload
                      key={this.state.key}
                      num={1}
                      size={8}
                      onChange={url => {
                        this.setState({
                          photo: {
                            ...this.state.photo,
                            eduCerUrl: url
                          }
                        });
                      }}
                    />
                  )}
                </Form.Item>

              </Col>
              <Col span={9}>

                <Form.Item
                  {...photoItemLayout}
                  label={
                    <span>
                      <em style={{ marginRight: 10 }}>县级以上医院出具的</em>
                      <br />
                      体检证明(最多4张)
                    </span>
                  }
                >
                  {getFieldDecorator(`hospitalExamProveUrl`, {
                    initialValue: this.state.photo.hospitalExamProveUrl,
                    rules: [
                      {
                        required:
                          this.state.bayConfigInfo.isCheckUpProveRequired ===
                            '1'
                            ? true
                            : false,
                        message: `请上传县级以上医院出具的体检证明`
                      }
                    ]
                  })(
                    <PFromUpload
                      key={this.state.key}
                      num={4}
                      size={8}
                      onChange={url => {
                        console.log(url);
                      }}
                    />
                  )}
                </Form.Item>
              </Col>
            </Row>

            <div className="sumbitButtom" style={{ textAlign: 'center' }}>
              <Button
                type="primary"
                style={{ margin: '0 20px' }}
                disabled={this.state.buttonStatus}
                onClick={() => {
                  this.setState({
                    buttonStatus: true
                  });
                  this._submit('goOn');
                }}
              >
                提交并继续添加
              </Button>
              <Button
                type="primary"
                disabled={this.state.buttonStatus}
                style={{ margin: '0 20px' }}
                onClick={() => {
                  this.setState({
                    buttonStatus: true
                  });
                  this._submit();
                }}
              >
                提交
              </Button>
            </div>
          </div>
        </Form>
      </Box>
    );
  }
}

const Box = style.div`{
.import_salary{
          margin:16px 0 8px 24px;
      }
.miniLabelWidth .ant-form-item-label{
          width:10%;
      }
.noUpload{
  .anticon - plus,.ant - upload - text{
          display: none;
      }
    }
  }`;
const NoTipRow = style.div`{
  .ant-form-item{
    margin-bottom: 0;
  }
}`;
