import React, { PureComponent } from 'react';
// import { connect } from 'dva';
import moment from 'moment';
import "moment/locale/zh-cn";
import style from "styled-components";
import { Timeline, Icon, Row, Col, Breadcrumb } from 'antd';
import { Link } from "dva/router";
import Male from '../../../assets/images/male.png';
import Female from '../../../assets/images/female.png';
import {
  enterprisePerResumeResumeDetails,//收到简历详情
  enterpriseResumeCollectResumeDetails,//收藏简历详情
} from "../../../services/api";


// @connect(state => ({
//   monitor: state.monitor,
// }))
export default class ResumeDetails extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      currentResumeId: this.props.match.params.currentResumeId,
      type: this.props.match.params.type,
      perResumeResultDto: {},//人员基本信息和简历信息
      perWorkExperiences: [],//工作经历
      perEducatExperiences: [],//教育经历
      perCerBaseInfos: [],//证书
      // perResumeResultDto: {//人员基本信息和简历信息
      //   updateTime: "",//简历更新时间
      //   name: "",//姓名
      //   sex: "",//性别
      //   birthday: "",//出生年月
      //   mobilePhone: "",//手机号
      //   height: "",//身高
      //   education: "",//学历
      //   firstWorkDay: "",//第一次工作时间
      //   domicileProvin: "",//居住地省
      //   domicileCity: "",//居住地城市
      //   domicileArea: "",//居住地区/县
      //   domicileAddress: "",//居住地详细地址
      //   position: "",//意向职位
      //   isFullTime: "",//是否全职
      //   expectSalary: "",//期望薪资
      //   province: "",//工作地址：省
      //   city: "",//工作地址：市
      //   area: "",//工作地址：区
      // },
      // perWorkExperiences: {//工作经历
      //   workUnitName: "",//工作单位名称
      //   positionName: "",//职位名称
      //   startYears: "",//开始年月
      //   endYears: "",//结束年月
      //   workDescribe: "",//工作描述
      //   comment: "",//公司评语
      // },
      // perEducatExperiences: {//教育经历
      //   startYears: "",//开始年月
      //   endYears: "",//结束年月
      //   education: "",//学历
      //   school: "",//就读学校
      //   major: "",//专业
      // },
      // perCerBaseInfos: {//证书
      //   perCerType: "",//证书类型
      //   licenceDate: "",//发证日期
      // }
    };

  }
  /******************************生命周期******************************/

  componentDidMount = () => {
    this.getResumeDetails();//获取简历详情
    console.log("this", this);
  }
  //componentWillReceiveProps(props) {
  // this.setState({ open: props.visiable, currentId: props.currentId });
  //}
  /******************************ajax请求******************************/
  //获取简历详情
  getResumeDetails = () => {
    // const comId = 1;
    // if (this.state.sendResumeId) {
    // debugger
    if (this.state.type === '1') {
      const sendResumeIdper = this.state.currentResumeId;//收到简历ID
      console.log("sendResumeIdper", sendResumeIdper);
      if (this.state.currentResumeId) {
        enterprisePerResumeResumeDetails({ sendResumeIdper }).then((res) => {
          console.log("获取简历详情成功:", res);
          this.setState({
            perResumeResultDto: res.data.perResumeResultDto,//人员基本信息和简历信息
            perWorkExperiences: res.data.perWorkExperiences,//工作经历
            perEducatExperiences: res.data.perEducatExperiences,//教育经历
            perCerBaseInfos: res.data.perCerBaseInfos,//证书
          });
          console.log("1-人员基本信息和简历信息", this.state.perResumeResultDto);
          console.log("2-工作经历", this.state.perWorkExperiences);
          console.log("3-教育经历", this.state.perEducatExperiences);
          console.log("4-证书", this.state.perCerBaseInfos);
        }, (err) => {
          console.log("获取简历详情失败:", err);
        });
      }
    } else if (this.state.type === '2') {
      const resumeId = this.state.currentResumeId;//收藏简历ID
      console.log(" resumeId", resumeId);
      if (this.state.currentResumeId) {
        enterpriseResumeCollectResumeDetails({ resumeId }).then((res) => {
          console.log("获取简历详情成功:", res);
          this.setState({
            perResumeResultDto: res.data.perResumeResultDto,//人员基本信息和简历信息
            perWorkExperiences: res.data.perWorkExperiences,//工作经历
            perEducatExperiences: res.data.perEducatExperiences,//教育经历
            perCerBaseInfos: res.data.perCerBaseInfos,//证书
          });
          console.log("1-人员基本信息和简历信息", this.state.perResumeResultDto);
          console.log("2-工作经历", this.state.perWorkExperiences);
          console.log("3-教育经历", this.state.perEducatExperiences);
          console.log("4-证书", this.state.perCerBaseInfos);
        }, (err) => {
          console.log("获取简历详情失败:", err);
        });
      }
    }
    // }
  }

  /******************************相关事件******************************/
  displayWorkExperiences = () => {
    const arr = this.state.perWorkExperiences.map((value, index) => {
      return (
        <Row key={index}>
          <Col span={4}>
            <div>{value.startYears} 至 {value.endYears}</div>
          </Col>
          <Col span={20}>
            <Timeline>
              <Timeline.Item> {value.workUnitName}</Timeline.Item>
              <Timeline.Item>{value.positionName}  </Timeline.Item>
              <Timeline.Item dot={<Icon type="clock-circle-o" style={{ fontSize: '16px' }} />} color="red">
                <div>
                  <div>工作内容</div>
                  <p>
                    {value.workDescribe}
                  </p>
                </div>
              </Timeline.Item>
              <Timeline.Item>
                <div>评语</div>
                <div> {value.comment} </div>
              </Timeline.Item>
            </Timeline>
          </Col>
        </Row>
      );
    });
    return arr;
  }
  displayEducatExperiences = () => {
    const arr = this.state.perEducatExperiences.map((value, index) => {
      return (
        <Row key={index}>
          <Col span={4}>
            <div>{value.startYears} 至 {value.endYears}</div>
          </Col>
          <Col span={20}>
            <Timeline>
              <Timeline.Item> {value.school}</Timeline.Item>
              <Timeline.Item>{value.education}</Timeline.Item>
              <Timeline.Item>{value.major}</Timeline.Item>
              <Timeline.Item>高中</Timeline.Item>
            </Timeline>
          </Col>
        </Row>
      );
    });
    return arr;
  }
  displayCerBaseInfos = () => {
    const arr = this.state.perCerBaseInfos.map((value, index) => {
      return (
        <Row key={index}>
          <Col span={4}>
            <div>{moment(value.licenceDate).format('YYYY-MM-DD')}获得</div>
          </Col>
          <Col span={20}>
            <Timeline>
              <Timeline.Item>{value.perCerType}</Timeline.Item>
            </Timeline>
          </Col>
        </Row>
      );
    });
    return arr;
  }

  /******************************render******************************/

  render() {
    return (
      <Content>
        {/* 简历详情 */}
        <div className="ResumeDetails">
          <div className="resume-breadcrumb">
            <Breadcrumb>
              <Breadcrumb.Item><Link to="/PersonnelRecruitment/ListContainer">招聘信息</Link></Breadcrumb.Item>
              <Breadcrumb.Item>简历详情</Breadcrumb.Item>
            </Breadcrumb>
          </div>
          <header className="resume-header">
            <div className="header-left">
              <div className="password-header header-left-con">
                <span>
                  {this.state.perResumeResultDto.name}
                </span>
                <span style={{ marginLeft: "8px", marginRight: "20px" }}>
                  <img src={Female} alt="" />
                </span>
                <span>
                  <img src={Male} alt="" />
                </span>
                <div className="latest-update-time">
                  <span>最新更新时间：</span>
                  <span>{this.state.perResumeResultDto.updateTime}</span>
                </div>
              </div>
              <div className="resume-line">
                <span className="resume-line-son">
                  <span className="resume-line-son-left">出生年月:</span>
                  <span>{this.state.perResumeResultDto.birthday}</span>
                </span>
                <i className="resume-line-son-border" />
                <span className="resume-line-son">
                  <span className="resume-line-son-left">身高:</span>
                  <span>{this.state.perResumeResultDto.height}</span>
                </span>
                <i className="resume-line-son-border" />
                <span className="resume-line-son">
                  <span className="resume-line-son-left">学历:</span>
                  <span>{this.state.perResumeResultDto.educationName}</span>
                </span>
                <i className="resume-line-son-border" />
                <span className="resume-line-son">
                  <span className="resume-line-son-left">工作年限:</span>
                  <span>{this.state.perResumeResultDto.workTime === "0" ? '不满一年' : this.state.perResumeResultDto.workTime + '年工作经验'}</span>
                </span>
              </div>
              <div className="resume-line">
                <span className="resume-line-son">
                  <span className="resume-line-son-left">联系电话:</span>
                  <span>{this.state.perResumeResultDto.mobilePhone}</span>
                </span>
                <i className="resume-line-son-border" />
                <span className="resume-line-son">
                  <span className="resume-line-son-left">现居住地址:</span>
                  <span>
                    {this.state.perResumeResultDto.domicileProvinceName}
                    {this.state.perResumeResultDto.domicileCityName}
                    {this.state.perResumeResultDto.domicileAreaName}
                  </span>
                </span>
              </div>
            </div>
            <div className="header-right">
              <img src="" alt="" />
            </div>
          </header>
          <div style={{ marginTop: "24px" }}>
            <div style={{ fontSize: "16px" }} className="password-header">求职意向</div>
            <div className="resume-line">
              <span className="resume-line-son">
                <span className="resume-line-son-left">意向职位:</span>
                <span>{this.state.perResumeResultDto.position}</span>
              </span>
              <i className="resume-line-son-border" />
              <span className="resume-line-son">
                <span className="resume-line-son-left">是否全职:</span>
                <span>{this.state.perResumeResultDto.isFullTimeName}</span>
              </span>
              <i className="resume-line-son-border" />
              <span className="resume-line-son">
                <span className="resume-line-son-left">期望薪金:</span>
                <span>{this.state.perResumeResultDto.expectSalary}</span>
              </span>
              <i className="resume-line-son-border" />
              <span className="resume-line-son">
                <span className="resume-line-son-left">工作地址:</span>
                <span>
                  {this.state.perResumeResultDto.provinceName}
                  {this.state.perResumeResultDto.cityName}
                  {this.state.perResumeResultDto.areaName}
                </span>
              </span>
            </div>
          </div>
          <div style={{ marginTop: "40px" }}>
            <div style={{ fontSize: "16px" }} className="password-header">工作/实习经历</div>
            <div style={{ marginTop: "27px" }}>
              {this.displayWorkExperiences()}
            </div>
          </div>
          <div style={{ marginTop: "40px" }}>
            <div style={{ fontSize: "16px" }} className="password-header">教育培训经历</div>
            <div style={{ marginTop: "27px" }}>
              {this.displayEducatExperiences()}
            </div>
          </div>
          <div style={{ marginTop: "40px" }}>
            <div style={{ fontSize: "16px" }} className="password-header">获得证书</div>
            <div style={{ marginTop: "27px" }}>
              {this.displayCerBaseInfos()}
            </div>
          </div>
        </div>
      </Content>
    );
  }
}

/************************样式************************/

const Content = style.div`{
  padding:24px;
  font-size: 14px;
  color: #333;
  .ResumeDetails{
    .resume-breadcrumb{
      margin:16px 0;
    }
    .resume-header{
      overflow:hidden;
      .header-left{
        float:left;
        width:88%;
        .header-left-con{
          overflow:hidden;
          .latest-update-time{
            float:right;
            margin-top: 6px;
            font-size: 12px;
            color: #999999;
          }
        }
      }
      .header-right{
        margin: 31px 8px 0 0;
        float:right;
        width:80px;
        height:80px;
        background: #D8D8D8;
        border-radius:40px;
      }
    }
    .resume-line{
      margin:16px 0;
      .resume-line-son-border{
        height: 20px;
        display: inline-block;
        vertical-align: middle;
        margin:0 24px;
        border-left: 2px solid #E9E9E9;
      }
      .resume-line-son-left{
        margin-right:8px;
      }
    }
    .password-header{
      font-size: 20px;
      padding-bottom:16px;
      border-bottom:1px solid #e9e9e9;
    }
  }
}`;