import React, { PureComponent } from 'react';
import { connect } from 'dva';
import style from "styled-components";
// import {Tabs, Form, Input, Tooltip, Icon, Cascader, Select, Row, Col, Checkbox, Button, AutoComplete,Radio} from 'antd';
import { Form, Input, Radio, TreeSelect, Checkbox, Select, Cascader, Row, Col, Button, Icon, message, Modal,Breadcrumb } from 'antd';
import { Link } from "dva/router";
import {
  enterpriseSaveComJob,//保存职位信息
  enterpriseUpdateComJob,//修改职位信息
  enterpriseGetComJob,//get职位信息
  getDistrictData,//地区
  publicCommonDictGetDictByCodeTypes,//字典数据
  enterpriseGetPositionType,//获取职位类型树
  systemComDepartGetTreeDepart //获取所有部门功能
} from "../../../services/api";
import moment from 'moment';
// import PageHeaderLayout from '../../layouts/PageHeaderLayout';
import PCascader from '../../../components/Pro/PCascader';

const FormItem = Form.Item;
const RadioGroup = Radio.Group;
const CheckboxGroup = Checkbox.Group;
const { Option } = Select;
const { TextArea } = Input;
@connect(state => ({
  monitor: state.monitor,
}))

@Form.create()
export default class ListContainer extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      changeRequired: true,
      jobId: this.props.match.params.jobId,
      type: this.props.match.params.type,
      treeData: [
        //所属部门树
        { title: "", key: "" }
      ],
      listPage: {
        positionName: '',//职位名称
        positionNature: '',//职位性质
        positionType: '',//职位类型
        positionTypeData: '',//职位类型（树）
        releaseStatus: '',//发布状态
        employPerNum: '',//招聘人数
        province: '',//工作地点所在省份
        city: '',//工作地点所在城市
        area: '',//工作地点所在区/县
        salaryType: '',//薪资类型
        minSalary: '',//薪资下限
        maxSalary: '',//薪资上限
        welfare: [],//福利
        welfareRangeContentArrays: [],//福利范围数组
        workTimeType: '',//每天工作时间类型
        workDayType: '',//每周工作天数类型
        jobDesc: '',//岗位职责
        releaseTime: '',//职位发布时间
        workLifeType: '0',//工作年限类型
        educationLow: '0',//最低学历
        sexRequire: '0',//性别要求
        minAge: '',//最低年龄
        maxAge: '',//最高年龄
        language: '0',//语言要求
        otherLanguage: '',//其他语言
        minHeight: '',//最低身高
        maxHeight: '',//最高身高
        departId: '',//部门ID
        departName: '',//部门名称
      },
      pannel: 1,//模块   1表示表单显示，0 表示招聘提示
      // areas: [],//地区
      positionNature: [],//职位性质
      salaryType: [],//薪资类型
      sexRequire: [],//性别要求
      welfare: [],//福利范围数组
      educationList: [],//学历
      workDayTypeList: [],//工作天数
      workTimeTypeList: [],//每天工作时数
      workLifeTypeList: [],//工作年限类型
      releaseStatus: '',
    };

  }

  componentDidMount() {
    this.getAllType();//获取所有类型-页面需要数组字典
    this.getComJobList();
    // this.getDistrict();//省市区选择
    this.enterpriseGetPositionType();//获取职位类型树
    this.systemComDepartGetTreeDepart();//获取部门
  }
  onChangeCheck = (checkedValues) => {
    console.log('checked = ', checkedValues);
  };
  setReleaseState = (text) => {
    // console.log(this.state.releaseStatus);
    // this.setState({
    //   releaseStatus: text,
    // });
    // console.log(this.state.releaseStatus);
    if (text === 0 || text === '') {
      console.log(this.state.releaseStatus);
      this.setState({
        changeRequired: false,
        releaseStatus: text,
      });
      console.log(this.state.changeRequired);
      console.log(this.state.releaseStatus);
    } else {
      this.setState({
        changeRequired: true,
        releaseStatus: text,
      });
    }
  };
  //省市区
  // getDistrict = () => {
  //   getDistrictData().then((data) => {
  //     console.log('省市区data:', data);
  //     const areas = data.data.map((val) => {
  //       return {
  //         value: val.regionId,
  //         label: val.regionName,
  //         children: val.childs.map((valChild) => {
  //           return {
  //             value: valChild.regionId,
  //             label: valChild.regionName,
  //             children: valChild.childs.map((valChildChild) => {
  //               return {
  //                 value: valChildChild.regionId,
  //                 label: valChildChild.regionName,
  //               };
  //             })
  //           };
  //         })
  //       };
  //     }
  //     );

  //     //console.log('areas:'+JSON.stringify(areas));
  //     this.setState({
  //       areas,
  //     });
  //   });
  // };

  //获得公共信息
  getAllType = () => {
    publicCommonDictGetDictByCodeTypes({ codeTypes: [' workDayType', ' welfare', 'workTimeType', 'salaryType', 'positionNature', 'sexRequire', 'educationLow', 'workLifeType'] }).then((res) => {
      console.log('发布职位-需要所有字典数据-res:', res);
      //判断获取数据是否为空
      if (res.data) {
        const allTypeData = res.data;
        this.setState({
          educationList: allTypeData.educationLow,//学历
          welfare: allTypeData.welfare,//福利
          workDayTypeList: allTypeData.workDayType,//
          workTimeTypeList: allTypeData.workTimeType,//每天工作时数
          sexRequire: allTypeData.sexRequire,//性别要求
          salaryType: allTypeData.salaryType,//薪资类型
          positionNature: allTypeData.positionNature,//职位性质
          workLifeTypeList: allTypeData.workLifeType,//工作年限类型
        });
      }
    });
  };

  getComJobList = () => {
    if (this.state.jobId !== '00') {
      console.log(this.state.jobId);
      enterpriseGetComJob({ jobId: this.state.jobId }).then((data) => {
        console.log("当前ID信息", data);
        if (data.data) {
          this.setState({
            listPage: data.data,
          });
        }
      });
    }
  };

  //获取职位类型树（选中节点）
  enterpriseGetPositionType() {
    enterpriseGetPositionType({}).then(
      ({ data = [] }) => {
        console.log(data, "enterpriseGetPositionType-选择职位类型-data");
        this.setState({ positionTree: data });
      },
      err => {
        console.log(err, "enterpriseGetPositionType-选择职位类型-err");
      }
    );
  }
  // 通过ID获取部门功能
  systemComDepartGetTreeDepart = () => {
    systemComDepartGetTreeDepart().then(
      response => {
        console.log(response, "getTreeDepart-选择部门-response");
        let { data } = response;
        data = JSON.parse(
          JSON.stringify(data).replace(/\"children\":\[\]/g, '"isLeaf":true')
        );
        if (data.length) {
          data[0].selectable = false;
        }
        this.setState({
          treeData: data,
          chidrens: data[0].children,
          title: data[0].title,
          departId: data[0].key,
          expandedKeys: [data[0].key]
        });
      },
      err => {
        console.log(err, "getTreeDepart-选择部门-err");
      });
  };


  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        console.log('Received values of form: ', values);
        values.releaseStatus = this.state.releaseStatus;
        // debugger;
        if (values.hu) {
          values.province = values.hu[0];
          values.city = values.hu[1];
          values.area = values.hu[2];
        }
        // values.departId = "395149020382625792";
        delete values.hu;
        if (this.state.jobId !== '00') {
          if (this.state.type !== '2') {
            values.jobId = this.state.jobId;
            this.updateComjob(values);
          } else {
            this.saveComjob(values);
          }

        } else {
          this.saveComjob(values);
        }
      }
    });
  }
  //保存
  updateComjob = (values) => {
    enterpriseUpdateComJob({ ...values }).then((data) => {
      console.log("修改职位：", data);
      if (this.state.releaseStatus === 0) {
        this.setState({
          pannel: 0,
        });
        // message.info('修改职位成功！');
        this.props.history.push("/PersonnelRecruitment/ListContainer");
      } else {
        this.setState({
          pannel: 0,
        });
        // message.info('修改职位成功！');
      }
    }, (err) => {
      console.log("修改职位失败", err);
      message.info('修改职位失败！' + err);
    });
  };
  //语言状态改变
  changeLanguage = (e) => {
    console.log('语言状态改变', e);
    this.setState({
      language: e
    });
  }

  //验证薪资待遇
  checkSalary = (rule, value, callback) => {
    const form = this.props.form;
    if (value && parseInt(value, 10) <= parseInt(form.getFieldValue('minSalary'), 10)) {
      callback('最高薪资需大于最低薪资');
    } else {
      callback();
    }
  }

  //验证年龄要求
  checkAge = (rule, value, callback) => {
    const form = this.props.form;
    if (value && parseInt(value, 10) < parseInt(form.getFieldValue('minAge'), 10)) {
      callback('最大年龄需大于最小年龄');
    } else {
      callback();
    }
  }

  //验证身高要求
  checkHeight = (rule, value, callback) => {
    const form = this.props.form;
    if (value && parseInt(value, 10) < parseInt(form.getFieldValue('minHeight'), 10)) {
      callback('最大身高需大于最小身高');
    } else {
      callback();
    }
  }

  //返回验证
  checkState = () => {
    console.log(this.state.releaseStatus);
    if (this.state.releaseStatus === '') {
      this.setState({ visible: true, });
    } else {
      this.props.history.push("/PersonnelRecruitment/ListContainer");
    }
  }
  handleModalOk = (e) => {
    console.log(e);
    this.setState({ visible: false, });
    this.props.history.push("/PersonnelRecruitment/ListContainer");
  }
  handleModalCancel = (e) => {
    console.log(e);
    this.setState({
      visible: false,
    });
  }

  //重置
  resetting = () => {
    this.setState({
      jobId: '00',
      type: 1,
      listPage: {
        positionName: '',//职位名称
        positionNature: '',//职位性质
        positionType: '',//职位类型
        releaseStatus: '',//发布状态
        employPerNum: '',//招聘人数
        // province: '',//工作地点所在省份
        // city: '',//工作地点所在城市
        // area: '',//工作地点所在区/县
        salaryType: '',//薪资类型
        minSalary: '',//薪资下限
        maxSalary: '',//薪资上限
        welfare: [],//福利
        welfareRangeContentArrays: [],//福利范围数组
        workTimeType: '',//每天工作时间类型
        workDayType: '',//每周工作天数类型
        jobDesc: '',//岗位职责
        releaseTime: '',//职位发布时间
        workLifeType: '',//工作年限类型
        educationLow: '',//最低学历
        sexRequire: '',//性别要求
        minAge: '',//最低年龄
        maxAge: '',//最高年龄
        language: '',//语言要求
        otherLanguage: '',//其他语言
        minHeight: '',//最低身高
        maxHeight: '',//最高身高
        departId: '',//部门ID
        departName: '',//部门名称
      },
      pannel: 1,//模块   1表示表单显示，0 表示招聘提示

    });
  };

  //新增
  saveComjob = (values) => {
    enterpriseSaveComJob({ ...values }).then((data) => {
      if (this.state.releaseStatus === 0) {
        // message.info('保存职位成功！');
        this.props.history.push("/PersonnelRecruitment/ListContainer");
      } else {
        console.log("新增职位：", data);
        this.setState({
          pannel: 0,
        });
        // message.info('新增职位成功！');
      }
    }, (err) => {
      console.log("新增职位失败", err);
      // message.info('新增职位失败！' + err);
    });
  };

  //学历
  renderEducation = () => {
    return this.state.educationList.map((val, key) => {
      return <Option key={key} value={val.codeValue + ""}>{val.label}</Option>;
    });
  };

  //每天工作时间
  renderWorkTimeType = () => {
    return this.state.workTimeTypeList.map((val, key) => {
      return <Option key={key} value={val.codeValue + ""}>{val.label}</Option>;
    });
  };

  //每周工作天数
  renderWorkDayType = () => {
    return this.state.workDayTypeList.map((val, key) => {
      return <Option key={key} value={val.codeValue + ""}>{val.label}</Option>;
    });
  };
  //工作年限
  renderWorkLifeType = () => {
    return this.state.workLifeTypeList.map((val, key) => {
      return <Option key={key} value={val.codeValue + ""}>{val.label}</Option>;
    });
  };

  //福利选择
  renderList = () => {
    return this.state.welfare.map((val, key) => {
      return <Col key={key} span={8} style={{ marginTop: '5px' }}><Checkbox value={val.codeValue + ""}>{val.label}</Checkbox></Col>;
    });
  };

  //性别要求
  renderSexRequire = () => {
    return this.state.sexRequire.map((val, key) => {
      return <Option key={key} value={val.codeValue + ""}>{val.label}</Option>;
    });
  };

  //职位性质
  renderPositionNature = () => {
    return this.state.positionNature.map((val, key) => {
      return <Radio key={key} value={val.codeValue + ""}>{val.label}</Radio>;
    });
  };

  //薪资类型
  renderSalaryType = () => {
    return this.state.salaryType.map((val, key) => {
      return <Radio key={key} value={val.codeValue + ""}>{val.label}</Radio>;
    });
  };



  render() {
    const { getFieldDecorator } = this.props.form;
    const formItemLayout = {
      labelCol: {
        span: 7
      },
      wrapperCol: {
        span: 10
      },
    };

    // const plainOptions = ['五险', '住房公积金', '包吃', '包住', '加班补助', '班车接送'];


    return (
      <Container>
        {this.state.pannel === 1 &&
          <div className="pannel">
            <Breadcrumb style={{ borderBottom: '1px solid #E9E9E9', paddingBottom:'10px' }} >
              <Breadcrumb.Item>
                <a onClick={this.checkState}>人员招聘</a>
              </Breadcrumb.Item>
              <Breadcrumb.Item>发布职位</Breadcrumb.Item>
            </Breadcrumb>
            {/* <p className="title">
              职位描述
            </p> */}
            <div className="form" onClick={this.onc}>
              <Form onSubmit={this.handleSubmit} className="login-form">
                <FormItem
                  {...formItemLayout}
                  label="职位名称"
                >
                  {getFieldDecorator('positionName', {
                    initialValue: this.state.listPage.positionName,
                    rules: [{
                      pattern: /^[\u4e00-\u9fa5A-Za-z0-9]{1,10}$/, message: '请输汉字最大10位!',
                    },{ required: this.state.changeRequired, message: '请输入职位名称!' }],
                  })(
                    <Input placeholder="请输入职位名称" maxLength={10} />
                    )}
                </FormItem>
                <FormItem
                  {...formItemLayout}
                  label="职位性质"
                >
                  {getFieldDecorator('positionNature', {
                    initialValue: this.state.listPage.positionNature,
                    rules: [{ required: this.state.changeRequired, message: '请选择职位性质!' }],
                  })(
                    <RadioGroup onChange={this.onRadioChange}>
                      {this.renderPositionNature()}
                    </RadioGroup>
                    )}
                </FormItem>

                <FormItem
                  {...formItemLayout}
                  label="职位类别"
                >
                  {getFieldDecorator('positionType', {
                    initialValue: this.state.listPage.positionType,
                    rules: [{ required: this.state.changeRequired, message: '请输入职位类别!' }],
                  })(
                    <TreeSelect
                      dropdownStyle={{ maxHeight: 400, overflow: "auto" }}
                      placeholder="请选择特定企业部门"
                      treeData={this.state.positionTree}
                      treeDefaultExpandAll
                      onChange={this.onChange}
                      showSearch
                      treeNodeFilterProp="label"
                    />
                    )}
                </FormItem>

                {this.state.departId ? <FormItem
                  {...formItemLayout}
                  label="所属部门"
                >
                  {getFieldDecorator('departId', {
                    initialValue: this.state.listPage.departId,
                    rules: [{ required: this.state.changeRequired, message: '所属部门不能为空!' }],
                  })(
                    <TreeSelect
                      dropdownStyle={{ maxHeight: 400, overflow: "auto" }}
                      treeData={this.state.treeData}
                      placeholder="请选择上级部门"
                      treeDefaultExpandAll
                    />
                    )}
                </FormItem> : <FormItem
                  {...formItemLayout}
                  label="所属部门"
                >
                    {getFieldDecorator('departId', {
                      rules: [{ required: this.state.changeRequired, message: '请选择' }],
                    })(
                      <TreeSelect
                        dropdownStyle={{ maxHeight: 400, overflow: "auto" }}
                        treeData={this.state.treeData}
                        placeholder="请选择上级部门"
                        treeDefaultExpandAll
                      />
                      )}
                  </FormItem>}

                <FormItem
                  {...formItemLayout}
                  label="招聘人数"
                >
                  {getFieldDecorator('employPerNum', {
                    initialValue: this.state.listPage.employPerNum,
                    rules: [{ required: this.state.changeRequired, message: '招聘人数不能为空!' },
                    {
                      pattern: /^\d{0,4}$/,
                      message: "请输入数字"
                    },],
                  })(
                    <Input placeholder="请输入招聘人数" maxLength={4} addonAfter={<span>人</span>} />
                    )}
                </FormItem>

                {
                  this.state.jobId === '00' ?
                    <FormItem
                      {...formItemLayout}
                      label=" 工作地点"
                    >
                      {getFieldDecorator('hu', {
                        rules: [{ required: this.state.changeRequired, message: '工作地点不能为空!' }],
                      })(
                        // <Cascader options={this.state.areas} placeholder="请选择" />
                        <PCascader placeholder="请选择"/>
                        )}
                    </FormItem>
                    :
                    <FormItem
                      {...formItemLayout}
                      label=" 工作地点"
                    >
                      {getFieldDecorator('hu', {
                        initialValue: [this.state.listPage.province, this.state.listPage.city, this.state.listPage.area],
                        rules: [{ required: this.state.changeRequired, message: '工作地点不能为空!' }],
                      })(
                        // <Cascader options={this.state.areas} placeholder="请选择" />
                        <PCascader placeholder="请选择"/>
                        )}
                    </FormItem>
                }

                <FormItem
                  {...formItemLayout}
                  label="薪资类型"
                >
                  {getFieldDecorator('salaryType', {
                    initialValue: this.state.listPage.salaryType,
                    rules: [{ required: this.state.changeRequired, message: '薪资类型没有选择!' }],
                  })(
                    <RadioGroup onChange={this.onRadioChange}>
                      {this.renderSalaryType()}
                    </RadioGroup>
                    )}
                </FormItem>

                <div className="twoinput">
                  <FormItem
                    labelCol={{ span: 7 }}
                    wrapperCol={{ span: 4 }}
                    label="薪资待遇"
                  >
                    {getFieldDecorator('minSalary', {
                      initialValue: this.state.listPage.minSalary,
                      rules: [{ required: this.state.changeRequired, message: '最低薪资不能为空!!' },
                      {
                        pattern: /^\d{0,8}$/,
                        message: "请输入数字"
                      },],
                    })(
                      <Input placeholder="最低薪资" maxLength={8} />
                      )}
                  </FormItem>

                  <span style={{ position: "absolute", top: 9, left: 445 }}>至</span>

                  <FormItem
                    labelCol={{ span: 0 }}
                    wrapperCol={{ span: 24 }}
                    label=""
                    className="otheritem"
                  >
                    {getFieldDecorator('maxSalary', {
                      initialValue: this.state.listPage.maxSalary,
                      rules: [{ required: this.state.changeRequired, message: '最高薪资不能为空!' }, { validator: this.checkSalary, },
                      {
                        pattern: /^\d{0,8}$/,
                        message: "请输入数字"
                      },],
                    })(
                      <Input placeholder="最高薪资" maxLength={8} />
                      )}
                  </FormItem>
                  <span style={{ position: "absolute", top: 9, left: 642 }}>元/月</span>
                  <Row>
                    <Col span={7} />
                    <Col span={17} style={{ color: "red" }}>*薪资范围差不超过两倍，真实的薪资更利于提高招聘效果</Col>
                  </Row>
                </div>

                <FormItem
                  {...formItemLayout}
                  label="福利"
                >
                  {getFieldDecorator('welfare', {
                    initialValue: this.state.listPage.welfareRangeContentArrays,
                    rules: [{ required: false, message: '请选择福利!' }],
                  })(
                    <Checkbox.Group onChange={this.onChangeCheck}>
                      <Row>
                        {this.renderList()}
                      </Row>
                    </Checkbox.Group>
                    )}
                </FormItem>

                <FormItem
                  {...formItemLayout}
                  label="每天工作时间"
                >
                  {getFieldDecorator('workTimeType', {
                    initialValue: this.state.listPage.workTimeType,
                    rules: [{ required: this.state.changeRequired, message: '每天工作时间不能为空！' }],
                  })(
                    <Select placeholder="请选择">
                      <Option value=" ">请选择</Option>
                      {this.renderWorkTimeType()}
                    </Select>
                    )}
                </FormItem>

                <FormItem
                  {...formItemLayout}
                  label="每周工作天数"
                >
                  {getFieldDecorator('workDayType', {
                    initialValue: this.state.listPage.workDayType,
                    rules: [{ required: this.state.changeRequired, message: '每周工作天数不能为空!' }],
                  })(
                    <Select placeholder="请选择">
                      <Option value=" ">请选择</Option>
                      {this.renderWorkDayType()}
                    </Select>
                    )}
                </FormItem>

                <FormItem
                  {...formItemLayout}
                  label="岗位职责/职位描述"
                >
                  {getFieldDecorator('jobDesc', {
                    initialValue: this.state.listPage.jobDesc,
                    rules: [{ required: this.state.changeRequired, message: '岗位职责不能为空!' }],
                  })(
                    <TextArea className="margint"
                      // value={this.state.listPage.jobDesc}
                      autosize={{ minRows: 4, maxRows: 10 }} maxLength={5000}
                    />
                    )}
                </FormItem>
                <p className="title">
                  对求职者要求
              </p>
                <FormItem
                  {...formItemLayout}
                  label="工作年限"
                >
                  {getFieldDecorator('workLifeType', {
                    initialValue: this.state.listPage.workLifeType,
                    rules: [{ message: '请选择工作年限!' }],
                  })(
                    <Select placeholder="请输入工作年限">
                      {this.renderWorkLifeType()}
                    </Select>
                    )}
                </FormItem>

                <FormItem
                  {...formItemLayout}
                  label="最低学历"
                >
                  {getFieldDecorator('educationLow', {
                    initialValue: this.state.listPage.educationLow,
                    rules: [{ message: '请选择学历' }],
                  })(
                    <Select placeholder="请选择">
                      {this.renderEducation()}
                    </Select>
                    )}
                </FormItem>

                <FormItem
                  {...formItemLayout}
                  label="性别要求"
                >
                  {getFieldDecorator('sexRequire', {
                    initialValue: this.state.listPage.sexRequire,
                    rules: [{ message: '请选择性别要求' }],
                  })(
                    <Select initialValue="0">
                      {this.renderSexRequire()}
                    </Select>
                    )}
                </FormItem>


                <div className="twoinput">
                  <FormItem
                    labelCol={{ span: 7 }}
                    wrapperCol={{ span: 4 }}
                    label="年龄要求"
                  >
                    {getFieldDecorator('minAge', {
                      initialValue: this.state.listPage.minAge,
                      rules: [{ required: false, message: '请输入最低年龄！' }],
                    })(
                      <Input placeholder="最低年龄" />
                      )}
                  </FormItem>

                  <span style={{ position: "absolute", top: 9, left: 466 }}>至</span>

                  <FormItem
                    labelCol={{ span: 0 }}
                    wrapperCol={{ span: 24 }}
                    label=""
                    className="otheritem o508"
                  >
                    {getFieldDecorator('maxAge', {
                      initialValue: this.state.listPage.maxAge,
                      rules: [{ required: false, message: '最大年龄不能为空' }, { validator: this.checkAge, }],
                    })(
                      <Input placeholder="请输入最大年龄" />
                      )}
                  </FormItem>
                </div>

                <div className="twoinput">
                  <FormItem
                    labelCol={{ span: 7 }}
                    wrapperCol={{ span: 4 }}
                    label="语言要求"
                  >
                    {getFieldDecorator('language', {
                      initialValue: this.state.listPage.language,
                      rules: [{ required: false, message: '请填写语言!' }],
                    })(
                      <Select placeholder="请选择" onChange={this.changeLanguage}>
                        <Option value="0" selected="selected">不限</Option>
                        <Option value="1">普通语</Option>
                        <Option value="2">当地方言</Option>
                        <Option value="3">英语</Option>
                        <Option value="4">其他外语</Option>
                      </Select>
                      )}
                  </FormItem>

                  {this.state.language === "4" && (
                    <FormItem
                      labelCol={{ span: 0 }}
                      wrapperCol={{ span: 24 }}
                      label=""
                      className="otheritem o508"
                    >
                      {getFieldDecorator('otherLanguage', {
                        initialValue: this.state.listPage.otherLanguage,
                        rules: [
                          { required: true, message: '请输入语种' },
                          {
                            pattern: /^[\u4e00-\u9fa5]{1,10}$/,
                            message: "请输入中文"
                          },
                        ],
                      })(
                        <Input placeholder="其他语言" maxLength={10} />
                        )}
                    </FormItem>
                  )}
                </div>

                <div className="twoinput">
                  <FormItem
                    labelCol={{ span: 7 }}
                    wrapperCol={{ span: 4 }}
                    label="身高要求"
                  >
                    {getFieldDecorator('minHeight', {
                      initialValue: this.state.listPage.minHeight,
                      rules: [{ required: false, message: '请填写最低身高!' }],
                    })(
                      <Input placeholder="请输入" addonAfter={<span>cm</span>} />
                      )}
                  </FormItem>

                  <span style={{ position: "absolute", top: 9, left: 466 }}>至</span>

                  <FormItem
                    labelCol={{ span: 0 }}
                    wrapperCol={{ span: 24 }}
                    label=""
                    className="otheritem o508"
                  >
                    {getFieldDecorator('maxHeight', {
                      initialValue: this.state.listPage.maxHeight,
                      rules: [{ required: false, message: '请填写最大身高!' }, { validator: this.checkHeight, }],
                    })(
                      <Input placeholder="请输入" addonAfter={<span>cm</span>} />
                      )}
                  </FormItem>

                  <FormItem
                    className="btns"
                  >
                    <Button type="primary" onClick={this.checkState}>返回</Button>
                    <Button htmlType="submit" onClick={this.setReleaseState.bind(this, 0)} style={{ marginLeft: 8 }} className="btn1">仅保存不发布</Button>
                    <Button type="primary" htmlType="submit" onClick={this.setReleaseState.bind(this, 1)} style={{ marginLeft: 8 }}>发 布</Button>
                  </FormItem>


                </div>

              </Form>


            </div>
          </div>
        }
        {this.state.pannel === 0 &&
          <div className="pannel">
            <ImgTip>
              <Icon type="check-circle-o" />
              <p>招聘信息发布成功</p>
              <div className="btnsz">
                <div className="btnz">
                  <Button type="primary"
                    onClick={() => {
                      this.props.history.push(`/PersonnelRecruitment/ListContainer`);
                    }}>招聘列表</Button>
                  <Button
                    style={{ marginLeft: '16px' }}
                    onClick={() => {
                      this.setState({ pannel: 1 });
                      this.resetting();
                      this.props.history.push(`/PersonnelRecruitment/ListContainer/PositionDetail/00/1`);
                    }}>继续发布职位</Button>
                </div>
              </div>
            </ImgTip>
          </div>
        }
        <Modal
          title="提示"
          visible={this.state.visible}
          onOk={this.handleModalOk}
          onCancel={this.handleModalCancel}
        >
          <p>当前信息未保存，是否确认返回？</p>
        </Modal>
      </Container>
    );
  }
}

const Container = style.div`
{
    padding:24px;
    .title{
      font-size: 16px;
      color: #333333;
      line-height:1;
      padding-bottom:8px;
      border-bottom:1px solid #E9E9E9;
    }
    .form{
      width:952px;
      display:inline-block;
      padding-top:10px;
    }
    .margint{
      margin-top:10px;
    }
    .twoinput{
       position:relative; 
      .otheritem{
       position: absolute;
       width:200px;
       width: 166px;
       top: 0px;
       left: 468px;
       &.o508{
        left: 508px;
       }
    }
    .btns{
       padding-left:205px; 
       font-size:14px;
    }  
    .btn1{
      background:#FFAA00;
      color:#fff;
      border-color:#FFAA00;
      &:hover{
         border-color:#FFAA00;
         background:#ffaa00b3;
      }
    }
  }
`;


const ImgTip = style.div`{
   font-size: 70px;
   color: #00CB28;
   text-align:center;
   padding:36px 0 0 24px;
   p{
    font-size: 20px;
    color: #333333;
    line-height: 20px;
   }
   .btnsz{
    font-size: 14px;
   }
   .btnz{
    border-radius: 4px;
    display:inline-block;
    padding:9px 16px;
    font-size: 14px;
    line-height:1;
    color:#fff;
    cursor:pointer;
    &:nth-child(2){
      background:#fff;
      margin-left:16px;
      color: #666666;
      border-color:#666666;
    }
   }
}`;
