import React, { PureComponent } from 'react';
// import { connect } from 'dva';
import style from "styled-components";
import { Tabs } from 'antd';
import Employing from "./Employing";
import BrainPeople from "./BrainPeople";
import Receive from "./Receive";
import Collect from "./Collect";

const { TabPane } = Tabs;
// const { Option } = Select;

// @connect(state => ({
//   monitor: state.monitor,
// }))
export default class ListContainer extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      cursor: "1",//各个 tab 游标，点击加载
    };
  }

  tabChange = (cursor) => {
    //各个 tab 游标，点击加载
    this.setState({ cursor });
  }

  render() {
    const { cursor } = this.state;

    return (
      <Container>
        <Tabs onChange={this.tabChange}>
          <TabPane tab="招聘中" key="1">
            {cursor === "1" &&
              <Employing history={this.props.history} />
            }
          </TabPane>
          <TabPane tab="人才搜索" key="2">
            {cursor === "2" &&
              <BrainPeople history={this.props.history} />
            }
          </TabPane>
          <TabPane tab="收到的简历" key="3">
            {cursor === "3" &&
              <Receive history={this.props.history} />
            }
          </TabPane>
          <TabPane tab="收藏的简历" key="4">
            {cursor === "4" &&
              <Collect history={this.props.history} />
            }
          </TabPane>
        </Tabs>
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
`;
