import React, { PureComponent } from "react";
// import { connect } from 'dva';
import style from "styled-components";
import {
  Input,
  Button,
  Form,
  Select,
  // DatePicker,
  // InputNumber,
  // Radio,
  // Icon,
  message,
  Drawer
} from "antd";
// import Drawer from 'react-motion-drawer';
// import PSelect from "../../../components/Pro/PSelect";
// import * as api from "../../../services/api";
import {
  publicCommonDictGetDictByCodeTypes, //公共信息
  enterpriseResumeCollectGetRemark, //获取收藏的简历备注
  enterpriseResumeCollectChangeRemark //收藏的简历备注
} from "../../../services/api";

const FormItem = Form.Item;
const { Option } = Select;
// const RadioGroup = Radio.Group;
const { TextArea } = Input;
message.config({
  top: 100,
  right: 5,
  duration: 2
});

@Form.create()

// 收藏的简历备注
export default class CollectionResumesRemarks extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: this.props.visiable, //备注
      currentId: this.props.currentId, //当前ID
      agreeInterviewStatus: [], //沟通前状态
      communicateAfterStatus: [], //沟通中状态
      communicatePreStatus: [], //沟通后状态
      communicateStatus: [] //同意面试后
    };
  }
  /******************************生命周期******************************/

  componentDidMount = () => {
    this.getAllType(); //获取所有类型
    // this.getRemarkInfo();
  };
  componentWillReceiveProps = nextProps => {
    if (this.props.currentId !== nextProps.currentId) {
      this.setState(
        { open: nextProps.visiable, currentId: nextProps.currentId },
        () => {
          this.getRemarkInfo();
        }
      );
    } else {
      this.setState({
        open: nextProps.visiable,
        currentId: nextProps.currentId
      });
    }
  };
  /******************************ajax请求******************************/
  //获得公共信息
  getAllType = () => {
    publicCommonDictGetDictByCodeTypes({
      codeTypes: [
        "communicatePreStatus",
        "communicateStatus",
        "communicateAfterStatus",
        "agreeInterviewStatus"
      ]
    }).then(res => {
      console.log("所有沟通状态res:", res);
      //判断获取数据是否为空
      if (res.data) {
        const allTypeData = res.data;
        this.setState({
          communicatePreStatus: allTypeData.communicatePreStatus,
          communicateStatus: allTypeData.communicateStatus,
          communicateAfterStatus: allTypeData.communicateAfterStatus,
          agreeInterviewStatus: allTypeData.agreeInterviewStatus
        });
      }
    });
  };
  getRemarkInfo = () => {
    enterpriseResumeCollectGetRemark({ resumeId: this.state.currentId }).then(
      response => {
        const {
          communicatePreStatus,
          communicateStatus,
          communicateAfterStatus,
          agreeInterviewStatus,
          remark
        } = response.data;
        const { setFieldsValue } = this.props.form;
        setFieldsValue({
          communicatePreStatus,
          communicateStatus,
          communicateAfterStatus,
          agreeInterviewStatus,
          remark
        });
      }
    );
  };
  //表单提交
  handleRemarksSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        console.log("values", values);

        console.log("Id", this.state.currentId);
        const obj = {
          resumeId: this.state.currentId,
          agreeInterviewStatus: values.agreeInterviewStatus
            ? values.agreeInterviewStatus
            : "",
          communicateAfterStatus: values.communicateAfterStatus
            ? values.communicateAfterStatus
            : "",
          communicatePreStatus: values.communicatePreStatus
            ? values.communicatePreStatus
            : "",
          communicateStatus: values.communicateStatus
            ? values.communicateStatus
            : "",
          remark: values.remark
        };
        console.log("obj", obj);
        enterpriseResumeCollectChangeRemark(obj).then(
          res => {
            console.log("成功信息-保存收藏简历备注：", res);
            message.success("保存成功！");
            this.setState({ open: false });
          },
          error => {
            message.error(error);
            console.log("错误信息-保存收藏简历备注：", error);
          }
        );
      }
    });
  };
  /******************************相关事件******************************/
  //沟通前
  renderBeforeState = () => {
    return this.state.communicatePreStatus.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ""}>
          {val.label}
        </Option>
      );
    });
  };

  //沟通中
  renderMiddleState = () => {
    return this.state.communicateStatus.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ""}>
          {val.label}
        </Option>
      );
    });
  };

  //沟通后
  renderAfterState = () => {
    return this.state.communicateAfterStatus.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ""}>
          {val.label}
        </Option>
      );
    });
  };

  //同意面试后
  renderAfterAgreeingInterviewState = () => {
    return this.state.agreeInterviewStatus.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ""}>
          {val.label}
        </Option>
      );
    });
  };

  /******************************render******************************/

  render() {
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 7
        }
      },
      wrapperCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 12
        },
        md: {
          span: 10
        }
      }
    };
    const { getFieldDecorator } = this.props.form;

    return (
      <Box>
        <Drawer
          title="备注"
          placement="right"
          visible={this.state.open}
          width={600}
          // zIndex={999}
          onChange={open => {
            this.props.onChange(open);
            this.setState({ open });
          }}
          onClose={() => this.setState({ open: false })}
          // destroyOnClose
          style={{
            height: "calc(100% - 55px)",
            overflow: "auto",
            paddingBottom: 53
          }}
        >
          <div>
            <div>
              <Form onSubmit={this.handleRemarksSubmit}>
                <FormItem {...formItemLayout} label="沟通前">
                  {getFieldDecorator("communicatePreStatus", {
                    rules: [
                      {
                        required: false,
                        message: "该字段必填"
                      }
                    ]
                  })(
                    <Select placeholder="请选择">
                      <Option value="">请选择</Option>
                      {this.renderBeforeState()}
                    </Select>
                  )}
                </FormItem>
                <FormItem {...formItemLayout} label="沟通中">
                  {getFieldDecorator("communicateStatus", {
                    rules: [
                      {
                        required: false,
                        message: "该字段必填"
                      }
                    ]
                  })(
                    <Select placeholder="请选择">
                      <Option value="">请选择</Option>
                      {this.renderMiddleState()}
                    </Select>
                  )}
                </FormItem>
                <FormItem {...formItemLayout} label="沟通后">
                  {getFieldDecorator("communicateAfterStatus", {
                    rules: [
                      {
                        required: false,
                        message: "该字段必填"
                      }
                    ]
                  })(
                    <Select placeholder="请选择">
                      <Option value="">请选择</Option>
                      {this.renderAfterState()}
                    </Select>
                  )}
                </FormItem>
                <FormItem {...formItemLayout} label="同意面试后">
                  {getFieldDecorator("agreeInterviewStatus", {
                    rules: [
                      {
                        required: false,
                        message: "该字段必填"
                      }
                    ]
                  })(
                    <Select placeholder="请选择">
                      <Option value="">请选择</Option>
                      {this.renderAfterAgreeingInterviewState()}
                    </Select>
                  )}
                </FormItem>
                <FormItem {...formItemLayout} label="其他说明">
                  {getFieldDecorator("remark", {
                    rules: [
                      {
                        required: true,
                        message: "该字段必填"
                      }
                    ]
                  })(
                    <TextArea
                      // style={{ width: 294 }}
                      rows={4}
                      placeholder="请填写其他说明"
                      maxLength={500}
                    />
                  )}
                </FormItem>
              </Form>
            </div>
            <div
              style={{
                position: "absolute",
                bottom: 0,
                width: "100%",
                borderTop: "1px solid #e8e8e8",
                padding: "10px 16px",
                textAlign: "right",
                left: 0,
                background: "#fff",
                borderRadius: "0 0 4px 4px"
              }}
            >
              <Button
                style={{
                  marginRight: 8
                }}
                onClick={() => this.setState({ open: false })}
              >
                取消
              </Button>
              <Button
                type="primary"
                htmlType="submit"
                onClick={this.handleRemarksSubmit}
              >
                保存备注
              </Button>
            </div>
          </div>
        </Drawer>
      </Box>
    );
  }
}

/************************样式************************/

const Box = style.div`{
  .drawer-content{
    margin-top:28px;
  }
}`;
