import React, { PureComponent } from 'react';
// import { connect } from 'dva';
import style from "styled-components";
import { Input, Button, DatePicker, message } from 'antd';
// import Drawer from 'react-motion-drawer';
import moment from "moment/moment";
import CollectionResumesRemarks from "./CollectionResumesRemarks";
import PTable from "../../../components/Pro/PTable";
import {
  enterpriseResumeCollectPage, //获取收藏的简历
  enterpriseResumeCollectDelete,//删除收藏简历
} from "../../../services/api";
// import './less/devices.less';

// const { Option } = Select;
const { RangePicker } = DatePicker;
const dateFormat = 'YYYY-MM-DD';

// @connect(state => ({
//   monitor: state.monitor,
// }))
export default class Collect extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      /**
       * 抽屉需要
       */
      //visiable: false,
      open: false,
      currentId: '',
      //number: 0,
      forceUpdate: false,
      pageParm: {
        // createTime:'',
        // comId: '1',
        pageSize: '10',
        pageNumber: '1',
        keyWord: "",
        startTime: "",
        endTime: "",
        // isRead: "",
      },
      keyWord: "",
      start: false,
      end: false,
      startTime: '',
      endTime: '',
      // isRead: "",
    };
  }

  // /************************生命周期********************************* */
  // componentDidMount() {
  //   this.getCollectResume();//获取收藏的简历
    
  // }

  // /************************ajax请求********************************* */
  // //获取收藏的简历列表
  // getCollectResume = () => {
  //   // const comId = 1;
  //   const pageSize = 10;
  //   const pageNumber = 1;
  //   enterpriseResumeCollectPage({ pageSize, pageNumber }).then((res) => {
  //     console.log("获取收藏的简历成功:", res);
  //   }, (err) => {
  //     console.log("获取收藏的简历失败:", err);
  //   });
  // }

  //备注抽屉
  changeDrawer = (open, currentId) => {
    console.log(open);
    console.log("当前Id", currentId);
    this.setState({ open, currentId });
  }

  //输入框的书写，开始年龄
  inputKeyWordChange = (e) => {
    console.log(e.target.value.trim());
    this.setState({ keyWord: e.target.value.trim() });
  };

  //收藏日期选择框
  inputCollectTimeChange = (date, dateString) => {
    if (dateString[0] !== '') {
      this.setState({
        start: true,
        end: true,
        startTime: dateString[0],
        endTime: dateString[1],
      });
    } else {
      this.setState({
        start: false,
        end: false,
        startTime: '',
        endTime: '',
      });
    }
  };

  //点击搜索
  search = () => {
    const pageParm = { ...this.state.pageParm };
    // const keyWord = {...this.state.keyWord};
    // let startTime = this.state.startTime;
    // let endTime = this.state.endTime;
    pageParm.keyWord = this.state.keyWord;

    // if (this.state.start !== false) {
    //   const startTime = {...this.state.startTime};
      pageParm.startTime = this.state.startTime;
    // } else {
    //   pageParm.startTime = '';
    // }
    // if (this.state.end !== false) {
    //   const endTime = {...this.state.endTime};
      pageParm.endTime = this.state.endTime;
    // } else {
    //   pageParm.endTime = '';
    // }
    // let isRead = this.state.isRead;
    // let isRead = 0;
    // pageParm.isRead = isRead;
    // this.setState({pageParm: pageParm, forceUpdate: true}, () => {
    //   this.setState({forceUpdate: false});
    // });
    this.setState({ pageParm });
  }
  //移除收藏简历
  handleDeleteList = (resumeId) => {

    // const comId = 1;
    console.log("移除简历ID", resumeId);

    enterpriseResumeCollectDelete({ resumeId }).then((data) => {
      console.log("移除简历成功:", data);
      message.warning('移除后可通过“人才搜索”继续收藏该人才！');
      this.setState({
        forceUpdate: true,
      }, () => {
        this.setState({
          forceUpdate: false,
        });
      });
    }, (err) => {
      console.log("移除当前简历不成功", err);
      // message.error(err);
      message.error("未移除成功！");
    });
  }

  renderTable = () => {
    // const dataSource = [{
    //   key: '1',
    //   name: '胡彦斌',
    //   age: 32,
    //   address: '西湖区湖底公园1号'
    // }, {
    //   key: '2',
    //   name: '胡彦祖',
    //   age: 42,
    //   address: '西湖区湖底公园1号'
    // }];

    const columns = [
      {
        title: '姓名',
        dataIndex: 'name',
        key: 'name',
      },
      {
        title: '性别',
        dataIndex: 'sexName',
        key: 'sexName',
      },
      {
        title: '年龄',
        dataIndex: 'age',
        render: (age) => (
          <div>
            {age}岁
          </div>
        ),
        key: 'age',
      },
      {
        title: '工作年限',
        dataIndex: 'workTime',
        render: (workTime) => (
          <div>
            {workTime === 0 ? "不满一年" : workTime + "年工作经验"}
          </div>
        ),
        key: 'workTime',
      },
      {
        title: '意向工作',
        dataIndex: 'position',
        key: 'position',
      },
      {
        title: '学历',
        dataIndex: 'educationName',
        key: 'educationName',
      },
      {
        title: '收藏时间',
        dataIndex: 'createTime',
        key: 'createTime',
      },
      {
        title: '现居地',
        dataIndex: 'province',
        render: (province, record) => (
          <div>
            {province + "-" + record.city + "-" + record.area}
          </div>
        ),
        key: 'province',
      },
      {
        title: '操作',
        dataIndex: 'd',
        key: 'd',
        render: (text, record) => (
          // render: () => (
          <div>
            <Opton
              onClick={() => {
                this.props.history.push(`/PersonnelRecruitment/ListContainer/ResumeDetails/${record.resumeId}/2`);
              }}
            >
              查看
            </Opton>
            <Opton
              onClick={this.handleDeleteList.bind(this, record.resumeId)}
            >
              移除
            </Opton>
            <Opton onClick={this.changeDrawer.bind(this, true, record.resumeId)}>备注</Opton>
          </div>
        ),
      }
    ];

    //return <Table dataSource={dataSource} columns={columns}/>;
    return (
      <PTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="enterpriseResumeCollectPage"
        pageParm={this.state.pageParm}
        forceUpdate={this.state.forceUpdate}
        showTotal={total => `共搜素到${total}条记录`}
      // showTotal
      />
    );
  }

  render() {
    return (
      <Content>
        {/* 搜索条件面板 */}
        <div className="searchpanel">
          <span>关键字：</span>
          <Input style={{ width: 214 }} onChange={this.inputKeyWordChange} />
          <span className="post">收藏日期:</span>
          <RangePicker
            format={dateFormat}
            onChange={this.inputCollectTimeChange}
            style={{ width: 214 }}
            value={[this.state.start ? moment(this.state.startTime, dateFormat) : null, this.state.end ? moment(this.state.endTime, dateFormat) : null]}
          />
          <Button type="primary" style={{ marginLeft: 17 }} onClick={this.search}>搜索</Button>
        </div>
        {this.renderTable()}
        <CollectionResumesRemarks onChange={(open) => {
          this.setState({ open });
        }} visiable={this.state.open} currentId={this.state.currentId} />
      </Content>
    );
  }
}

/************************样式************************/

const Content = style.div`{
  font-size: 14px;
  color: rgba(0,0,0,0.65);
  .searchpanel{
     margin-bottom:16px;
    .post{
      margin:0 8px 0 16px;
    }
  }
  .btns{
    margin-top:16px;
  }
}`;

const Opton = style.span`{
  font-size: 12px;
  color: #0F71FF;
  cursor:pointer;
  margin-right:8px;
}`;
