/**
 * 会议用户管理
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Form, Alert, Input, Button, Tabs, TreeSelect, Modal, Select } from "antd";
import PTable from "../../../components/Pro/PTable";
import $perModal from '../../../utils/modal/perModal';
import {
  addUser,
  systemComDepartGetTreeDepart,
  batchDeleteUser,
  getHuaweiManageResource,
  setRegulatorMeetCharge,
  cancelRegulatorMeetCharge,
  publicCommonDictGetDictByCodeTypes
} from "../../../services/api";
import "../meeting.less";
const { TabPane } = Tabs;
const { confirm } = Modal;
@connect(state => ({
  client: state.client.client
}))
@Form.create()
export default class UserManage extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false,
      pageParm: {
        keyWord: "",
        departId: "",
        regulatorMeetChargeType: "",
        pageSize: 10,
        pageNumber: 1
      },
      regulatorMeetChargeTypeOptions: [],
      regulatorMeetChargeTypeCol: "",
      regulatorMeetChargeType: "",
      isRegulatorMeetCharge: '',
      keyWord: "",
      departId: "0", //过滤部门的时候默认是“全部”
      treeData: [
        // 部门数据
        //树
        { title: "", key: "" }
      ],
      resourceData: null
    };
  }
  componentDidMount() {
    // 获取部门
    this.getDepart();
    this._getHuaweiManageResource();
    this.getRegulatorMeetChargeType()
  }
  //获取部门树数据
  getDepart = cb => {
    systemComDepartGetTreeDepart().then(
      response => {
        let { data } = response;
        data = JSON.parse(
          JSON.stringify(data).replace(/\"children\":\[\]/g, '"isLeaf":true')
        );
        data.unshift({
          title: "全部",
          value: "0"
        });
        this.setState(
          {
            treeData: data
          },
          () => {
            cb && cb();
          }
        );
      },
      err => {
        console.log(err, "getTreeDepart-选择部门-err");
      }
    );
  };
  //获取监管会议角色列表
  getRegulatorMeetChargeType = () => {
    publicCommonDictGetDictByCodeTypes({ codeTypes: "regulatorMeetChargeType" }).then(res => {
      this.setState({ regulatorMeetChargeTypeOptions: res.data.regulatorMeetChargeType })
    })
  }
  //获取资源数
  _getHuaweiManageResource() {
    getHuaweiManageResource({}).then(res => {
      if (res.retType === "0" && res.data) {
        this.setState({
          resourceData: res.data.teSoftCount
        });
      }
    });
  }
  //添加成员
  _addUser(perId, close) {
    addUser({ perId }).then(res => {
      close && close();
      if (res.retType === "0") {
        this.setState({
          forceUpdate: true
        });
        this._getHuaweiManageResource();
      }
    });
  }
  //删除人员
  _deleteUser(perId) {
    batchDeleteUser({ perIds: perId }).then(res => {
      if (res.retType === "0") {
        this.setState({
          forceUpdate: true
        });
        this._getHuaweiManageResource();
      }
    });
  }
  _setResource(record) {
    if (record.regulatorMeetChargeType === "否") {
      setRegulatorMeetCharge({ perId: record.perId, regulatorMeetChargeType: this.state.regulatorMeetChargeTypeSelect }).then(res => {
        this.setState({
          forceUpdate: true
        }, () => {
          this.setState({
            forceUpdate: false
          })
        });
      })
    } else {
      cancelRegulatorMeetCharge({ perId: record.perId }).then(res => {
        this.setState({
          forceUpdate: true
        }, () => {
          this.setState({
            forceUpdate: false
          })
        });
      });
    }
  }
  render() {
    let options = (
      <Select
        style={{ width: 200 }}
        placeholder="请选择"
        onChange={(value) => {
          this.setState({
            regulatorMeetChargeTypeSelect: value,
          });
        }}
      >
        {
          this.state.regulatorMeetChargeTypeOptions.map(item => (
            <Option key={item.codeValue} value={item.codeValue}>{item.label}</Option>
          ))
        }
      </Select>
    )
    const columns = [
      {
        title: "序号",
        dataIndex: "key",
        key: "key",
        render: (text, record, index) => <span>{index + 1}</span>
      },
      {
        title: "姓名",
        dataIndex: "name",
        key: "name"
      },
      {
        title: "手机号码",
        dataIndex: "mobilePhone",
        key: "mobilePhone"
      },
      {
        title: "部门",
        dataIndex: "departName",
        key: "departName"
      },
      {
        title: "人员类别",
        dataIndex: "perType",
        key: "perType"
      },
      {
        title: "是否监管会议角色",
        dataIndex: "regulatorMeetChargeType",
        key: "regulatorMeetChargeType"
      },
      {
        title: "操作",
        key: "action",
        render: (text, record) => {
          let paramText = '取消监管会议角色'
          console.log(record.regulatorMeetChargeType)
          if (record.regulatorMeetChargeType === '否') {
            paramText = '设为监管会议角色';
          } else {
            paramText = '取消监管会议角色';
          }
          return (
            <span>
              <span
                className="action-span"
                style={{ marginRight: '10px' }}
                onClick={() => {
                  console.log(record.regulatorMeetChargeType)
                  const _this = this
                  confirm({
                    title: record.regulatorMeetChargeType !== "否" ? '确定“' + record.name + '”' + "取消监管会议角色?" : "请选择要设置的监管会议角色",
                    content: record.regulatorMeetChargeType === "否" ? options : '',
                    okText: '确定',
                    cancelText: '取消',
                    onOk() {
                      _this._setResource(record)
                    },
                  });
                }}
              >
                {paramText}
              </span>
              <span
                className="action-span"
                onClick={() => {
                  const _this = this
                  confirm({
                    title: '确定删除该人员?',
                    content: '删除后，该人员无法使用会议功能',
                    okText: '确定',
                    cancelText: '取消',
                    onOk() {
                      _this._deleteUser(record.perId);
                    },
                    onCancel() {
                      console.log('Cancel');
                    },
                  });
                }}
              >
                删除
            </span>
            </span>
          )
        }
      }
    ];
    return (
      <div className="meeting">
        <Tabs defaultActiveKey="1">
          <TabPane tab="用户管理" key="1">
            <Alert
              message={
                <div style={{ color: "#333" }}>
                  <span>
                  1、需提前为公司人员开通会议权限，才可以在手机端与电脑端使用会议功能；
                  </span>
                  <div>
                  2、请为相应用户设置监管会议角色，便于公安机关或行业协会发起会议时，可选择到本公司的监管会议角色成员。
                  </div>
                </div>
              }
              type="warning"
              showIcon
              style={{ marginBottom: "15px" }}
            />
            <div className="form">
              <label style={{ marginRight: 16 }}>
                关键词：
                <Input
                  style={{ width: "214px", marginBottom: "10px" }}
                  placeholder="请输入姓名/手机号码"
                  value={this.state.keyWord}
                  onChange={e => {
                    this.setState({
                      keyWord: e.target.value
                    });
                  }}
                />
              </label>
              <label style={{ marginRight: 16 }}>
                部门：
                <TreeSelect
                  style={{ width: 240 }}
                  className="w-400 ipt-h"
                  dropdownStyle={{ maxHeight: 250, overflow: "auto" }}
                  treeData={this.state.treeData}
                  placeholder="请选择部门"
                  treeDefaultExpandAll
                  value={this.state.departId}
                  onChange={value => {
                    this.setState({
                      departId: value
                    });
                  }}
                />
              </label>
              <label style={{ marginRight: 16 }}>
                监管会议角色：
                <Select
                  value={this.state.regulatorMeetChargeType}
                  style={{ width: 200 }}
                  onChange={(value) => {
                    this.setState({
                      regulatorMeetChargeType: value,
                    });
                  }}
                >
                  <Option value="">全部</Option>
                  {
                    this.state.regulatorMeetChargeTypeOptions.map(item => (
                      <Option key={item.codeValue} value={item.codeValue}>{item.label}</Option>
                    ))
                  }
                  <Option value="0">否</Option>
                </Select>
              </label>
              <Button
                style={{
                  marginRight: "16px",
                  marginBottom: "16px"
                }}
                type="primary"
                onClick={() => {
                  const pageParm = { ...this.state.pageParm };
                  let { keyWord, departId, regulatorMeetChargeType } = this.state;
                  pageParm.keyWord = keyWord;
                  pageParm.departId = departId;
                  pageParm.regulatorMeetChargeType = regulatorMeetChargeType
                  this.setState(
                    {
                      pageParm
                    },
                    () => {
                      this.setState({
                        forceUpdate: false
                      });
                    }
                  );
                }}
              >
                搜索
              </Button>
              <Button
                onClick={() => {
                  const pageParm = {
                    ...this.state.pageParm,
                    keyWord: "",
                    departId: "0",
                    regulatorMeetChargeType: ''
                  };
                  this.setState(
                    {
                      pageParm,
                      keyWord: "",
                      departId: "0",
                      forceUpdate: true,
                      regulatorMeetChargeType: '' 
                    },
                    () => {
                      this.setState({
                        forceUpdate: false
                      });
                    }
                  );
                }}
              >
                重置
              </Button>
            </div>
            <div>
              <Button
                type="primary"
                onClick={() => {
                  $perModal({
                    // fetchType: 'huawei',
                    type: 'radio',
                    onOk: (values, close) => {
                      this._addUser(values[0].perId, close);
                    }
                  });
                }}
              >
                添加成员
              </Button>
              <div style={{ float: "right" }}>
                用户账户数
                <span className="green">
                  {this.state.resourceData && this.state.resourceData.usedCount}
                </span>
                个/
                <span>
                  {this.state.resourceData && this.state.resourceData.sumCount}
                </span>
                个
              </div>
            </div>
            <div>
              <PTable
                style={{ marginTop: 20 }}
                columns={columns}
                url="pageForHuaweiMeetPerInfo" //后面需要修改菜单路径
                pageParm={this.state.pageParm}
                // dateChange={this.dateTableChange}
                forceUpdate={this.state.forceUpdate}
              />
            </div>
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
