/**
 * 统一选择组件
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Form, Select, InputNumber, Row, Col, Button } from "antd";
import "../../meeting.less";
import { formatCurrency } from "../../../../utils/utils";
const { Option } = Select;
const productBuyMode = [
  {
    label: "按月",
    value: "1"
  },
  {
    label: "按年",
    value: "2"
  },
  {
    label: "一次性",
    value: "3"
  }
];
//月份
const month = [
  {
    label: "1月",
    value: 1
  },
  {
    label: "2月",
    value: 2
  },
  {
    label: "3月",
    value: 3
  },
  {
    label: "4月",
    value: 4
  },
  {
    label: "5月",
    value: 5
  },
  {
    label: "6月",
    value: 6
  },
  {
    label: "7月",
    value: 7
  },
  {
    label: "8月",
    value: 8
  },
  {
    label: "9月",
    value: 9
  }
];
//年份
const year = [
  {
    label: "1年",
    value: 1
  },
  {
    label: "2年",
    value: 2
  },
  {
    label: "3年",
    value: 3
  }
];
@connect(state => ({
  comName: state.global.companyInfo.comName,
  mobilePhone: state.user.currentUser.mobilePhone
}))
@Form.create()
export default class StandardComponent extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      itemData: props.itemData,
      buyList: props.buyList, //拼合成的购买列表
      show: false //大于两个的时候，是否显示
    };
  }
  componentDidMount() {
    // console.log(this.props);
  }
  componentWillReceiveProps(nextProps) {
    this.setState({
      buyList: nextProps.buyList
    });
  }
  //购买方式发生改变
  _changeBuyMeans(modeList, selectValue, index, productBuyModeId) {
    modeList.forEach(item => {
      if (item.productBuyMode === selectValue) {
        const buyList = JSON.parse(JSON.stringify(this.state.buyList));
        buyList.productInfoList[index].eachAmount = item.amount;
        buyList.productInfoList[index].unit = item.unit;
        buyList.productInfoList[index].productBuyMode = selectValue;
        buyList.productInfoList[index].productBuyModeId = productBuyModeId;
        this.setState({ buyList }, () => {
          /**
           * 购买方式发生改变，会引发时长的改变
           * 默认时长的初始值是1个月或者1年，所以参数值都是1
           */
          this._changeDuration("1", index);
        });
      }
    });
  }
  //数量发生改变
  _changeNum(num, index) {
    const buyList = JSON.parse(JSON.stringify(this.state.buyList));
    buyList.productInfoList[index].num = num;
    this.setState({ buyList }, () => {
      this._changeTotal(index);
    });
  }
  //时长发生改变
  _changeDuration(selectValue, index) {
    const buyList = JSON.parse(JSON.stringify(this.state.buyList));
    buyList.productInfoList[index].duration = selectValue;
    this.setState({ buyList }, () => {
      this._changeTotal(index);
    });
  }
  //该条信息总金额发生改变
  _changeTotal(index) {
    const buyList = JSON.parse(JSON.stringify(this.state.buyList));
    buyList.productInfoList[index].amount =
      buyList.productInfoList[index].eachAmount *
      buyList.productInfoList[index].duration *
      buyList.productInfoList[index].num;
    this.setState({ buyList });
    this.props.changeBuyList(buyList);
  }
  //渲染时长选择框
  _renderDuration(data, index) {
    return (
      <Col
        className="gutter-row"
        sm={{ span: 11, offset: 1 }}
        md={{ span: 7, offset: 1 }}
        lg={{ span: 5, offset: 1 }}
        key={data}
      >
        时长：
        <Select
          defaultValue={data[0].value}
          style={{ width: 120 }}
          onChange={selectValue => {
            this._changeDuration(selectValue, index);
          }}
        >
          {data.map(item => {
            return (
              <Option value={item.value} key={item.value}>
                {item.label}
              </Option>
            );
          })}
        </Select>
      </Col>
    );
  }
  //
  _renderView(infoList, buyList, index) {
    return (
      <div key={index} style={{ marginBottom: "10px" }}>
        {infoList.productUrl && (
          <div style={{ float: "left" }}>
            <img
              src={infoList.productUrl}
              style={{
                width: "50px",
                height: "50px",
                paddingRight: "10px"
              }}
              alt=''
            ></img>
          </div>
        )}
        <h3>{infoList.name}</h3>
        <div style={{ paddingBottom: "10px" }}>{infoList.remark}</div>
        <div style={{ clear: "both" }}></div>
        <Row>
          <Col
            className="gutter-row"
            sm={{ span: 11, offset: 1 }}
            md={{ span: 7, offset: 1 }}
            lg={{ span: 5, offset: 1 }}
          >
            购买方式：
            <Select
              defaultValue={buyList.productInfoList[index].productBuyMode}
              style={{ width: 120 }}
              onChange={selectValue => {
                const productBuyModeList = infoList.productBuyModeList.filter(
                  item => {
                    return item.productBuyMode === selectValue;
                  }
                );
                this._changeBuyMeans(
                  infoList.productBuyModeList,
                  selectValue,
                  index,
                  productBuyModeList[0].productBuyModeId
                );
              }}
            >
              {infoList.productBuyModeList.map((item, i) => {
                return (
                  <Option value={item.productBuyMode} key={item.productId}>
                    {productBuyMode.map(optionList => {
                      if (optionList.value === item.productBuyMode) {
                        return optionList.label;
                      }
                    })}
                  </Option>
                );
              })}
            </Select>
          </Col>
          <Col
            className="gutter-row"
            sm={{ span: 11, offset: 1 }}
            md={{ span: 7, offset: 1 }}
            lg={{ span: 5, offset: 1 }}
            style={{ paddingTop: "4px" }}
          >
            单价：
            <span style={{ color: "#F59A23" }}>
              {formatCurrency(buyList.productInfoList[index].eachAmount)}
              {buyList.productInfoList[index].unit}
            </span>
          </Col>
          {buyList.productInfoList[index].productBuyMode === "1" &&
            this._renderDuration(month, index)}
          {buyList.productInfoList[index].productBuyMode === "2" &&
            this._renderDuration(year, index)}
          {/* <span></span> */}
          <Col
            className="gutter-row"
            sm={{ span: 11, offset: 1 }}
            md={{ span: 7, offset: 1 }}
            lg={{ span: 5, offset: 1 }}
          >
            数量：
            <InputNumber
              min={0}
              // precision={0.1}
              defaultValue={buyList.productInfoList[index].num}
              onChange={value => {
                this._changeNum(value, index);
              }}
            />
          </Col>
        </Row>
      </div>
    );
  }
  render() {
    const { itemData, buyList } = this.state;
    return (
      <div>
        <div>
          {itemData.productTypeUrl && (
            <div style={{ float: "left" }}>
              <img
                src={itemData.productTypeUrl}
                style={{ width: "80px", height: "80px", padding: "10px" }}
              ></img>
            </div>
          )}
          <div>
            <h1>{itemData.name}</h1>
            <span className="gray">{itemData.remark}</span>
          </div>
        </div>
        <div style={{ clear: "both" }}></div>
        <div className="standard">
          {itemData.productInfoList.length > 0 &&
            buyList &&
            itemData.productInfoList.map((infoList, index) => {
              if (index === 2) {
                return this.state.show ? (
                  itemData.productInfoList.map((infoList2, index2) => {
                    if (index2 > 1) {
                      return (
                        <div key={index2}>
                          {this._renderView(infoList2, buyList, index2)}
                        </div>
                      );
                    }
                  })
                ) : (
                  <span
                    onClick={() => {
                      this.setState({
                        show: !this.state.show
                      });
                    }}
                    style={{ color: "#0F71FF" }}
                    key={index}
                  >
                    +展开其他规格产品
                  </span>
                );
              } else if (index > 2) {
                return "";
              } else {
                return this._renderView(infoList, buyList, index);
              }
            })}
        </div>
      </div>
    );
  }
}
