/**
 * 选择会议资源
 */
import React, { Component } from "react";
import { Form } from "antd";
import "../../meeting.less";
import { getProductList } from "../../../../services/api";
import StandardComponent from "./StandardComponent";

@Form.create()
export default class SelectResource extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      meetingResourceList: [], //请求后台返回的资源列表
      buyMeetingResource: [] //用户选择的资源
    };
  }
  componentDidMount() {
    this._getProductList();
  }
  //获取资源列表
  _getProductList() {
    getProductList({
      productCategoryType: 11,
      productServiceType: 1
    }).then(res => {
      if (res.retType === "0") {
        this.setState({
          meetingResourceList: res.data
        });
        let buyMeetingResource = [];
        res.data.length > 0 &&
          res.data.map((item, index) => {
            buyMeetingResource.push({
              name: item.name,
              productServiceType:item.productServiceType,
              productInfoList: []
            });
            item.productInfoList.length > 0 &&
              item.productInfoList.map(infoList => {
                buyMeetingResource[index].productInfoList.push({
                  productName: infoList.name,
                  // productStatus: infoList.productStatus,
                  // productTypeUrl: infoList.productTypeUrl,
                  productBuyModeId:
                    infoList.productBuyModeList.length > 0 &&
                    infoList.productBuyModeList[0].productBuyModeId, //产品购买方式id
                  productBuyMode:
                    infoList.productBuyModeList.length > 0 &&
                    infoList.productBuyModeList[0].productBuyMode, //购买方式
                  eachAmount:
                    infoList.productBuyModeList.length > 0 &&
                    infoList.productBuyModeList[0].amount, //单价
                  unit:
                    infoList.productBuyModeList.length > 0 &&
                    infoList.productBuyModeList[0].unit, //单位
                  duration: 1, //时长
                  num: 0, //数量
                  amount: 0 //总价
                });
              });
          });
        this.setState({ buyMeetingResource });
      }
    });
  }
  render() {
    const { meetingResourceList, buyMeetingResource } = this.state;
    return (
      <div className="resource-list">
        <div className="label">云会议基础资源，若不购买，无法创建云会议。</div>
        {meetingResourceList.length > 0 &&
          meetingResourceList.map((item, index) => {
            return (
              <StandardComponent
                key={index}
                itemData={item}
                buyList={buyMeetingResource[index]}
                changeBuyList={data => {
                  const buyList = JSON.parse(
                    JSON.stringify(buyMeetingResource)
                  );
                  buyList[index] = data;
                  this.setState(
                    {
                      buyMeetingResource: buyList
                    },
                    () => {
                      this.props.changeTotal(this.state.buyMeetingResource);
                    }
                  );
                }}
              />
            );
          })}
      </div>
    );
  }
}
