import React, { Component } from 'react';
import { Tabs, Alert } from 'antd';
const TabPane = Tabs.TabPane;
import * as ajax from '../../../services/api';
import { Link } from 'dva/router';
import { connect } from 'dva';
@connect(state => ({
  global: state.global
}))
export default class InsuranceDetails extends Component {
  constructor(props, context) {
    super(props, context);  
    this.state = {
      url: '' 
    };
  }
  componentDidMount() {
    // 获取商城链接
    const params = new URLSearchParams(this.props.location.search);
    const url = decodeURIComponent(params.get('url'));
    if(url != 'null') {
      this.setState({url});
    }else {
      this._messageOnline();
    }
  }
  //在线购买保险的链接生成
  _messageOnline = () => {
    ajax
      .getOnlineInsBlbLink({
        comId: this.props.global.companyInfo.comId
      })
      .then(data => {
        this.setState({
          url: data.data
        });
      });
  };
  
  render() {
    // console.log(this.props.location.state.url)
    return (
      <Tabs defaultActiveKey="1" style={{padding: '0 16px'}}>
        <TabPane tab="保险商城" key="1">
          <Alert style={{marginBottom: 20}} message={(<div><span>可直接选择保险产品进行投保，系统默认填入企业未投保人员信息，单次投保最多仅支持500人；</span><br /><span>若您需要选择特定人员进行投保，请在【金融保险】-【企业保险】-【人员投保管理】中进行选择人员后再选择产品投保。</span></div>)} type="warning" showIcon/>
          {this.state.url&&<iframe
            title="购买在线保险"
            src={this.state.url}
            style={{ height: 'calc(100vh - 225px)'}}
            width="100%"
            frameBorder="0"
            allowFullScreen={true}
            allowtransparency="true"
          >
            您的浏览器不支持iframe，请升级
          </iframe>}
        </TabPane>
      </Tabs>   
    );
  }
}
