import React, { PureComponent } from 'react';
import style from "styled-components";
import { Card ,List, Avatar,Table,Button } from 'antd';
import "./InsuranceMangerment.less";
import TitleBlue from '../../../assets/images/title_blue.png';
import TitleYellow from '../../../assets/images/title_yellow.png';
export default class SxPolicetaikang40 extends PureComponent {
  render() {
    const contentdata = [
      {
        title: '预计投保人数：10人',
        description:<div className="totalcost">
                      <img src={TitleYellow} className="totalcostimg"/>
                      <span className="totalcostcount">预估保费：</span>
                      <span>1800元</span>
                      <span className="totalcostremark">&nbsp;（企业人数*该方案保费/人）</span>
                    </div>,
      },
      {
        title: '产品优势',
        description:<span>专为保安公司量身定制，<span style={{color:'#FF420F'}}>中高保障版</span>，365天7X24小时意外身故（伤残）+意外医疗+住院津贴，保安人员的贴身保镖。</span>,
      },
    ];
    const servicedata = [
        {
          title: '2项后续服务',
          description:<div>
                        <p>1、人员增减服务</p>
                        <p>1.支持在线完成人员增、减、替换，方便快捷。</p>
                        <p>2.账单式管理，人员批改明细一目了然。</p>
                        <p>3.专业客服7x24小时在线为您服务。</p>
                        <p>2、理赔咨询</p>
                        <p>1.在线自助报案，1对1理赔专员全程协助处理。</p>
                        <p>2.在线上传理赔资料，专业评估师为您争取更多利益。</p>
                        <p>3.最快当天内赔付，理赔实时进度尽在掌握。</p>
                      </div>,
        },
        {
          title: <span>3项<span style={{color:"#FF420F"}}>免费</span>增值服务</span>,
          description:<div>
                        <p>1、在线培训服务</p>
                        <p>精心打造可供保安员随时随地学习的在线高品质保安培训课程，并提供在线职业化考试及颁证。</p>
                        <p>2、人员管理服务</p>
                        <p>对保安员从进入保安服务公司到离职全过程进行电子化管理，包括个人信息、薪资变动、职位变动、奖惩情况、培训情况、考核数据、考勤数据等管理。</p>
                        <p>3、任务管理服务</p>
                        <p>依托LBS（基于位置的服务）应用，首创“任务派发、接收、轨迹跟踪地图可视化”全程动态管理模式。</p>
                      </div>,
        },
      ];
    const columns = [{
      title: '保险责任',
      dataIndex: 'name',
      render: text => <a >{text}</a>,
    }, {
      title: '保额',
      className: 'column-money',
      dataIndex: 'money',
    }];
    const liabilitydata = [{
        key: '1',
        name: '意外身故',
        money: '40万元  （武装押运人员保额为30万）',
      }, {
        key: '2',
        name: '意外伤残',
        money: '40万元  （武装押运人员保额为30万）',
      }, {
        key: '3',
        name: '意外医疗',
        money: '4万元  （武装押运人员保额为3万）',
      }, {
        key: '4',
        name: '意外住院津贴',
        money: '100元/天   （武装押运人员保额为50元/天）',
      }, {
        key: '5',
        name: '保费',
        money: '235元/人',
      }];
    return (
      <Container className="insurancescheme">
      <h3 className="insurancetitle">安保无忧全年意外险计划方案（40万）</h3>
        <p className="policytext">
            <span>政策要求：</span><br />
            <span>根据《保安服务管理条例》第四章第二十条规定，推进落实保安从业单位根据保安服务岗位的风险程度为保安员投保意外伤害保险，
                保险保障额度应当<i>不低于陕西省人身损害赔偿标准（约37万）</i>，并通过保安服务监管信息系统将投保情况实时向公安机关报备。</span>
        </p>
        <p className="insurancetext">
          <span>尊敬的XXXX保安公司：</span>
          <br />
          <span>感谢您对安保无忧全年意外险（40万计划）的亲睐！ ！ ！</span>
          <br />
          <span>产品方案请细看</span>
        </p>
        <Card title="安保无忧全年意外险（40万计划）">
          <Table
            columns={columns}
            dataSource={liabilitydata}
            bordered
            pagination={false}
          />
          <List
          itemLayout="horizontal"
          dataSource={contentdata}
          renderItem={item => (
            <List.Item>
              <List.Item.Meta
                avatar={<Avatar src={TitleBlue} style={{ }}/>}
                title={<span>{item.title}</span>}
                description={item.description}
              />
            </List.Item>
          )}
          />
        </Card>
        <Card title="投保后您可享有“2+3”服务">
          <List
          itemLayout="horizontal"
          dataSource={servicedata}
          renderItem={item => (
            <List.Item>
              <List.Item.Meta
                avatar={<Avatar src={TitleBlue} style={{ }}/>}
                title={<a>{item.title}</a>}
                description={item.description}
              />
            </List.Item>
          )}
        />
        </Card>
        <div className="customerservice">
          <div className="customerservicetotle">
            <span className="customerservicetext">如有疑问，欢迎拨打百保盾客服电话：</span>
            <span className="customerservicephone">400-662-9696</span>
          </div>
          <div className="customerservicebtn">
            <Button>下载PDF</Button>
            <Button
            onClick={() => {
              window.print();
            }}
            >在线打印</Button>
            <Button>获取其他方案</Button>
            <Button type="primary">立即购买</Button>
          </div>
        </div>
      </Container>
    );
  }
}

const Container = style.div`
  padding:24px;
  .insurancetitle{
    padding-bottom:13px;
    border-bottom: 1px solid #e8e8e8;
    font-size: 20px;
    color: #333333;
    font-weight:bold;
    font-family: PingFangSC-Medium;
  }
  .insurancetext{
    font-family: PingFangSC-Medium;
    font-size: 14px;
    color: #666666;
  }
  .policytext{
      span{
          i{
            font-style:normal;
            color: #FF420F;
          }
      }
  }
  .ant-card{
    margin-top:15px;
  }
  .ant-card-body{
    padding:5px 12px;
  }
  .ant-card-head{
    background-color:#F5F9FF;
    padding:0;
  }
  .ant-card-head-title{
    margin-left:24px;
    color:#666666;
    font-weight:bold;
  }
  .ant-list-item-meta-avatar{
    width: 6px;
    height:6px;
    position:relative;
    top:7px;
    left:10px;
  }
  .ant-avatar{
    width: 6px;
    height:6px;
  }
  .ant-list-item-meta-title>a{
    color:#0F71FF;
  }
  .ant-list-item-meta-description{
    font-size:12px;
    color:#666666;
  }
  .ant-list-item-meta-description div p{
    margin-bottom: 0px;
    fontSize: 12px;
  }
  .totalcost{
    font-size:14px;
    color:#FF420F;
    margin-left:-12px;
  }
  .totalcostimg{
    margin-top:-3px;
  }
  .totalcostcount{
    margin-left:6px;
  }
  .totalcostremark{
    color:#2A2A2A;
  }
  .ant-table-thead tr th{
    color:#333333 ;
    font-size:12px;
    font-weight:bold;
   
  }
  .ant-table-row td{
    color:#666666 ;
    font-size:12px;
  }
  .ant-table-row td a{
    color:#666666 ;
    font-size:12px;
  }
  th.column-money,
  td.column-money {
    text-aligh:center;
  }
  .ant-table-wrapper{
    padding:10px 10px 0 10px;
  }
  .ant-table-tbody tr:nth-of-type(5) td:nth-of-type(2){
    color:#FF420F;
  }
  .customerservicetext{
    font-family: PingFangSC-Regular;
    font-size: 14px;
    color: #333333;
  }
  .customerservicephone{
    font-family: PingFangSC-Regular;
    font-size: 20px;
    color: #0F71FF;
  }
  .customerservice{
    padding:15px 0;
  }
  .customerservicetotle{
    float:left;
  }
  .customerservicebtn{
    float:right;
  }
  .customerservicebtn button{
    margin-left:5px;
  }
`;
