import React, { Component } from "react";
import { render } from 'react-dom';
import './modal.less';
import { Button, Icon, Modal } from "antd";

function renderModal(modalInfo) {

  class ModalComponent extends Component {
    constructor(props, context) {
      super(props, context);

      this.state = {
        ...modalInfo
      };
    }
    render() {
      return (
        <Modal
          closable={false}
          visible={this.state.visible}
          wrapClassName="modal_on_footer"
          width={416}
        >
          <div className="bcx_modal_content">
            {(() => {
              switch(modalInfo.icon) {
                case 'info':
                  return <Icon type="info-circle" style={{ fontSize: 26, color: '#1890ff', marginRight: 15 }} />;
                case 'success':
                  return <Icon type="check-circle" style={{ fontSize: 26, color: '#52c41a', marginRight: 15 }} />;
                case 'warning':
                  return <Icon type="exclamation-circle" style={{ fontSize: 26, color: '#faad14', marginRight: 15 }} />;
                case 'error':
                  return <Icon type="close-circle" style={{ fontSize: 26, color: '#f5222d', marginRight: 15 }} />;
                default:
                  // return <Icon type="einfo-circle" style={{ fontSize: 26, color: '#1890ff', marginRight: 15 }} />;
                  return '';
              }
            })()}
            <div className="info">
              <h3>{modalInfo.title}</h3>
              <div className="info_container">
                {modalInfo.message}
                {/* <span style={{ color: '#FF9900' }}></span> */}
              </div>
              <div className="bcx_modal_btns">
                {modalInfo.footer instanceof Array && modalInfo.footer.map((btn, index) => {
                  return <Button
                    key={index}
                    type={btn.type?btn.type: ''} 
                    onClick={
                    () => {
                      if(typeof btn.onPress == 'function') {
                        btn.onPress();
                      }
                      this.setState({
                        visible: false
                      });
                    }
                  }>{btn.text}</Button>
                })}
              </div>
            </div>
          </div>
        </Modal>
      );
    }
  }
  let div = document.createElement('div');
  render(<ModalComponent />, div);
}


export default function (
  title = '提示', 
  message = '', 
  footer = [{ text: '确定' }], 
  icon= 'warning', 
  maskClosable = false
  ) {
  const modalInfo = {
    visible: true,
    maskClosable,
    title,
    message,
    footer,
    icon
  };
  renderModal(modalInfo);
}