import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import { withRouter } from 'dva/router';
import {
  Input,
  Button,
  Alert,
  Popover
} from 'antd';
// import $modal from '../../../../utils/modal';
// import $nModal from '../../../../utils/modal/nModal';

import tablePage from '../../../../utils/hoc/tablePage';
import DepartSelect from '../../../../components/user/DepartSelect';
import { excelButtonHOC } from '../../../../components/ExcelButtonOline';
import columnFun from './columns';

@connect(state => ({
  global: state.global
}))
@tablePage()
@withRouter
export default class Opened extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      total: 0,
      selectedRows: [],
      selectedRowKeys: []
    };
  }
  componentDidMount() {

  }
  // 表格渲染
  renderOrderList = () => {
    const columns = columnFun.call(this);
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="getOpenJointlyPerList"
        scroll={{ x: '1500px' }}
        pagination={{ showTotal: total => `总共 ${total} 条` }}
        dateChange={(data) => {
          this.setState({
            total: data.total
          });
          this.setState({
            selectedRows: [],
            selectedRowKeys: []
          });
        }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator } = this.props.form;
    // const TreeSelecter = departSelecter(TreeSelect);
    return (
      <div>
        <Alert
          message={<div style={{ color: '#333' }}>
            <span>您可在此页面查看企业下保安员证联名卡开通情况；保安员证联名卡开通后，不仅可以作为保安员资格证使用，还可以作为工资卡发放工资。</span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        {/* <SearchForm
          onSearch={this._search}
        /> */}
        <SearchForm
          // onSearchClick={this.props.updateCount}
          arrange={values => {
            values.departIds = values.departIds.map(({value}) => {
              if(/^\-1/.test(value)) {
                return '-1';
              }else {
                return value.split('-')[0];
              }
            }).join(',');
            // values
            return values;
          }}
        >
          <>
            {/* <Form.Item label="关键字">
              {getFieldDecorator('keyword', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入姓名/身份证号/手机号" />
              )}
            </Form.Item> */}
            <Form.Item label="姓名">
              {getFieldDecorator('name', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入姓名" />
              )}
            </Form.Item>
            <Form.Item label="手机号">
              {getFieldDecorator('mobilePhone', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入手机号码" />
              )}
            </Form.Item>
            <Form.Item label="身份证号">
              {getFieldDecorator('idCardNo', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入身份证号" />
              )}
            </Form.Item>
            <Form.Item label="部门">
              {getFieldDecorator('departIds', {
                initialValue: []
              })(
                <DepartSelect 
                  // showAll={true} 
                  style={{minWidth: 200, maxWidth: 600}} 
                  treeCheckable={true}
                  treeCheckStrictly={true}
                />
              )}
            </Form.Item>
          </>
        </SearchForm>
        <Btns>
          <Popover content={<div style={{ padding: 10 }}>点击搜索后可导出结果</div>}>
            {
              excelButtonHOC({
                // disabled: !this.props.clicked,
                disabled: this.state.total == 0,
                type: 'primary',
                method: 'GET',
                params: this.props.searchData,
                apiurl: "/task/per-jointly-card/export-open-jointly-per",
                downloadname: this.props.global.companyInfo.comName + "_已开通联名卡人员",
                children: '导出筛选结果为excel'
              }, Button)
            }
          </Popover>
        </Btns>
        {/* 表格 */}
        {this.renderOrderList()}

      </div >
    );
  }
}

const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;