/**
 * 【薪资代发】导入薪资线下代发
 */
import React, { Component } from "react";
import "../financialWallet.less";
import { withRouter } from "dva/router";
import { host } from "../../../services/api";
import { Spin, Button, Upload, message } from "antd";
import store from "store";
@withRouter
export default class UploadFile extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      faileDisabled: "none"
    };
  }
  render() {
    const uploadExcel = {
      name: "xfile",
      action: `${host}/task/com/grant/import-offline-grant-temp`,
      headers: {
        authorization: "Basic c2Fhc3dlYjp3ZWI=",
        access_token: store.get("saas")["access_token"],
        Accesstoken: store.get('saas')['access_token']|| sessionStorage.userV5Token,

      },
      showUploadList: false,
      // responseType:'blob',
      data: {
        grantYears: this.props.grantYearsDown,
        comGrantId: this.props.comGrantId
      }
    };
    const beforeUpload = file => {
      this.setState({
        loading: true
      });
      let ifError = true;
      // console.log(file);
      if (file.name.indexOf("xls") === -1 && file.name.indexOf("xlsx") === -1) {
        this.setState({
          loading: false
        });
        message.error("请上传xls或xlsx文件!");
        ifError = false;
        return false;
      }
      if(file.size/1024/1024 > 1.5){
        this.setState({
          loading: false
        });
        message.error('请上传小于1.5M文件!');
        ifError = false;
      }
      return ifError;
    };
    //上传文件
    const UploadChange = info => {
      this.setState({
        faileDisabled: "none"
        // loading: true
      });
      if (info.file.status === "uploading") {
        return;
      }
      if (info.file.status === "done") {
        const { data, msg, retType } = info.file.response;
        //"retType":"-1"为错误，data会有相应的路径值
        //"retType":"0"为正确，data为空
        if (retType === "-1") {
          message.error(msg);
          if (data) {
            this.setState({
              faileDisabled: "block",
              failData: data
            });
          }
        } else if (retType === "0") {
          message.success(msg);
          this.props.onSuccess()
        } else {
          message.error(msg);
        }
        this.setState({
          loading: false
        });
      }
    };
    return (
      <div>
        <div
          style={{
            position: "fixed",
            width: "100%",
            height: "100%",
            top: 0,
            left: 0,
            zIndex: 99999,
            display: this.state.loading ? "block" : "none"
          }}
        >
          <div
            style={{
              width: "100%",
              height: "100%",
              background: "rgba(0, 0, 0, .2)"
            }}
          />
          <Spin
            style={{
              position: "absolute",
              top: "50%",
              left: "50%"
            }}
            // tip="正在导入数据，请稍后..."
            tip={(() => {
              return (
                <div>
                  <span>系统正在为您识别并导入数据内容...</span>
                  <br />
                  <span>若数据量较大，导入时间相对偏长，请耐心等待</span>
                </div>
              );
            })()}
          />
        </div>
        <Upload
          onChange={UploadChange}
          beforeUpload={beforeUpload}
          {...uploadExcel}
        >
          <Button type="primary" disabled={!this.props.grantYearsDown}>
            选择上传文件
          </Button>
          <p>支持扩展名：.xls\.xlsx</p>
        </Upload>
        <div style={{ display: this.state.faileDisabled }}>
          导入失败信息表：
          <a
            type="primary"
            href={this.state.failData}
            style={{ color: "red", textDecoration: "underline" }}
            onClick={() => {
              this.setState({
                faileDisabled: "none"
              });
            }}
          >
            点击下载
          </a>
        </div>
      </div>
    );
  }
}
