import React from 'react';
import { connect } from 'dva';
import NotOpen from './NotOpen';
import Opened from './Opened';
import '../financialWallet.less';
import {
  taskComBhAccountGetComBhAccount,
} from '../../../services/api';
@connect(state => ({
  global: state.global
}))
export default class BusinessWallet extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      bankInfo: null,  //银行账户信息
      isLoading: false,//数据是否加载完成
    };
  }
  componentWillMount() {
    this._getBankInfo();
  }
  componentDidMount() {
    const companyInfo = this.props.global.companyInfo;
    //将数据存在storage中，防止刷新的时候数据丢失的现象
    if (companyInfo.comName) {
      window.sessionStorage.setItem('companyInfo', JSON.stringify(this.props.global.companyInfo));
    }

  }
  _getBankInfo = () => {
    taskComBhAccountGetComBhAccount().then(res => {
      this.setState({
        bankInfo: res.data,
        isLoading: true
      })
    }).catch(() => {
      this.setState({
        isLoading: true
      })
    });
  }

  render() {
    const { bankInfo, isLoading } = this.state;
    return (
      <div className="financial_container">
        {
          isLoading && !bankInfo &&
          <NotOpen reload={this._getBankInfo} />
        }
        {
          isLoading && bankInfo &&
          <Opened bankInfo={bankInfo} reload={this._getBankInfo}/>
        }
      </div>
    );
  }
}