import React, { Component } from "react";
import { Modal, Form, Input, Button, Alert, Select, notification, message, Col } from 'antd';
import PFromUpload from '../../../../components/Pro/PFromUpload';
import {
  getConfigBankList, systemPlatNewsSendVerificationCode, systemPlatNewsVerificationCode, saveBankCardChangeEvent,
  BhAccountSendVerifyCode,
  BhAccountUpdateMobilephone
} from '../../../../services/api'
import $nModal from '../../../../utils/modal/nModal';
// import modal from "../../../../utils/modal";
import $modal from '../../../../utils/modal';
const { Option } = Select;
const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 7 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 17 },
    md: { span: 17 }
  }
};
@Form.create()
export default class UpdateMobileModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      time: 0, // 可发送验证码剩余时间
      btnName: '获取验证码',  // 发送验证码按钮名字
      timer: null, // 验证码定时器

      bankList: [],  //银行列表
    }
  }
  componentDidMount() {
  }
  _formSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (err) return;
      systemPlatNewsVerificationCode({ mobile: values.mobile, code: values.code }).then(res => {
        if (res.retType == '0') {
          let code = null
          const { mobilePhone,bankCardNo} = this.props.bankInfo
          const DATA = {
            mobilePhone,
            transCode: 'HQJQ',
            bankCardNo,
            comName: this.props.companyInfo.comName,
          };
          const _this = this
          //发送渤海银行的验证码
          BhAccountSendVerifyCode(DATA).then(res => {
            if (res.retType == '0') {
              $nModal({
                title: '已向旧绑定手机号发送验证码！',
                okText: '提交',
                content: (
                  <>
                    <Alert
                      type="warning"
                      message={<div>系统已向{mobilePhone.substr(0,3) + "****" + mobilePhone.substr(7)}发送短信验证码，请将接收到的短信验证码输入下框并验证。</div>} />
                    <div style={{ width: '200px', marginTop: '10px' }}>
                      <Input
                        width=""
                        placeholder='请输入短信验证码'
                        onChange={e => {
                          code = e.target.value
                        }}
                        maxLength={10}
                      />
                    </div>
                  </>
                ),
                onOk: close => {
                  if (code) {
                    BhAccountUpdateMobilephone({
                      mobilePhone:values.mobile,
                      activeCode:code
                    }).then(res=>{
                      if(res.retType=='0'){
                        close();
                        Modal.success({
                          title:'修改成功！',
                          content:(
                          <span style={{color:'orange'}}>新绑定手机号：{values.mobile}</span>
                          ),
                          onOk() {
                            _this.props.onCancel();
                            _this.props.form.resetFields();
                            _this.props.update();
                          }
                        })
                      }
                    }).catch(err=>{
                      Modal.error({
                        title:'修改失败！',
                        content:err.msg
                      })
                    })
                  } else {
                    message.error("请先输入验证码")
                  }
                }
              })
            }
          })
        }
      })
    });
  }
  render() {
    const { getFieldDecorator, getFieldValue } = this.props.form;
    // const { mobilePhone, bhVirlAcctNo, bankOutlets, bankNo, isBhBank, comName, bankCardNo } = this.props.bankInfo
    return (
      <div>
        <Modal
          // width={600}
          title="修改企业基本户"
          visible={this.props.visible}
          // okText='提交修改'
          onOk={this._formSubmit}
          onCancel={this.props.onCancel}
          className="wallet_modal"
          footer={null}
        >
          <Form style={{ marginTop: 20 }}>
            <Form.Item {...formItemLayout} label='新绑定手机号:'>
              {getFieldDecorator('mobile', {
                // initialValue: this.state.mobilePhone,
                rules: [
                  {
                    required: true,
                    message: '请输入新绑定手机号'
                  },
                  {
                    validator: (rule, value, callback) => {
                      if (value && !/^1[0-9]{10}$/.test(value)) {
                        callback('请输入正确手机号');
                      } else {
                        callback();
                      }
                    }
                  }
                ]
              })(
                <div style={{ width: '155px', display: 'inline-block' }}>
                  <Input
                    placeholder='请输入新绑定手机号'
                    // onChange={e => {
                    //   this.setState({
                    //     codeValue: e.target.value
                    //   });
                    // }}
                    maxLength={50}
                  />
                </div>)}
              <Button
                type="primary"
                disabled={this.state.time > 0}
                style={{ marginLeft: 15 }}
                onClick={() => {
                  let { time, timer } = this.state;
                  const mobile = getFieldValue('mobile')
                  if (time > 0) return;
                  if (timer) clearInterval(timer);
                  if (!mobile) {
                    return notification.error({
                      message: '请先输入正确的手机号'
                    });
                  }
                  systemPlatNewsSendVerificationCode({ mobile }).then(res => {
                    // this.setState({
                    // orderId: res.data
                    // });
                    time = 60;
                    timer = setInterval(() => {
                      time -= 1;
                      if (time > 0) {
                        this.setState({
                          time,
                          btnName: `重试(${time})`,
                          timer
                        });
                      } else {
                        clearInterval(timer);
                        this.setState({
                          btnName: '获取验证码',
                          timer: null
                        }, () => {
                          this.setState({
                            time: 0
                          });
                        });
                      }
                    }, 1000);
                  })
                }}
              >{this.state.btnName}</Button>
            </Form.Item>
            <Form.Item {...formItemLayout} label='新手机号验证码:'>
              {getFieldDecorator('code', {
                // initialValue: this.state.activeCode,
                rules: [
                  {
                    required: true,
                    message: '请输入验证码'
                  },
                  {
                    validator: (rule, value, callback) => {
                      if (value && !/\d{0,6}/.test(value)) {
                        callback('请输入正确验证码');
                      } else {
                        callback();
                      }
                    }
                  }
                ]
              })(<Input
                placeholder='请输入短信验证码'
                onChange={e => {
                  this.setState({
                    codeValue: e.target.value
                  });
                }}
                maxLength={50}
              />)}
            </Form.Item>
            <div style={{ textAlign: "center" }}>
              <Button type="primary" htmlType="submit" onClick={this._formSubmit}>下一步</Button>
            </div>
          </Form>
        </Modal>
      </div>
    );
  }
}

