import React, { Component } from "react";
import moment from 'moment';
import "moment/locale/zh-cn";
import {
  DatePicker,
  Button,
  Table
} from 'antd';
import BudgetDrawer from './BudgetDrawer';
import {
  getAccountHistoryDetailList
} from '../../../../services/api';
import { value } from "numeral";
const { RangePicker } = DatePicker;
const transCode = {
  'XNCZ': '充值',
  'XNTX': '提现',
  'XNZZ': '转账',
  'DJJD': '冻结解冻',
  'JDZZ': '解冻转账',
  'DDQR': '支付订单确认',
  'SHFKQR': '确认收货付款',
  'ZFTKQR': '退款',
  'XXCZ': "线下充值",
  'DFXZ': '代发薪资',
  'YEZF': ' 余额支付',
  'YETH': ' 余额退货',
  'STDDQR': ' 实体卡支付订单确认',
  'ZDFK ': '订单 7 天自动付款',
  'FEEMG ': '手续费收取',
  'YHSXF': ' 银行手续费收取',
  'PTSXF': ' 平台手续费',
  'SXFJS': ' 手续费结算',
  'DJ': ' 冻结',
  'JD': ' 解冻',
  'THLZ': ' 提现退汇',
  'JGFR': ' 机构分润',
  'SHJS': ' 商户支付结算',
  'XXCZ ': '线下充值',
  'SXFTH ': '手续费退回',
  'JDJS': ' 解冻结算',
  'GCFKZJ ': '轧差付款追加',
  'GCFKTH ': '轧差付款退回',
  'GCFKQR ': '轧差付款确认',
  'XNCZGIF ': '虚拟充值接口',
  'XNTXGIF ': '虚拟提现接口',
  'XNKHGIF ': '开通账户接口',
  'XNZZGIF ': '虚拟转账接口',
  'DJJDGIF ': '账户冻结/解冻接口',
  'JDZZGIF': ' 解冻转账接口',
  'XXBDGIF': ' 账户信息绑定/变更接口',
  'YEDDQRGIF': ' 支付订单确认接口',
  'SHFKQRGIF ': '确守收货付款接口',
  'ZFTKQRGIF ': '退款接口',
  'MMCZGIF ': '支付密码重置接口',
  'HQDMGIF ': '短信动态密码获取',
  'KHBDGIF': ' 开户绑定接口',
  'HQDMIF': ' 开户绑定获取短信验证码接口',
  'KHTZIF': ' 批量开户文件通知',
  'KHJGIF ': '批量开户文件结果查询',
  'XNTK': ' 线下入金退款',
  'FXJHRQ ': '反向激活重发',
  'FXJHTB ': '反向激活验证',
  'MYQY ': '免验签约',
  'XNXH': ' 销户',
  'BTDFTK': '代发薪资退款',
}
export default class StepFive extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      tableList: [],
      searchData: {  // 表格数据请求参数
        startDate: moment().subtract(30, 'days').format('YYYY-MM-DD'),
        endDate: moment().format('YYYY-MM-DD'),
        // pageNumber: '1',  // 页	
        // pageSize: '10'  //条目
      },
      rangePickeValue: [moment().subtract(30, 'days'), moment()],
      // 详情抽屉
      detailInfo: null, //当前的详情信息
    };
  }
  componentDidMount() {
    this.__getTable();
  }
  componentWillReceiveProps(props) {
    // if (!!props.bankInfo) {
    //   this.__getTable();
    // }
  }

  // 获取表格信息
  __getTable = () => {
    let { searchData } = this.state;
    const { bankInfo } = this.props;
    if (!bankInfo) return;
    searchData = {
      ...searchData,
      // bankInfo
    }
    getAccountHistoryDetailList(searchData).then(res => {
      this.setState({
        tableList: res.data[0],
      });
    });
  }
  render() {
    const columns = [
      {
        title: '流水号',
        dataIndex: 'AcctTransSeqNo',
        key: 'AcctTransSeqNo',
      },
      {
        title: '交易日期',
        dataIndex: 'AcctTransDate',
        key: 'AcctTransDate'
      },
      {
        title: '第三方流水号',
        dataIndex: 'AppSeqNo',
        key: 'AppSeqNo'
      },
      {
        title: '第三方交易日期',
        dataIndex: 'AppTransDate',
        key: 'AppTransDate'
      },
      {
        title: '交易类型',
        dataIndex: 'SubjectCode',
        key: 'SubjectCode',
        render: (value) => {
          return transCode[value]
        }
      },
      // {
      //   title: '借贷标志',
      //   dataIndex: 'Dorc',
      //   key: 'Dorc'
      // },
      {
        title: '支出(元)',
        dataIndex: 'DebitAmount',
        key: 'DebitAmount',
        render: value => value || '-'
      },
      {
        title: '收入(元)',
        dataIndex: 'CebitAmount',
        key: 'CebitAmount',
        render: value => value || '-'
      },
      {
        title: '交易币种',
        dataIndex: 'Ccy',
        key: 'Ccy',
        render: value => '人民币'
      },
      {
        title: '清算日期',
        dataIndex: 'AppSettDate',
        key: 'AppSettDate',
        render: value => value || '-'
      },
      {
        title: '虚拟账户号',
        dataIndex: 'TransCifNo',
        key: 'TransCifNo',
        render: value => value || '-'
      },
      {
        title: '余额(元)',
        dataIndex: 'BalanceAmt',
        key: 'BalanceAmt',
        render: value => value || '-'
      },
      {
        title: '对方账号',
        dataIndex: 'OppAcctNo',
        key: 'OppAcctNo',
        render: value => value || '-'
      },
      {
        title: '机构号',
        dataIndex: 'TransDepartmentId',
        key: 'TransDepartmentId',
        render: value => value || '-'
      },
      {
        title: '交易附言',
        dataIndex: 'TransRemark',
        key: 'TransRemark',
        render: value => value || '-'
      },
      // {
      //   title: '操作',
      //   dataIndex: 'operation',
      //   key: 'operation',
      //   fixed: 'right',
      //   width: 100,
      //   render: (text, record) => (
      //     <div>
      //       <span
      //         style={{
      //           color: '#108EE9',
      //           cursor: 'pointer',
      //           marginRight: '20px'
      //         }}
      //         onClick={() => {
      //           this.setState({
      //             detailInfo: record
      //           });
      //         }}
      //       >
      //         详情
      //       </span>
      //     </div>
      //   )
      // }
    ];
    return (
      <div>
        <label style={{ marginRight: '16px', display: 'inline-block' }}>
          交易时间：
          <RangePicker
            format='YYYY-MM-DD'
            value={this.state.rangePickeValue}
            onChange={(date, dateString) => {
              this.setState({
                rangePickeValue: date,
                searchData: {
                  ...this.state.searchData,
                  startDate: dateString[0],
                  endDate: dateString[1]
                }
              });
            }}
            style={{ marginBottom: '10px' }}
          />
        </label>
        <Button
          style={{
            marginRight: '16px',
            marginBottom: '16px',
            padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
          }}
          type="primary"
          onClick={() => {
            this.__getTable();
          }}
        >
          搜索
        </Button>
        <Button
          style={{
            marginRight: '16px',
            marginBottom: '16px',
            padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
          }}
          onClick={() => {
            this.setState({
              searchData: {  // 表格数据请求参数
                startDate: moment().subtract(30, 'days').format('YYYY-MM-DD'),
                endDate: moment().format('YYYY-MM-DD'),
                pageNumber: '1',  // 页	
                pageSize: '10'  //条目
              },
              rangePickeValue: [moment().subtract(30, 'days'), moment()]
            });
          }}
        >
          重置
        </Button>
        <Table
          dataSource={this.state.tableList}
          columns={columns}
          pagination={false}
          scroll={{ x: 2000 }}
        />

        <BudgetDrawer
          info={this.state.detailInfo}
          onClose={() => {
            this.setState({
              detailInfo: null
            });
          }}
        />
      </div>
    );
  }
}
