import React, { Component } from "react";
import { connect } from "dva";

import NotOpened from './NotOpened';
import Opened from './Opened';
import '../financialWallet.less';
import * as ajax from '../../../services/api';
import { Tabs } from "antd";

const { TabPane } = Tabs;
@connect(state => ({
  profile: state.profile
}))
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state={
      noOpenAccountPerCount: 0,
      openAccountPerCount: 0
    };
  }

  componentDidMount() {
    this.__getAmount();
  }
  __getAmount() {
    ajax.getPerOpenWalletServiceInfo().then(res => {
      const { noOpenAccountPerCount, openAccountPerCount } = res.data;
      this.setState({
        noOpenAccountPerCount,
        openAccountPerCount
      });
    });
  }
  render() {
    return (
      <div  style={{paddingTop:'10px'}}>
       <Tabs
          tabBarStyle={{ marginLeft: 24, marginRight: 24 }}
        >
          <TabPane tab={`未开通(${this.state.noOpenAccountPerCount})`} key="1">
            <NotOpened refresh={() => {
              this.__getAmount();
            }}></NotOpened>
          </TabPane>
          <TabPane forceRender
            tab={`已开通(${this.state.openAccountPerCount})`}
            key="2"
          >
            <Opened refresh={() => {
              this.__getAmount();
            }}></Opened>
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
