import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Input,
  Button,
  Table,
  Select,
  Modal,
  Radio,
  Alert,
  notification
} from 'antd';
import $modal from '../modal';
import { withRouter } from 'dva/router';
import * as ajax from '../../../services/api';
const { Option } = Select;
@connect(state => ({
  global: state.global
}))
@withRouter
export default class Uninsured extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // 搜索部分
      searchData: {  // 表格数据请求参数
        keyword: '',  //关键字
        pageNumber: '1',  // 页	
        pageSize: '10'  //条目
      },
      keyword: '', //关键字
      // 表格部分
      tableList: [], // 表格数据
      pagination: {  //分页数据
        total:1,
        current: 1,
        pageSize: 10,
        showSizeChanger: true,
        showQuickJumper: true,
        pageSizeOptions:['10', '50', '100', '500'],
        onShowSizeChange:(current, pageSize) => {
          // this.setState({
          //   searchData: {
          //     ...this.state.searchData,
          //     pageSize: pageSize+'',
          //     pageNumber: current+''
          //   }
          // },() => {
          //   console.log(this.state.searchData);
          //   this.getTable(this.state.searchData);
          // });
          // console.log(current, pageSize);
        }
      },
      // totalNums: 0, //所有数量
      selectedRows: [], //表格中选中的数组
      recoverRows: [],  //表格中选中的数组 （备份）
      selectedRowKeys: [],
      // 弹窗部分
    };
  }



  componentDidMount() {
    this.getTable(this.state.searchData, data => {

    });
  }

   // 获取表格信息
   getTable = (data, cb) => {
    ajax.getNoOpenWalletServicePerList(data).then(res => {
      const { comName } = this.props.global.companyInfo;
      const tableList = res.data.data.map(item => {
        if(item.departName == '-') {
          item.departName = comName;
        }
        return item;
      });
      this.setState({
        tableList,
        pagination: {
          ...this.state.pagination,
          total: res.data.total,
          current: res.data.pageNumber,
          pageSize: res.data.pageSize
        },
        selectedRowKeys: [],
        selectedRows: []
      }, () => {
        cb&&cb(res.data);
        this.props.refresh();
      });
    });
  }

  // 表格渲染
  renderOrderList = () => {
    const columns = [
      {
        title: '部门',
        dataIndex: 'departName',
        key: 'departName',
        render: (text, record) => {
          if(record.departName) {
            return <span>{record.departName}</span>;
          }else {
            return <span>{this.state.treeData[1].label}</span>;
          }
        }
      },
      {
        title: '姓名',
        dataIndex: 'name',
        key: 'name'
      },
      {
        title: '身份证号',
        dataIndex: 'idCardNo',
        key: 'idCardNo'
      },
      {
        title: '手机号',
        dataIndex: 'mobilePhone',
        key: 'mobilePhone'
      },
      {
        title: '操作',
        dataIndex: 'operation',
        key: 'operation',
        render: (text, record) => (
          <div>
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
                marginRight: '20px'
              }}
              onClick={() => {
                let batchData ={
                  isCheckAll: 0,  // isCheckAll 是否批量选中（1:是 0:否）
                  perId: record.perId
                }
                ajax.batchNotice(batchData).then(res => {
                  // this.getTable(this.state.searchData);
                });
              }}
            >
              提醒开通
            </span>
          </div>
        )
      }
    ];
    return (
      <div>
        <Table
          dataSource={this.state.tableList}
          columns={columns}
          pagination={this.state.pagination}
          onChange={(pagination) => {
            const searchData =  {  // 搜索数据
              ...this.state.searchData,
              pageNumber: pagination.current,  // 页	
              pageSize: pagination.pageSize
            };
            this.setState({
              searchData
            },() => {
              this.getTable(searchData);
            });       
          }}
          rowSelection={{
            onChange: (selectedRowKeys, selectedRows) => {
              this.setState({
                selectedRows,
                selectedRowKeys
              });
            },
            selectedRowKeys: this.state.selectedRowKeys     
          }}
        />
      </div>
    );
  };

  render() {
    return (
      <div className="tab_inner">
        <Alert
          message={
            <div>
              <span>您可在此页面查看企业下员工钱包服务开通情况；只有员工开通了钱包服务，薪资代发才可发放到该员工钱包中，否则无法发放。</span><br/>
              <span>
              若您尚未开通薪资代发服务，可咨询在线客服或服务热线（400-662-9696）咨询服务开通相关事宜；企业签署了薪资代发服务协议后，系统将自动开启薪资代发服务功能页面，您可先了解<a href="http://wiki.baibaodun.cn/document/indexOut?document_id=1423" target="_blank">如何进行薪资代发？</a>
              </span>
            </div>
        }
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <div className="form">
          <label style={{ marginRight: 16 }}>
            关键字：
            <Input
              style={{ width: '214px', marginBottom: '10px' }}
              placeholder="请输入姓名/身份证/手机号"
              value={this.state.keyword}
              onChange={(e) => {
                this.setState({
                  keyword: e.target.value
                });
              }}
              maxLength={20}
            />
          </label>
          <Button
            style={{
              marginRight: '16px',
              marginBottom: '16px',
              padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
            }}
            type="primary"
            onClick={() => {
              const data = {
                ...this.state.searchData,
                perType: this.state.perType,  //人员类型
                keyword: this.state.keyword,  //关键字
                departId: this.state.departId == '0'?'':this.state.departId  //部门id
             };
             this.setState({
               searchData: data
             });
             this.getTable(data);
            }}
          >
            搜索
          </Button>
          <Button
            onClick={() => {
              this.setState({
                keyword: '',
                searchData: {
                  keyword: '',  //关键字
                  pageNumber: '1',  // 页	
                  pageSize: '10'  //条目
                }
              }, () => {
                this.getTable(this.state.searchData);
              });
            }}
            style={{
              padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
            }}
          >
            重置
          </Button>
        </div>
        <div className="receive-list">
          <div className="receive-row">
            <Button type="primary" 
                onClick={() => {
                  const { selectedRows } = this.state;
                  if(selectedRows.length > 0) {
                    let batchData ={
                      isCheckAll: 0  // isCheckAll 是否批量选中（1:是 0:否）
                    }
                    batchData.perIds = selectedRows.reduce((a, b) => {
                      return a+ ','+b.perId;
                    }, '').slice(1);
                    Modal.info({
                      title: '批量提醒',
                      okText: '确定',
                      cancelText: '取消',
                      maskClosable: true,
                    content: <p className="modal_tip left0">确定批量提醒选中人员({`${selectedRows.length}人`})？</p>,
                      onOk() {
                        ajax.batchNotice(batchData).then(res => {
                          // THIS.getTable(THIS.state.searchData);
                        });
                      },
                      onCancel() {}
                    });
                  }else {
                    notification.success({
                      message: '请选择人员'
                    });
                  }
                }}
              >
                提醒选中人员开通
            </Button>
            <Button type="primary" style={{marginLeft: 15}}
                onClick={() => {
                  let batchData ={
                    isCheckAll: 1  // isCheckAll 是否批量选中（1:是 0:否）
                  };
                  // $modal(
                  //   '批量提醒',
                  //   <p className="modal_tip left0">确定批量提醒所有人？</p>,
                  //   [
                  //     {
                  //       text: '取消'
                  //     },
                  //     {
                  //       text: '确定',
                  //       type: 'primary',
                  //       onPress: () => {
                  //         ajax.batchNotice(batchData).then(res => {
                  //           // THIS.getTable(THIS.state.searchData);
                  //         })
                  //       }
                  //     },
                  //   ],
                  //   'info'
                  // );
                  Modal.info({
                    title: '批量提醒',
                    okText: '确定',
                    cancelText: '取消',
                    maskClosable: true,
                    content: <p className="modal_tip left0">确定批量提醒所有人？</p>,
                    onOk() {
                      ajax.batchNotice(batchData).then(res => {
                        // THIS.getTable(THIS.state.searchData);
                      })
                    }
                  });
                }}
              >
                提醒所有人员开通
            </Button>
          </div>
        </div>
        {this.renderOrderList()}
      </div>
    );
  }
}
