import React from 'react';
import { connect } from 'dva';
import StepOne from './StepOne';
import StepTwo from './StepTwo';
import StepThree from './StepThree';
import StepFour from './StepFour';
import StepFive from './StepFive';
import '../financialWallet.less';
import {
  getComWalletServiceOpenInfo,
  getComWalletCurrentProcess
}from '../../../services/api';
@connect(state => ({
  global: state.global
}))
export default class BusinessWallet extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      initStatus: 0,  //初始化没有页面
      // initStatus: 1,
      isAuthorize: 0,  //是否授权服务（1：是，0：否） 
      isCompleteOpen: 0 //是否完成开户（1：是，0：否）
    };
  }
  componentDidMount() {
    const companyInfo = this.props.global.companyInfo;
    //将数据存在storage中，防止刷新的时候数据丢失的现象
    if(companyInfo.comName) {
      window.sessionStorage.setItem('companyInfo', JSON.stringify(this.props.global.companyInfo));  
    }
    // 获取企业钱包服务开通情况
    this.__getComWalletServiceOpenInfo();
  }
  // 获取企业钱包服务开通情况
  __getComWalletServiceOpenInfo() {
    getComWalletServiceOpenInfo().then(res => {
      const { isAuthorize, isCompleteOpen } = res.data;
      // 已经授权
      if(isAuthorize == 1) {
        // 未完成开户的时候 获取步骤
        if(isCompleteOpen == 0) {
          // this.__getComWalletCurrentProcess();
          this.setState({
            initStatus: 2
          });
        }else {  // 完成开户
          this.setState({
            initStatus: 5
          });
        }
      }else {
        this.setState({
          initStatus: 1
        });
      }
      this.setState({
        isAuthorize,
        isCompleteOpen
      });
    }).catch(() => {
      this.setState({
        initStatus: 1
      });
    });
  }
  // __getComWalletCurrentProcess() {
  //   getComWalletCurrentProcess().then(res => {
  //     let step = res.data.step + 1;
  //     // 完成了
  //     if(step >= 4) {
  //       this.setState({
  //         initStatus: 5
  //       });
  //       // 还在第一步的时候
  //     }else if(step <=2) {
  //       this.setState({
  //         initStatus: 1
  //       });
  //       // 未完成
  //     }else {
  //       this.setState({
  //         initStatus: step
  //       });
  //     }
  //   });
  // }
  setStatus(value) {
    this.setState({
      initStatus: value
    });
  }
  render() {
    const status = this.state.initStatus;
    // const status = 2;
    return (
       <div className="financial_container">
         {status == 1 && <StepOne setStatus={this.setStatus.bind(this)} isAuthorize={this.state.isAuthorize}></StepOne>}
         {status == 2 && <StepTwo setStatus={this.setStatus.bind(this)}></StepTwo>}
         {/* {status == 3 && <StepThree setStatus={this.setStatus.bind(this)}></StepThree>} */}
         {status == 4 && <StepFour setStatus={this.setStatus.bind(this)}></StepFour>}
         {status == 5 && <StepFive></StepFive>}
       </div>
    );
  }
}