import React from 'react';
import moment from 'moment';
import { Form, Select, Input, Button, Row, Col, notification, DatePicker, Table } from 'antd';
import { formItemLayout, formLayout } from '../../../constants/formItemLayout';
import PSelect from '../../../components/Pro/PSelect';
import { getCompanyShareHolder, publicCommonDictGetDictByCodeTypes } from '../../../services/api';

const { RangePicker } = DatePicker;
// const warnColor = '#F59A23';
// const okColor = '#4B7902';
const errColor = '#D9001B';
const dateFormat = 'YYYY-MM-DD';
// const code = {
//   1: '0',
//   2: '5',
//   3: '6',
//   4: '7',
//   5: '7',
//   6: ' 9',
//   8: ' 12',
// }
@Form.create()
export default class BusinessWallet extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      shareholders: [],
      beneficiarys: []
    };
  }
  componentWillMount() {
    this.props.getAddFun((cb) => {
      const { shareholders, beneficiarys } = this.state;
      this.props.form.validateFields((err) => {
        cb && cb(err, { shareholders, beneficiarys });
      });
    });
  }
  componentDidMount() {
    // this.__getCompanyShareHolder()
  }
  // //获取股东列表信息
  // __getCompanyShareHolder() {
  //   getCompanyShareHolder({ pageSize: "10", pageNumber: "1" }).then(result => {
  //     if (result.data.data.length > 0) {
  //       let shareholders = result.data.data.filter(item => {
  //         return item.idCardType
  //       }).map((list, index) => {
  //         console.log(code[list.idCardType])
  //         return {
  //           cerNo: list.cerNo,
  //           name: list.name,
  //           cerType: code[list.idCardType],
  //           key: index,
  //           endDate: "",
  //           startDate: "",
  //         }
  //       })
  //       this.setState({
  //         shareholders
  //       })
  //     }
  //   });
  // }

  // componentWillReceiveProps(props) {

  // }
  _addItem = type => {
    const { shareholders, beneficiarys } = this.state;
    switch (true) {
      case type === 's':
        // shareholders.push(item);
        this.setState({
          shareholders: [
            ...shareholders,
            {
              "cerNo": "",
              "endDate": "",
              "name": "",
              "cerType": "0",
              "startDate": "",
              key: moment().valueOf()
            }
          ]
        });
        break;
      case type === 'b':
        // beneficiarys.push(item);
        this.setState({
          beneficiarys: [
            ...beneficiarys,
            {
              "contractPhone": "",
              "cerNo": "",
              "endDate": "",
              "name": "",
              "contractAddress": "",
              "cerType": "0",
              "startDate": "",
              key: moment().valueOf()
            }
          ]
        });
        break;
    }
  }
  // _get
  _deleteItem = (type, index) => {
    const { shareholders, beneficiarys } = this.state;
    switch (true) {
      case type === 's':
        shareholders.splice(index, 1);
        this.setState({
          shareholders
        });
        break;
      case type === 'b':
        beneficiarys.splice(index, 1);
        this.setState({
          beneficiarys
        });
        break;
    }
  }
  render() {
    const { shareholders, beneficiarys } = this.state;
    const { getFieldDecorator } = this.props.form;
    // 股东信息
    const shareholdersColumns = [
      {
        title: '股东名称',
        dataIndex: 'name',
        key: 'name',
        // width: 120,
        // fixed: 'left',
        render: (text, record, index) => {
          return (
            <Form.Item>
              {getFieldDecorator('name' + '-' + index + '-s', {
                initialValue: text,
                rules: [
                  {
                    required: true,
                    message: '请输入股东名称'
                  },
                  {
                    validator: (rule, value, callback) => {
                      if (value && !/^\S{0,50}$/.test(value)) {
                        callback('请输入正确的股东名称');
                      } else {
                        callback();
                      }
                    }
                  }
                ]
              })(
                <Input maxLength={50} type="text" style={{ minWidth: 110 }} onChange={(e) => {
                  shareholders[index].name = e.target.value;
                  this.setState({
                    shareholders
                  });
                }} placeholder="输入股东名称" />
              )}
            </Form.Item>
          );
        }
      },
      {
        title: '证件类型',
        dataIndex: 'cerType',
        key: 'cerType',
        render: (text, record, index) => {
          return (
            <Form.Item>
              {
                getFieldDecorator('cerType' + '-' + index + '-s', {
                  // initialValue: '1',
                  initialValue: shareholders[index].cerType,
                  rules: [
                    {
                      required: true,
                      message: '请选择证件类型'
                    },
                  ]
                })(
                  // <PSelect
                  //   style={{ minWidth: 120 }}
                  //   type="idCardType_bak"
                  //   placeholder="请选择证件类型"
                  //   // disabled
                  //   onChange={(value) => {
                  //     shareholders[index].cerType = value;
                  //     this.setState({
                  //       shareholders
                  //     });
                  //   }}
                  // />
                  // 暂时支持统一信用代码
                  <Select style={{ minWidth: 120 }}  onChange={(value) => {
                    shareholders[index].cerType = value;
                    this.setState({
                      shareholders
                    });
                  }}>
                    <Option value="0">居民身份证（户口簿）</Option>
                    <Option value="252">统一信用代码</Option>
                  </Select>
                )
              }
            </Form.Item>
          );
        }
      },
      {
        title: '证件号码',
        dataIndex: 'cerNo',
        key: 'cerNo',
        render: (text, record, index) => {
          return (
            <Form.Item>
              {getFieldDecorator('cerNo' + '-' + index + '-s', {
                initialValue: text,
                rules: [
                  {
                    required: true,
                    message: '请输入证件号码'
                  },
                  // {
                  //   pattern:
                  //     record.idCardType === '1'
                  //       ? /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/
                  //       : null,
                  //   message: '证件格式错误'
                  // }
                ]
              })(
                <Input maxLength={50} type="text" style={{ minWidth: 110 }} onChange={(e) => {
                  shareholders[index].cerNo = e.target.value;
                  this.setState({
                    shareholders
                  });
                }} placeholder="输入证件号码" />
              )}
            </Form.Item>
          );
        }
      },
      {
        title: '证件有效期',
        dataIndex: 'date',
        key: 'date',
        render: (text, record, index) => {
          return (
            <Form.Item>
              {getFieldDecorator('date' + '-' + index + '-s', {
                initialValue: [],
                rules: [
                  {
                    required: true,
                    message: '请选择证件有效期'
                  }
                ]
              })(
                <RangePicker
                  style={{ minWidth: 120 }}
                  format={dateFormat}
                  disabledDate={current => {
                    return current > moment('2100/1/1');
                  }}
                  onChange={(date, strs) => {
                    shareholders[index].startDate = strs[0];
                    shareholders[index].endDate = strs[1];
                    this.setState({
                      shareholders
                    });
                  }}
                />
              )}
            </Form.Item>
          );
        }
      },
      {
        title: '操作',
        dataIndex: 'operation',
        key: 'operation',
        width: 100,
        fixed: 'right',
        render: (text, record, index) => {
          return (
            <div style={{ paddingBottom: 20 }}>
              <a style={{ color: errColor }} onClick={() => {
                this._deleteItem('s', index);
              }}>删除</a>
            </div>
          );
        }
      }
    ];
    // 受益人信息
    const beneficiarysColumns = [
      {
        title: '受益人名称',
        dataIndex: 'name',
        key: 'name',
        width: 120,
        fixed: 'left',
        render: (text, record, index) => {
          return (
            <Form.Item>
              {getFieldDecorator('name' + '-' + index + '-b', {
                initialValue: text,
                rules: [
                  {
                    required: true,
                    message: '请输入受益人名称'
                  },
                  {
                    validator: (rule, value, callback) => {
                      if (value && !/^\S{0,50}$/.test(value)) {
                        callback('请输入正确的受益人名称');
                      } else {
                        callback();
                      }
                    }
                  }
                ]
              })(
                <Input maxLength={50} type="text" style={{ minWidth: 110 }} onChange={(e) => {
                  beneficiarys[index].name = e.target.value;
                  this.setState({
                    beneficiarys
                  });
                }} placeholder="输入股东名称" />
              )}
            </Form.Item>
          );
        }
      },
      {
        title: '证件类型',
        dataIndex: 'cerType',
        key: 'cerType',
        render: (text, record, index) => {
          return (
            <Form.Item>
              {
                getFieldDecorator('cerType' + '-' + index + '-b', {
                  initialValue: '1',
                  rules: [
                    {
                      required: true,
                      message: '请选择证件类型'
                    },
                  ]
                })(
                  <PSelect
                    style={{ minWidth: 120 }}
                    type="idCardType_bak"
                    placeholder="请选择证件类型"
                    disabled
                    onChange={(value) => {
                      beneficiarys[index].cerType = value;
                      this.setState({
                        beneficiarys
                      });
                    }}
                  />
                )
              }
            </Form.Item>
          );
        }
      },
      {
        title: '证件号码',
        dataIndex: 'cerNo',
        key: 'cerNo',
        render: (text, record, index) => {
          return (
            <Form.Item>
              {getFieldDecorator('cerNo' + '-' + index + '-b', {
                initialValue: text,
                rules: [
                  {
                    required: true,
                    message: '请输入证件号码'
                  },
                  // {
                  //   pattern:
                  //     record.idCardType === '1'
                  //       ? /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/
                  //       : null,
                  //   message: '证件格式错误'
                  // }
                ]
              })(
                <Input maxLength={50} type="text" style={{ minWidth: 110 }} onChange={(e) => {
                  beneficiarys[index].cerNo = e.target.value;
                  this.setState({
                    beneficiarys
                  });
                }} placeholder="输入证件号码" />
              )}
            </Form.Item>
          );
        }
      },
      {
        title: '证件有效期',
        dataIndex: 'date',
        key: 'date',
        render: (text, record, index) => {
          return (
            <Form.Item>
              {getFieldDecorator('date' + '-' + index + '-b', {
                initialValue: [],
                rules: [
                  {
                    required: true,
                    message: '请选择证件有效期'
                  }
                ]
              })(
                <RangePicker
                  style={{ minWidth: 120 }}
                  format={dateFormat}
                  disabledDate={current => {
                    return current > moment('2100/1/1');
                  }}
                  onChange={(date, strs) => {
                    beneficiarys[index].startDate = strs[0];
                    beneficiarys[index].endDate = strs[1];
                    this.setState({
                      beneficiarys
                    });
                  }}
                />
              )}
            </Form.Item>
          );
        }
      },
      {
        title: '联系电话',
        dataIndex: 'contractPhone',
        key: 'contractPhone',
        render: (text, record, index) => {
          return (
            <Form.Item>
              {getFieldDecorator('contractPhone' + '-' + index + '-b', {
                initialValue: text,
                rules: [
                  {
                    required: true,
                    message: '请输入联系电话'
                  }
                ]
              })(
                <Input maxLength={20} type="text" style={{ minWidth: 100 }} onChange={(e) => {
                  beneficiarys[index].contractPhone = e.target.value;
                  this.setState({
                    beneficiarys
                  });
                }} placeholder="输入联系电话" />
              )}
            </Form.Item>
          );
        }
      },
      {
        title: '联系地址',
        dataIndex: 'contractAddress',
        key: 'contractAddress',
        render: (text, record, index) => {
          return (
            <Form.Item>
              {getFieldDecorator('contractAddress' + '-' + index + '-b', {
                initialValue: text,
                rules: [
                  {
                    // required: true,
                    message: '请输入联系地址'
                  }
                ]
              })(
                <Input maxLength={20} type="text" style={{ minWidth: 100 }} onChange={(e) => {
                  beneficiarys[index].contractAddress = e.target.value;
                  this.setState({
                    beneficiarys
                  });
                }} placeholder="输入联系地址" />
              )}
            </Form.Item>
          );
        }
      },
      {
        title: '操作',
        dataIndex: 'operation',
        key: 'operation',
        width: 100,
        fixed: 'right',
        render: (text, record, index) => {
          return (
            <div style={{ paddingBottom: 20 }}>
              <a style={{ color: errColor }} onClick={() => {
                this._deleteItem('b', index);
              }}>删除</a>
            </div>
          );
        }
      }
    ];
    return (
      <Row gutter={16}>
        <Col span={20}>
          <Form.Item {...formLayout} label={<span><i style={{ color: errColor }}>*</i>股东信息:</span>}>
            <Table dataSource={shareholders} columns={shareholdersColumns} pagination={false} scroll={{ x: '1200px' }} />
            <a onClick={() => {
              this._addItem('s');
            }}>+添加一条记录</a>
          </Form.Item>
        </Col>
        <Col span={20}>
          <Form.Item {...formLayout} label=' ' colon={false}>
            <div style={{ lineHeight: '18px', color: '#FFAA00', marginBottom: '-20px' }}>
              注：若无股东，则填写本企业信息；最多录入5跳记录即可；若为永久证件，到期日期请选择2099-12-31。
            </div>
          </Form.Item>
        </Col>
        <Col span={20}>
          <Form.Item {...formLayout} label={<span><i style={{ color: errColor }}>*</i>受益人信息:</span>}>
            <Table dataSource={beneficiarys} columns={beneficiarysColumns} pagination={false} scroll={{ x: '1500px' }} />
            <a onClick={() => {
              this._addItem('b');
            }}>+添加一条记录</a>
          </Form.Item>
        </Col>
        <Col span={20}>
          <Form.Item {...formLayout} label=' ' colon={false}>
            <div style={{ lineHeight: '18px', color: '#FFAA00', marginBottom: '-20px' }}>
              注：最多录入5条记录即可；若为永久证件，到期日期请选择2099-12-31。
            </div>
          </Form.Item>
        </Col>
      </Row>
    );
  }
}
