import React, { Component } from "react";
import moment from 'moment';
import "moment/locale/zh-cn";
import {
  DatePicker,
  Button,
  Table
} from 'antd';
const { RangePicker } = DatePicker;
import BudgetDrawer from './BudgetDrawer';
import { 
  getComWalletAccountTradeDetail
} from '../../../../services/api';
export default class StepFive extends Component {
  constructor(props, context) {
    super(props, context);
    this.state={
      tableList:[],
      searchData: {  // 表格数据请求参数
        startDate: moment().subtract(30, 'days').format('YYYY-MM-DD'),
        endDate: moment().format('YYYY-MM-DD'),
        pageNumber: '1',  // 页	
        pageSize: '10'  //条目
      },
      rangePickeValue: [moment().subtract(30, 'days'), moment()],
      // walletAccountNo: props.walletAccountNo,
      // walletAccountNo: '3008001002356511000010',
      pagination: {  //分页数据
        total: 1,
        current: 1,
        pageSize: 10,
        showSizeChanger: true,
        showQuickJumper: true
      },
      // 详情抽屉
      detailInfo: null, //当前的详情信息
    };
  }
  componentDidMount() {
    // // test start
    // this.setState({
    //   tableList: [{
    //     "serviceType": "通用下账",
    //     "amount": "10.00",
    //     "accounts_deal_date": "2019-06-27 17:03:03",
    //     "flow_no": "01328943255678636117",
    //     "account_in": "",
    //     "memo": "",
    //     "trade_flow_no": "M0128946956654248027",
    //     "trade_date": "2019-06-27 17:17:46",
    //     "balance": "1602.00",
    //     "hand_status": "成功",
    //     "trade_type": "消费",
    //     "account_out": "3008001002356511000010",
    //     "create_date": "2019-06-27 17:17:46",
    //     "direction": "出账"
    //   }]
    // });
    // //test end
    this.__getTable();
  }
  componentWillReceiveProps(props) {
    if(!!props.walletAccountNo) {
      this.__getTable();
    }
  }

  // 获取表格信息
  __getTable = () => {
    let { searchData } = this.state;
    const { walletAccountNo } = this.props;
    if(!walletAccountNo) return;
    searchData = {
      ...searchData,
      walletAccountNo
    }
    getComWalletAccountTradeDetail(searchData).then(res => {
      this.setState({
        tableList: res.data.data,
        pagination: {
          ...this.state.pagination,
          total: res.data.total,
          current: res.data.pageNumber,
          pageSize: res.data.pageSize
        }
      });
    });
  }
  render() {
    const columns = [
      {
        title: '交易时间',
        dataIndex: 'tradeDate',
        key: 'tradeDate',
      },
      {
        title: '交易流水号',
        dataIndex: 'tradeFlowNo',
        key: 'tradeFlowNo'
      },
      {
        title: '财务流水号',
        dataIndex: 'flowNo',
        key: 'flowNo'
      },
      // {
      //   title: '财务处理时间',
      //   dataIndex: 'accounts_deal_date',
      //   key: 'accounts_deal_date'
      // },
      {
        title: '交易金额',
        dataIndex: 'amount',
        key: 'amount'
      },
      {
        title: '交易后余额',
        dataIndex: 'balance',
        key: 'balance'
      },
      {
        title: '资金流向',
        dataIndex: 'direction',
        key: 'direction'
      },
      {
        title: '交易类型',
        dataIndex: 'tradeType',
        key: 'tradeType'
      },
      {
        title: '处理状态',
        dataIndex: 'handStatus',
        key: 'handStatus'
      },
      {
        title: '订单创建时间',
        dataIndex: 'createDate',
        key: 'createDate'
      },
      // {
      //   title: '服务编码',
      //   dataIndex: '',
      //   key: ''
      // },
      
      // {
      //   title: '入账方账户',
      //   dataIndex: 'account_in',
      //   key: 'account_in'
      // },
      // {
      //   title: '出账方账户',
      //   dataIndex: 'account_out',
      //   key: 'account_out'
      // },
      {
        title: '备注',
        dataIndex: 'memo',
        key: 'memo',
      },
      {
        title: '操作',
        dataIndex: 'operation',
        key: 'operation',
        fixed: 'right',
        width: 100,
        render: (text, record) => (
          <div>
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
                marginRight: '20px'
              }}
              onClick={() => {
                this.setState({
                  detailInfo: record
                });
              }}
            >
              详情
            </span>
          </div>
        )
      }
    ];
    return (
      <div>
        <label style={{ marginRight: '16px', display: 'inline-block' }}>
          交易时间：
          <RangePicker
            format='YYYY-MM-DD'
            value={this.state.rangePickeValue}
            onChange={(date, dateString) => {
              this.setState({
                rangePickeValue: date,
                searchData: {
                  ...this.state.searchData,
                  startDate: dateString[0],
                  endDate: dateString[1]
                }
              });
            }}
            style={{ marginBottom: '10px' }}
          />
        </label>
        <Button
            style={{
              marginRight: '16px',
              marginBottom: '16px',
              padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
            }}
            type="primary"
            onClick={() => {
              this.__getTable();
            }}
          >
            搜索
        </Button>
        <Button
            style={{
              marginRight: '16px',
              marginBottom: '16px',
              padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
            }}
            onClick={() => {
              this.setState({
                searchData: {  // 表格数据请求参数
                  startDate: moment().subtract(30, 'days').format('YYYY-MM-DD'),
                  endDate: moment().format('YYYY-MM-DD'),
                  pageNumber: '1',  // 页	
                  pageSize: '10'  //条目
                },
                rangePickeValue: [moment().subtract(30, 'days'), moment()]
              });
            }}
          >
            重置
        </Button>
        


        <Table
          dataSource={this.state.tableList}
          columns={columns}
          pagination={this.state.pagination}
          scroll={{ x: 1300 }}
          onChange={(pagination) => {
            const searchData =  {  // 搜索数据
              ...this.state.searchData,
              pageNumber: pagination.current,  // 页	
              pageSize: pagination.pageSize
            };
            this.setState({
              searchData
            },() => {
              this.__getTable();
            });       
          }}
        />

        <BudgetDrawer
          info={this.state.detailInfo}
          onClose={() => {
            this.setState({
              detailInfo: null
            });
          }}
        />
      </div>
    );
  }
}
