import React, { Component } from 'react';
import { connect } from 'dva';
import { Form, Steps,} from 'antd';
import './ExaminationApproval.less';

const { Step } = Steps;
/* 组件库 */
const zjg = [
    { name: "单行输入框", id: "singleLineInput" },
    { name: "多行输入框", id: "multiLineInput" },
    { name: "数字输入框", id: "numberinput" },
    { name: "单选框", id: "radio" },
    { name: "多选框", id: "checkbox" },
    { name: "日期", id: "DatePicker" },
    { name: "日期区间", id: "RangePicker" },
    { name: "图片", id: "image" },
    { name: "添加明细", id: "adddetail" },
    { name: "说明", id: "textDescription" },
    { name: "金额", id: "amountMoney" },
    { name: "上传附件", id: "enclosure" },
    { name: "外部联系人", id: "externalContacts" },
    { name: "联系人", id: "contacts" },
    { name: "地点定位", id: "locationLocation" },
    { name: "计算公式", id: "calculationFormula" },
];
/* 组件 */
// const zj = {
//     singleLineInput: [
//         {
//             fieldname: "标题",
//             fieldinfo: "最多10字",
//             filedblock: <Input value="单行输入" />,
//             fieldtips: ""
//         },
//         {
//             fieldname: "提示文字",
//             fieldinfo: "最多20字",
//             filedblock: <Input placehoder="请输入" />,
//             fieldtips: "内容最多可填写1000个字"
//         },
//         {
//             fieldname: "验证",
//             fieldinfo: "",
//             filedblock: <Checkbox>(必填)</Checkbox>,
//             fieldtips: ""
//         },
//         {
//             fieldname: "打印",
//             fieldinfo: "",
//             filedblock: <Checkbox>参与打印（如不勾选，打印时不显示该项）</Checkbox>,
//             fieldtips: ""
//         },
//     ],
// };

@connect(state => ({
    profile: state.profile,
}))

@Form.create()
export default class ExaminationApprovalManage extends Component {
    state = {
        expand: false,
    };

    componentDidMount() {
        // To disabled submit button at the beginning.
        this.props.form.validateFields();
    }
    handleSubmit = (e) => {
        e.preventDefault();
        this.props.form.validateFields((err, values) => {
            if (!err) {
                console.log('Received values of form: ', values);
            }
        });
    }

    toggle = () => {
        const { expand } = this.state;
        this.setState({ expand: !expand });
    }


    render() {
        // Only show error after a field is touched.
        return (
            <div size="middle" className="ExaminationApproval EditorialApproval">
                <Steps size="middle" current={0}>
                    <Step title="编辑审批内容" />
                    <Step title="设置审批流程" />
                    <Step title="设置多条件审批" />
                    <Step title="全局设置" />
                    <Step title="完成" />
                </Steps>
                <div className="EditorialApproval-box">
                    <div className="zug">
                        {zjg.map((val, index) => {
                            return <div className="item" key={index}>{val.name}</div>;
                        })}
                    </div>
                    <div className="gjsz">
                        <div>控件设置</div>
                        <div className="gjsz-content"/>
                    </div>
                </div>
            </div>
        );
    }
}
