import React, { PureComponent } from 'react';
import { Tabs, Table, Modal, message, Popover } from 'antd';
import style from 'styled-components';
import { connect } from 'dva';

import './ApprovalTypeManage.less';

const { TabPane } = Tabs;
const { confirm } = Modal;

const namespace = 'approval';
const mapStateToProps = state => {
  return {
    comId: state.global.companyInfo.comId,
    approvalTypeList: state[namespace].approvalTypeList,
    total: state[namespace].total,
    current: state[namespace].current
  };
};

const mapDispatchToProps = dispatch => {
  return {
    getApprovalTypeList: payload => {
      dispatch({
        type: `${namespace}/getApprovalTypeList`,
        payload
      });
    },
    changeApprovalTempStatus: payload => {
      dispatch({
        type: `${namespace}/changeApprovalTempStatus`,
        payload
      });
    }
  };
};

@connect(
  mapStateToProps,
  mapDispatchToProps
)
export default class CoursewareLibraryManagement extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      comId: ''
    };
  }

  handleOperation = (text, record) => {
    console.log(record.status);
    if (record.status === text) {
      Modal.warning({
        title: `当前已经是${text}状态`,
        content: <span style={{ color: '#f00' }}>请勿重复设置！</span>
      });
      return;
    }
    switch (text) {
      case '设置':
        confirm({
          title: '您即将设置该审批类型',
          content: '是否确定？',
          cancelText: '取消',
          okText: '确认',
          onOk() {
            return new Promise((resolve, reject) => {
              setTimeout(Math.random() > 0.5 ? resolve : reject, 1000);
            })
              .then(() => message.success('This is a message of success'))
              .catch(() => console.log('Oops errors!'));
          },
          onCancel() {}
        });
        return;
      case '启用':
        confirm({
          title: '您即将启用该审批类型',
          content: '是否确定？',
          cancelText: '取消',
          okText: '确认',
          onOk: () => {
            this.props.changeApprovalTempStatus({
              approveTempId: record.key,
              isActive: '1'
            });
          },
          onCancel() {}
        });
        return;
      case '停用':
        confirm({
          title: '您即将停用该审批类型',
          content: '是否确定？',
          cancelText: '取消',
          okText: '确认',
          onOk: () => {
            this.props.changeApprovalTempStatus({
              approveTempId: record.key,
              isActive: '0'
            });
          },
          onCancel() {}
        });
        return;
      default:
        confirm({
          title: '您即将删除该审批类型',
          content: '是否确定？',
          cancelText: '取消',
          okText: '确认',
          onOk() {
            return new Promise((resolve, reject) => {
              setTimeout(Math.random() > 0.5 ? resolve : reject, 1000);
            })
              .then(() => message.success('This is a message of success'))
              .catch(() => console.log('Oops errors!'));
          },
          onCancel() {}
        });
    }
  };

  handlePage = (page, pageSize) => {
    this.props.getApprovalTypeList({
      comId: this.state.comId,
      pageSize,
      pageNumber: page
    });
  };

  handlePageSize = (current, size) => {
    this.props.getApprovalTypeList({
      comId: this.props.comId,
      pageSize: size,
      pageNumber: current
    });
  };

  componentDidMount() {
    if (this.props.comId) {
      this.props.getApprovalTypeList({
        comId: this.props.comId,
        pageSize: 10,
        pageNumber: this.props.current
      });
    }
  }

  componentWillReceiveProps(nextProps) {
    if (nextProps.comId && nextProps.comId !== this.state.comId) {
      this.props.getApprovalTypeList({
        comId: this.props.comId,
        pageSize: 10,
        pageNumber: this.props.current
      });
      this.setState({
        comId: nextProps.comId
      });
    }
  }

  render() {
    const dataSource = this.props.approvalTypeList.map(v => {
      const temp = {};
      temp.key = v.approveTempId;
      temp.icon = (
        <img
          src={v.logoUrl}
          alt=""
          style={{ width: '30px', borderRadius: '50%' }}
        />
      );
      temp.title = v.name;
      temp.instruction = v.approveRemark;
      temp.approvalgroup = v.approveGroupName;
      temp.status = Number(v.isActive) ? '启用' : '停用';
      // temp.operation = v.isFixedTemp ? ['停用', '启用'] : ['停用', '启用'];
      temp.operation = Number(v.isActive) ? ['停用'] : ['启用'];

      return temp;
    });

    const columns = [
      {
        title: '显示图标',
        dataIndex: 'icon',
        align: 'center',
        key: 'icon',
        render: text => (
          <div>
            <p
              style={{
                minWidth: '30px',
                height: '30px',
                maxWidth: '150px',
                whiteSpace: 'nowrap',
                textOverflow: 'ellipsis',
                overflow: 'hidden',
                marginTop: '0',
                marginBottom: '0'
              }}
            >
              {text}
            </p>
          </div>
        )
      },
      {
        title: '标题',
        dataIndex: 'title',
        key: 'title',
        render: text => (
          <div>
            <p
              style={{
                minWidth: '100px',
                maxWidth: '150px',
                whiteSpace: 'nowrap',
                textOverflow: 'ellipsis',
                overflow: 'hidden',
                marginTop: '8px',
                marginBottom: '8px'
              }}
            >
              {text}
            </p>
          </div>
        )
      },
      {
        title: '说明',
        dataIndex: 'instruction',
        key: 'instruction',
        render: text => (
          <Popover
            content={<span style={{ whiteSpace: 'normal', width: '300px', display: 'inline-block', padding: '10px' }}>{text}</span>}
            placement="rightTop"
          >
            <p
              style={{
                maxWidth: '300px',
                whiteSpace: 'nowrap',
                textOverflow: 'ellipsis',
                overflow: 'hidden',
                marginTop: '8px',
                marginBottom: '8px'
              }}
            >
              {text}
            </p>
          </Popover>
        )
      },
      {
        title: '审批组',
        dataIndex: 'approvalgroup',
        key: 'approvalgroup',
        render: text => (
          <div>
            <p
              style={{
                maxWidth: '100px',
                whiteSpace: 'nowrap',
                textOverflow: 'ellipsis',
                overflow: 'hidden',
                marginTop: '8px',
                marginBottom: '8px'
              }}
            >
              {text}
            </p>
          </div>
        )
      },
      {
        title: '状态',
        dataIndex: 'status',
        key: 'status',
        render: text => (
          <div>
            <p
              style={{
                maxWidth: '60px',
                whiteSpace: 'nowrap',
                textOverflow: 'ellipsis',
                overflow: 'hidden',
                marginTop: '8px',
                marginBottom: '8px',
                color: text === '启用' ? '#008000' : '#FF0000'
              }}
            >
              {text}
            </p>
          </div>
        )
      },
      {
        title: '操作',
        dataIndex: 'operation',
        key: 'operation',
        render: (text, record) => (
          <div>
            <p
              style={{
                maxWidth: '160px',
                whiteSpace: 'nowrap',
                textOverflow: 'ellipsis',
                overflow: 'hidden',
                marginTop: '8px',
                marginBottom: '8px'
              }}
            >
              {/* eslint-disable */}
              {text.map(v => (
                <span key={v}>
                  <a
                    href="javascript:;"
                    onClick={() => this.handleOperation(v, record)}
                  >
                    {v}
                  </a>
                  <i>&nbsp;</i>
                </span>
              ))}
              {/* eslint-enable */}
            </p>
          </div>
        )
      }
    ];

    return (
      <Container>
        <Tabs>
          <TabPane tab="审批类型管理" key="1" />
        </Tabs>
        <div>
          <Table
            dataSource={dataSource}
            columns={columns}
            pagination={{
              current: this.props.current,
              total: this.props.total,
              showSizeChanger: true,
              showQuickJumper: true,
              onChange: this.handlePage,
              onShowSizeChange: this.handlePageSize
            }}
          />
        </div>
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
`;
