import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import { withRouter } from 'dva/router';
import {
  Input,
  Button,
  Table,
  Select,
  Alert,
  DatePicker,
  notification,
  Modal,
  Popover
} from 'antd';
import store from 'store';

import tablePage from '../../../../utils/hoc/tablePage';
import columnFun from './columns';
import moment from 'moment';

const { RangePicker } = DatePicker;
const { Option } = Select;
const dateFormat = 'YYYY-MM-DD';
@connect(state => ({
  global: state.global
}))
@tablePage({ type: 'bkt' })
@withRouter
export default class Submitted extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      //抽屉
      drawerVisble: false,
      personApplyId: '',  //当前选中的id
    };
  }

  componentDidMount() {

  }

  checkAreaCode() {
    return this.state.dataListAreaCode && this.state.dataListAreaCode.indexOf('6106') == 0
  }
  // 表格渲染
  renderOrderList = () => {
    const columns = columnFun.call(this);

    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="qualify_checkChecked"
        // scroll={{ x: '2000px' }}
        dateChange={(data) => {
          this.setState({
            dataListAreaCode: data.userData ? data.userData.areaCode : ''
          })
        }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <div style={{ padding: '0 24px' }}>
        <SearchForm
          arrange={values => {
            // values
            const { date} = values;
            // 报名时间
            if (date.length == 2) {
              values.checkStartDate  = moment(date[0]).format(dateFormat);
              values.checkEndDate = moment(date[1]).format(dateFormat);
            } else {
              values.checkStartDate  = '';
              values.checkEndDate = '';
            }
            values.productTypeCode = 3
            Reflect.deleteProperty(values, 'date');
            return values;
          }}
        >
          <>
            <Form.Item label="关键字">
              {getFieldDecorator('keyword', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入姓名/身份证/手机号" />
              )}
            </Form.Item>
            <Form.Item label="抽查时间">
              {getFieldDecorator('date', {
                initialValue: []
              })(
                <RangePicker
                  format={dateFormat}
                />
              )}
            </Form.Item>
            <Form.Item label="抽查人员">
              {getFieldDecorator('checkPerName', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入抽查人员" />
              )}
            </Form.Item>
            <Form.Item label="报名公司名称">
              {getFieldDecorator('learnName', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入报名公司名称" />
              )}
            </Form.Item>
            <Form.Item label="所属培训机构">
              {getFieldDecorator('organName', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入所属培训机构" />
              )}
            </Form.Item>
            <Form.Item label="抽查结果">
              {getFieldDecorator('checkStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未审核</Option>
                  <Option value="1">合格</Option>
                  <Option value="2">不合格</Option>
                  <Option value="3">待复审</Option>
                </Select>
              )}
            </Form.Item>
          </>
        </SearchForm>
        {/* 表格 */}
        {this.renderOrderList()}

      </div >
    );
  }
}

const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;