import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import { withRouter } from 'dva/router';
import {
  Input,
  Button,
  Table,
  Select,
  Alert,
  DatePicker,
  notification,
  Modal,
  Popover
} from 'antd';
import store from 'store';

import tablePage from '../../../../utils/hoc/tablePage';
import columnFun from './columns';
import moment from 'moment';

const { RangePicker } = DatePicker;
const { Option } = Select;
const dateFormat = 'YYYY-MM-DD';
@connect(state => ({
  global: state.global
}))
@tablePage({ type: 'bkt' })
@withRouter
export default class Submitted extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      //抽屉
      drawerVisble: false,
      personApplyId: '',  //当前选中的id
    };
  }

  componentDidMount() {

  }

  checkAreaCode() {
    return this.state.dataListAreaCode && this.state.dataListAreaCode.indexOf('6106') == 0
  }
  // 表格渲染
  renderOrderList = () => {
    const columns = columnFun.call(this);

    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="qualify_checkReady"
        // scroll={{ x: '2000px' }}
        dateChange={(data) => {
          this.setState({
            dataListAreaCode: data.userData ? data.userData.areaCode : ''
          })
        }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <div style={{ padding: '0 24px' }}>
        <SearchForm
          arrange={values => {
            // values
            const { date} = values;
            // 报名时间
            if (date.length == 2) {
              values.applyStartDate = moment(date[0]).format(dateFormat);
              values.applyEndDate = moment(date[1]).format(dateFormat);
            } else {
              values.applyStartDate = '';
              values.applyEndDate = '';
            }
            values.productTypeCode = 1
            Reflect.deleteProperty(values, 'date');
            return values;
          }}
        >
          <>
            <Form.Item label="关键字">
              {getFieldDecorator('keyword', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入姓名/身份证" />
              )}
            </Form.Item>
            <Form.Item label="报名公司名称">
              {getFieldDecorator('learnName', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入报名公司名称" />
              )}
            </Form.Item>
            <Form.Item label="所属培训机构">
              {getFieldDecorator('organName', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入所属培训机构" />
              )}
            </Form.Item>
            <Form.Item label="报名时间">
              {getFieldDecorator('date', {
                initialValue: []
              })(
                <RangePicker
                  format={dateFormat}
                />
              )}
            </Form.Item>
            {/* <Form.Item label="申报状态">
              {getFieldDecorator('applyStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="0">申报中</Option>
                  <Option value="1">申报通过</Option>
                  <Option value="2">申报不通过</Option>
                </Select>
              )}
            </Form.Item> */}
          </>
        </SearchForm>
        <Btns>
          {/* <Popover content={<div style={{padding: 10}}>搜索后可导出结果</div>}> */}
          {/* <Button
            // disabled={!this.props.clicked}
            type="primary"
            onClick={() => {
              const { searchData } = this.props;
              let queryStr = '';
              Object.keys(searchData).forEach(key => {
                queryStr += `${key}=${searchData[key]}&`;
              });
              queryStr = '?' + queryStr.slice(0, -1);
              window.open('/bkt_api/train/qualify/apply/export/train/apply' + queryStr + '&sessionId=' + store.get('saas')['sessionId']);
            }}
          >
            导出数据 
            </Button> */}
          {/* </Popover> */}
        </Btns>
        {/* 表格 */}
        {this.renderOrderList()}

      </div >
    );
  }
}

const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;