import React, { PureComponent } from 'react';
// import { connect } from 'dva';
import style from 'styled-components';
import {
  Input,
  Button,
  Form,
  Select,
  // DatePicker,
  // InputNumber,
  // Radio,
  // Icon,
  message,
  Drawer
} from 'antd';
// import Drawer from "react-motion-drawer";
// import PSelect from "../../../components/Pro/PSelect";
// import * as api from "../../../services/api";

import {
  enterpriseRoleGroupUpdate,
  enterpriseRoleGroupDelete,
  searchOnlyGroup //角色组新增
} from '../../../services/api';

const FormItem = Form.Item;
const { Option } = Select;

message.config({
  top: 100,
  right: 5,
  duration: 2
});

// @connect(state => ({ profile: state.profile }))
@Form.create()

// 收到的简历备注
export default class UpdateRoleGroup extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      roleGroupId: this.props.roleGroupId, //当前ID
      open: this.props.visiable, //新增角色组
      roleGroupMessage: {
        roleGroupName: '',
        roleGroupId: ''
      }
    };
  }
  /******************************生命周期******************************/

  componentDidMount = () => {};
  componentWillReceiveProps(props) {
    this.setState({
      open: props.visiable,
      roleGroupId: props.roleGroupId
    });
    if (!!props.visiable) {
      if (
        props.roleGroupId !== this.state.roleGroupId ||
        this.state.open !== props.visiable
      ) {
        this.getEnterpriseRoleGroupGet(props.roleGroupId);
      }
    }
  }
  /******************************ajax请求******************************/

  /******************************相关事件******************************/
  //获得角色组List
  getEnterpriseRoleGroupGet = roleGroupId => {
    searchOnlyGroup({ roleGroupId }).then(
      data => {
        console.log('roleGrou`pMessage', data.data);
        if (data) {
          this.setState(
            {
              roleGroupMessage: data.data
            },
            () => {
              const { setFieldsValue } = this.props.form;
              setFieldsValue({
                roleGroupName: this.state.roleGroupMessage.roleGroupName
              });
            }
          );
        }
      },
      error => {
        message.error(error);
        console.log('错误信息-获取角色组信息：', error);
      }
    );
  };
  //表单提交
  handleUpdateRoleGroupSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        console.log('values', values);
        const obj = {
          roleGroupName: values.roleGroupName ? values.roleGroupName : '',
          roleGroupId: this.state.roleGroupId
        };
        console.log('obj', obj);
        enterpriseRoleGroupUpdate(obj).then(
          res => {
            if (res.retType === '0') {
              console.log('成功信息-保存角色组信息：', res);
              // message.success("保存成功！");
              this.setState(
                {
                  open: false
                },
                () => {
                  const { setFieldsValue } = this.props.form;
                  setFieldsValue({ roleGroupName: '' });
                }
              );
              this.props.refreshList();
              this.props.wedRoleSequence();
            }
          },
          error => {
            // message.error(error);
            console.log('错误信息-保存角色信息：', error);
          }
        );
      }
    });
  };
  //角色组删除
  handleDeleteRoleGroupSubmit = () => {
    enterpriseRoleGroupDelete({ roleGroupId: this.state.roleGroupId }).then(
      res => {
        console.log('删除角色组信息：', res);
        // message.info("删除角色组信息成功！");
        this.setState(
          {
            open: false
          },
          () => {
            const { setFieldsValue } = this.props.form;
            setFieldsValue({ roleGroupName: '' });
          }
        );
        this.props.refreshList();
        this.props.wedRoleSequence();
      },
      error => {
        console.log('删除角色组信息失败', error);
        // message.info("删除角色组信息失败！");
      }
    );
  };

  /******************************render******************************/

  render() {
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 7
        }
      },
      wrapperCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 12
        },
        md: {
          span: 10
        }
      }
    };
    const { getFieldDecorator } = this.props.form;

    return (
      <Box>
        <Drawer
          title='修改角色组'
          // overlayColor="rgba(0, 0, 0,0)"
          placement='right'
          visible={this.state.open}
          // noTouchClose
          width={600}
          // zIndex={999}
          // className="drawer-box"
          onChange={open => {
            this.props.onChange(open);
            this.setState({ open });
          }}
          onClose={() => this.setState({ open: false })}
          destroyOnClose
          style={{
            height: 'calc(100% - 55px)',
            overflow: 'auto',
            paddingBottom: 53
          }}
        >
          <div>
            {/* <div className="drawer-header">修改角色组</div> */}
            <div>
              <Form onSubmit={this.handleSaveRoleGroupSubmit}>
                <FormItem {...formItemLayout} label='角色组名称'>
                  {getFieldDecorator('roleGroupName', {
                    initialValue: this.state.roleGroupMessage.roleGroupName,
                    rules: [
                      {
                        required: true,
                        message: '角色组名称不能为空'
                      },
                      {
                        pattern: /^[A-Za-z0-9\u4e00-\u9fa5]{1,20}$/,
                        message: '请输入中文，英文，数字!'
                      }
                    ]
                  })(<Input placeholder='请输入角色组名称' maxLength={20} />)}
                </FormItem>
              </Form>
            </div>
            {/* <div className="drawer-footer"> */}
            <div
              style={{
                position: 'absolute',
                bottom: 0,
                width: '100%',
                borderTop: '1px solid #e8e8e8',
                padding: '10px 16px',
                textAlign: 'right',
                left: 0,
                background: '#fff',
                borderRadius: '0 0 4px 4px'
              }}
            >
              <Button
                onClick={() => {
                  this.setState({ open: false }, () => {
                    const { setFieldsValue } = this.props.form;
                    setFieldsValue({ roleGroupName: '' });
                  });
                }}
                style={{
                  marginRight: 8
                }}
              >
                取消
              </Button>
              <Button
                style={{
                  marginRight: 8
                }}
                type='danger'
                onClick={this.handleDeleteRoleGroupSubmit}
              >
                删除角色组
              </Button>
              <Button
                type='primary'
                htmlType='submit'
                onClick={this.handleUpdateRoleGroupSubmit}
              >
                保存角色组
              </Button>
            </div>
          </div>
        </Drawer>
      </Box>
    );
  }
}

/************************样式************************/

const Box = style.div`{
  .drawer-content{
    margin-top:28px;
  }
}`;
