import React, { PureComponent } from 'react';
// import { connect } from 'dva';
import style from 'styled-components';
import {
  Input,
  Button,
  Form,
  Select,
  // DatePicker,
  // InputNumber,
  // Radio,
  // Icon,
  Drawer,
  message
} from 'antd';
// import Drawer from "react-motion-drawer";
// import PSelect from "../../../components/Pro/PSelect";
// import * as api from "../../../services/api";

import {
  searchRoleGroup, //查询角色组与角色列表功能
  enterpriseRoleGet,
  enterpriseRoleUpdate,
  enterpriseRoleDeleteById
} from '../../../services/api';

const FormItem = Form.Item;
const { Option } = Select;

message.config({
  top: 100,
  right: 5,
  duration: 2
});

// @connect(state => ({ profile: state.profile }))
@Form.create()

// 收到的简历备注
export default class UpdateRole extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      visible: props.visiable, //备注
      roleId: this.props.roleId, //当前ID
      roleGroupList: [],
      roleMessage: {
        roleName: '',
        roleGroupId: ''
      }
    };
  }
  /******************************生命周期******************************/

  componentDidMount = () => {
    // this.getEnterpriseRoleGroupGet();
  };
  componentWillReceiveProps(props) {
    this.setState({ visible: props.visiable, roleId: props.roleId });
    if (!!props.visiable) {
      if (
        props.roleId !== this.state.roleId ||
        this.state.visible !== props.visiable
      ) {
        this.getEnterpriseRoleGet(props.roleId);
        this.getEnterpriseRoleGroupGet();
      }
    }
  }
  /******************************ajax请求******************************/

  /******************************相关事件******************************/
  //获得角色组List
  getEnterpriseRoleGroupGet = () => {
    // console.log("getComId:", comId);
    searchRoleGroup().then(data => {
      console.log('getRoleList', data.data);
      if (data) {
        this.setState({
          roleGroupList: data.data
        });
      }
    });
  };
  getEnterpriseRoleGet = propsRoleId => {
    // enterpriseRoleGet({ roleId: this.state.roleId }).then(data => {
    enterpriseRoleGet({ roleId: propsRoleId }).then(data => {
      console.log('getRoleId', data);
      if (data) {
        this.setState({
          roleMessage: data.data
        });
      }
    });
  };
  //角色删除
  handleDeleteRoleSubmit = () => {
    console.log('删除的RoleId:', this.state.roleId);
    enterpriseRoleDeleteById({ roleId: this.state.roleId }).then(
      res => {
        console.log('删除角色信息：', res);
        // message.info("删除角色信息成功！");
        this.props.onChange();
        this.props.refreshList();
        this.props.wedRoleSequence();
      },
      error => {
        console.log('删除角色信息失败', error);
        // message.info("删除角色信息失败！" + error);
      }
    );
  };

  //表单提交
  handleSaveRoleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        console.log('values', values);
        const obj = {
          roleId: this.state.roleId,
          roleName: values.roleName ? values.roleName : '',
          roleGroupId: values.roleGroupId ? values.roleGroupId : ''
        };
        console.log('obj', obj);
        enterpriseRoleUpdate(obj).then(
          res => {
            console.log('修改角色信息：', res);
            // message.info("修改角色信息成功！");
            this.props.onChange();
            this.props.refreshList();
            this.props.wedRoleSequence();
          },
          error => {
            console.log('修改角色信息失败', error);
            message.info('修改角色信息失败！' + error);
          }
        );
      }
    });
  };

  renderRoleGroup = () => {
    return this.state.roleGroupList.map((val, key) => {
      return (
        <Option key={key} value={val.roleGroupId + ''}>
          {val.roleGroupName}
        </Option>
      );
    });
  };
  /******************************render******************************/

  render() {
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 7
        }
      },
      wrapperCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 12
        },
        md: {
          span: 10
        }
      }
    };
    const { getFieldDecorator } = this.props.form;

    return (
      <Box>
        <Drawer
          title='修改角色'
          placement='right'
          // closable={false}
          visible={this.state.visible}
          destroyOnClose
          // maskClosable
          // overlayColor="rgba(0, 0, 0,0)"
          // right
          // open={this.state.open}
          // noTouchClose
          width={600}
          // zIndex={999}
          // className="drawer-box"
          onClose={() => {
            this.props.onChange();
          }}
          style={{
            height: 'calc(100% - 55px)',
            overflow: 'auto',
            paddingBottom: 53
          }}
        >
          <div>
            {/* <div className="drawer-header">修改角色</div> */}
            <div>
              <Form onSubmit={this.handleSaveRoleSubmit}>
                <FormItem {...formItemLayout} label='角色名称'>
                  {getFieldDecorator('roleName', {
                    initialValue: this.state.roleMessage.roleName,
                    rules: [
                      {
                        required: true,
                        message: '角色名称不能为空'
                      },
                      {
                        pattern: /^[A-Za-z0-9\u4e00-\u9fa5]{1,20}$/,
                        message: '请输入中文，英文，数字!'
                      }
                    ]
                  })(<Input placeholder='请输入角色名称' maxLength={20} />)}
                </FormItem>
                <FormItem {...formItemLayout} label='所属分组:'>
                  {getFieldDecorator('roleGroupId', {
                    initialValue: this.state.roleMessage.roleGroupId,
                    rules: [
                      {
                        required: true,
                        message: '请输入所属分组'
                      },
                      {
                        validator: this.checkPhone
                      }
                    ]
                  })(
                    <Select placeholder='请输入所属分组'>
                      {this.renderRoleGroup()}
                    </Select>
                  )}
                </FormItem>
              </Form>
            </div>
            <div
              style={{
                position: 'absolute',
                bottom: 0,
                width: '100%',
                borderTop: '1px solid #e8e8e8',
                padding: '10px 16px',
                textAlign: 'right',
                left: 0,
                background: '#fff',
                borderRadius: '0 0 4px 4px'
              }}
            >
              <Button
                // onClick={() => this.setState({ visible: false })}
                onClick={() => this.props.onChange()}
                style={{ marginRight: 8 }}
              >
                取消
              </Button>
              <Button
                type='danger'
                onClick={this.handleDeleteRoleSubmit}
                style={{
                  marginRight: 8
                }}
              >
                删除角色
              </Button>
              <Button
                type='primary'
                htmlType='submit'
                onClick={this.handleSaveRoleSubmit}
              >
                确认修改角色
              </Button>
            </div>
          </div>
        </Drawer>
      </Box>
    );
  }
}

/************************样式************************/

const Box = style.div`{
  .drawer-content{
    margin-top:28px;
  }
}`;
