import React, { Component } from 'react';
import { connect } from 'dva';
import { Button, Table, Modal, Icon, message } from 'antd';
import './less/report.less';
import DrawerAddShareloder from './AddShareholder';
import DrawerAddZiShareloder from './AddZiShareloder';
import PTable from "../../../components/Pro/PTable";
import InitializationStock from './InitializationStock';
import ChangeOwnership from './ChangeOwnership';
import ShareholderChangeLog from './ShareholderChangeLog';
import { getCompanyShareHolder, getCompanyValidShare, deleteShareholder } from "../../../services/api";

const confirm = Modal.confirm;
let idx1 = 1;
let idx2 = 1;

export default class Shareholder extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      initPage: 0,
      number: 1,
      forceUpdate: false,
      visible: false,
      openAddShareolder: false,//新增机构股东
      openAddZiShareolder: false,//新增自然人股东
      addShareolderId: 0,//新增机构股东id
      addZiShareolderId: 0,//新增自然人股东id
      holderInitVisible: true, //默认显示股权初始化按钮
      holderSize: 0,//股东人数
      pageParm: {
        // comId: "1",
        pageSize: "10",
        pageNumber: "1"
      },
      initializationStockVisible: false,
      changeOwnershipVisible: false,
      shareholderChangelogVisible: false,
    };
  }

  //页面渲染后，执行方法
  componentDidMount() {
  }

  //table 数据变化
  validShareDateTableChange = (data) => {
    this.setState({ number: data.total });
    if (data.total > 0) {
      this.setState({ holderInitVisible: false });
    }
  };

  validShareList = () => {
    const columns = [
      {
        title: '股东',
        key: 'name',
        dataIndex: 'name',
      },
      {
        title: '证件号',
        dataIndex: 'cerNo',
        key: 'cerNo',
      },
      {
        title: '出资额(元)',
        key: 'contributionAmount',
        dataIndex: 'contributionAmount',
        render: (text, record) => {
          const value = `${text}`.replace(/\B(?=(\d{3})+(?!\d))/g, ',');
          return (
            <div>
              {value}
            </div>
          );
        }
      },
      // {
      //   title: '出资方式',
      //   key: 'contributionModeStr',
      //   dataIndex: 'contributionModeStr',
      // },
      {
        title: '所占比例',
        key: 'contributionPropStr',
        dataIndex: 'contributionPropStr',
      },
    ];
    return (
      <PTable
        columns={columns}
        url="getCompanyValidShare"
        pageParm={this.state.pageParm}
        dateChange={this.validShareDateTableChange}
        forceUpdate={this.state.forceUpdate}
        style={{ marginTop: '16px' }}
      />
    );

  };

  //删除
  showDeleteConfirm = (id) => {
    confirm({
      title: '是否删除所选信息，删除后无法找回。是否确认删除？',
      okText: '确认',
      cancelText: '取消',
      onOk: () => {
        // 报表删除
        deleteShareholder({ "shareholderId": id }).then((data) => {
          console.log(data);
          this.changePersonState();
        }, (err) => {
          console.log(err);
        });
      },
      onCancel() {
        console.log('Cancel');
      },
    });
  };


  //新增股东和新增自然人股东刷新列表
  changePersonState = () => {
    this.setState({
      forceUpdate: true,
    }, () => {
      this.setState({
        forceUpdate: false,
      })
    });
  };


  stockholderDateTableChange = (data) => {
    this.setState({ number: data.total });
    if (data.total > 0) {
      this.setState({ holderSize: data.total });
    }
  };

  stockholderList = () => {
    const columns = [
      {
        title: '名称/姓名',
        key: 'name',
        dataIndex: 'name',
      },
      {
        title: '类型',
        dataIndex: 'shareholderTypeStr',
        key: 'shareholderTypeStr',
      },
      {
        title: '证件类型',
        key: 'cardTypeStr',
        dataIndex: 'cardTypeStr',
      },
      {
        title: '证件号',
        key: 'cerNo',
        dataIndex: 'cerNo',
      },
      {
        title: '地址',
        key: 'a',
        dataIndex: 'a',
        width: 220,
        render: (text, record) => (
          <p style={{
            "overflow": "hidden",
            "textOverflow": "ellipsis",
            "whiteSpace": "nowrap",
            "width": "180px"
          }}>
            {record.address}
          </p>
        )
      },
      {
        title: '操作',
        key: '5',
        dataIndex: '5',
        render: (text, record) => (
          <div>
            <span
              key={text}
              style={{ color: "#0F71FF", cursor: "pointer", marginRight: "20px" }}
              onClick={this.showShareloder.bind(this, record.shareholderType, record.shareholderId)}
            >修改</span>
            <span style={{ color: "#0F71FF", cursor: "pointer" }}
              onClick={this.showDeleteConfirm.bind(this, record.shareholderId)}>删除</span>
          </div>
        )
      },
    ];
    return (
      <PTable
        columns={columns}
        url="getCompanyShareHolder"
        pageParm={this.state.pageParm}
        dateChange={this.stockholderDateTableChange}
        forceUpdate={this.state.forceUpdate}
        style={{ marginTop: '16px' }}
      />
    );
  };

  showShareloder = (type, id) => {
    // alert('type:'+type+'id:'+id); shareholderChangelogVisible
    if (type === "2") {
      this.setState({
        addShareolderId: id,
        openAddShareolder: true,
        idx2: ++idx2,
        init: 0,
      }, () => {
        // this.setState({  });
      });
    } else if (type === "1") {
      this.setState({
        addZiShareolderId: id,
        openAddZiShareolder: true,
        idx1: ++idx1,
        init: 0,
      }, () => {
        // this.setState({  });
      });
    }
    console.log(this.state);
  };

  handleCancel = (e) => {
    console.log(e);
    this.setState({
      visible: false,
    });
  };
  handleEquity = () => {
    // if (this.state.holderSize === 0) {
    //   message.info("请先添加股东");
    // } else {
    //   this.setState({
    //     visible: true,
    //   });
    //   this.props.props.history.push(`/enterprise/reported/initializationstock`);
    // }
    if (this.state.holderSize === 0) {
      this.setState({
        visible: true,
      });
    } else {
      this.setState({
        initializationStockVisible: true,
      });
    }
  };

  //抽屉视图处理
  changeDrawer = (openAddShareolder) => {
    this.setState({
      visible: false,
      openAddShareolder: true,
      addShareolderId: 0,
      init: 0,
    });
  };
  changeDrawerTwo = (openAddZiShareolder) => {
    this.setState({
      visible: false,
      openAddZiShareolder: true,
      addZiShareolderId: 0,
      init: 0,
    });
  };

  //是否显示
  isTrueXian = () => {
    let display;
    if (this.state.initializationStockVisible || this.state.changeOwnershipVisible || this.state.shareholderChangelogVisible) {
      return display = { display: 'none' };
    } else {
      return display = { display: 'block' };
    }
    if (this.state.changeOwnershipVisible) {
      this.setState({
        changeOwnershipVisible: true,
      })
    } else {
      this.setState({
        changeOwnershipVisible: false,
      })
    }
    if (this.state.shareholderChangelogVisible) {
      this.setState({
        shareholderChangelogVisible: true,
      })
    } else {
      this.setState({
        shareholderChangelogVisible: false,
      })
    }
    if (this.state.InitializationStockVisible) {
      this.setState({
        initializationStockVisible: true,
      })
    } else {
      this.setState({
        initializationStockVisible: false,
      })
    }
  };

  callbackOne = () => {
    this.setState({ initializationStockVisible: false });
    this.setState({ changeOwnershipVisible: false });
    // this.ajaxInsPage();
    this.setState({ forceUpdate: true }, () => {
      this.setState({
        forceUpdate: false
      })
    });
  };

  // callbackTwo = () =>{
  //   this.setState({shareholderChangelogVisible:false});
  //   // this.ajaxInsPage();
  //   this.setState({forceUpdate: true},()=>{this.setState({
  //     forceUpdate: false
  //   })});
  // };
  switchToChangeOwnership = () => {
    this.setState({
      initializationStockVisible: false,
      changeOwnershipVisible: true,
      shareholderChangelogVisible: false,
    });
  }

  initial = () => {
    this.setState({
      initializationStockVisible: false,
      changeOwnershipVisible: false,
      shareholderChangelogVisible: false,
    });
    console.log(this.state);
  };

  //初始化股权点击提交事件
  initializationStockSublime = () => {
    this.setState({
      initializationStockVisible: false,
    });
    this.setState({ forceUpdate: true }, () => {
      this.setState({
        forceUpdate: false
      })
    });
  }

  changeBack = () => {
    this.setState({
      initializationStockVisible: false,
      changeOwnershipVisible: true,
      shareholderChangelogVisible: false,
    });
  };

  render() {
    return (
      <div className="Shareholder">
        <div style={this.isTrueXian()}>
          <h2>
            <i />
            <span>股权结构</span>
          </h2>
          <div className="share_button">
            {this.state.holderInitVisible && (
              <Button type="primary" onClick={this.handleEquity}>股权初始化</Button>
              // <Button type="primary" onClick={() => {
              //   this.setState({
              //     initializationStockVisible: true,
              //   });
              // }}>股权初始化</Button>
            )}
            {this.state.holderSize !== 0 &&
              <Button onClick={() => {
                // this.props.props.history.push(`/enterprise/reported/changeownership`);
                this.setState({
                  changeOwnershipVisible: true,
                });
              }}>股权调整</Button>
            }
            {this.state.holderSize !== 0 &&
              <Button onClick={() => {
                // this.props.props.history.push(`/enterprise/reported/shareholderchangelog`);
                this.setState({
                  shareholderChangelogVisible: true,
                });
              }}>股权调整记录</Button>
            }
          </div>
          {this.validShareList()}
          <h2 style={{ marginTop: '16px' }}>
            <i className="dong" />
            <span>股东信息</span>
          </h2>
          <div className="share_button">
            <Button type="primary" onClick={this.changeDrawer.bind(this, true)}>新增机构股东</Button>
            <Button onClick={this.changeDrawerTwo.bind(this, true)}>新增自然人股东</Button>
          </div>
          {this.stockholderList()}

          {/*股权初始化弹窗*/}
          <Modal title="股权初始化"
            visible={this.state.visible}
            onCancel={this.handleCancel}
            footer={null}
            className="shareholder_wed"
          >
            <div className="modal-equity">
              <p><Icon type="exclamation-circle" style={{ fontSize: 24, color: '#FFBF00' }} />
                <span>在股权初始化前，请根据企业在工商局登记的内容，完整补充各股东信息。</span>
              </p>
              <div className="line" />
              <div className="modal_footer">
                <Button type="primary" onClick={this.changeDrawer.bind(this, true)}>新增机构股东</Button>
                <Button type="primary" ghost onClick={this.changeDrawerTwo.bind(this, true)}>新增自然人股东</Button>
                <Button onClick={this.handleCancel}>取消</Button>
              </div>
            </div>
          </Modal>
          <DrawerAddShareloder onChange={(openAddShareolder) => { this.setState({ openAddShareolder: openAddShareolder }) }} visiable={this.state.openAddShareolder} addShareolderId={this.state.addShareolderId} idx={this.state.idx2} init={this.state.init} forceUpdate={this.changePersonState} />
          <DrawerAddZiShareloder onChange={(openAddZiShareolder) => { this.setState({ openAddZiShareolder: openAddZiShareolder }) }} visiable={this.state.openAddZiShareolder} addZiShareolderId={this.state.addZiShareolderId} idx={this.state.idx1} init={this.state.init} forceUpdate={this.changePersonState} />
        </div>
        {this.state.initializationStockVisible && <InitializationStock close={this.initial} visible={this.state.initializationStockVisible} sublime={this.initializationStockSublime} />}
        {this.state.changeOwnershipVisible && <ChangeOwnership close={this.callbackOne} visible={this.state.changeOwnershipVisible} />}
        {this.state.shareholderChangelogVisible && <ShareholderChangeLog close={this.initial} switchToChangeOwnership={this.switchToChangeOwnership} visible={this.state.shareholderChangelogVisible} />}
      </div>
    );
  }
}
