import React, { Component } from 'react';
import { connect } from 'dva';
import { Tabs } from 'antd';

import DistrictBasic from "./DistrictBasic";
import OverseasBasic from "./OverseasBasic";
import Shareholder from "./Shareholder";
import Management from "./ManagementBasic";

import styles from './less/report.less';

const { TabPane } = Tabs;



@connect(state => ({
  profile: state.profile,
}))

export default class Reported extends Component {
  constructor(props,context){
    super(props,context);
  }

  componentDidMount() {}


  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: 'form/submitRegularForm',
          payload: values,
        });
      }
    });
  };
  callback = (key) => {
    this.setState({
      defaultSize:'2',
    });
  };

  render() {
    return (
      <div className={styles.report} style={{padding:'10px 24px 24px'}}>
        <Tabs defaultActiveKey='1' onChange={this.callback}>
          <TabPane tab="跨区经营" key="1">
            <DistrictBasic props={this.props} />
          </TabPane>
          <TabPane tab="海外经营" key="2">
            <OverseasBasic props={this.props}/>
          </TabPane>
          <TabPane tab="股东信息" key="3">
            <Shareholder props={this.props}/>
          </TabPane>
          <TabPane tab="管理层信息" key="4">
            <Management props={this.props}/>
          </TabPane>
        </Tabs>
      </div>
    );
  }
}


