/**
 * @author  Xyz
 * 分公司管理
 */
import React from 'react';
import {
  Form,
  Input,
  Button,
  message,
  Table,
  Popover,
  Modal,
  DatePicker
} from 'antd';
import {
  Container,
  SearchItem,
  Options,
} from "./styles";
import PTable from '../../../components/Pro/PTable';

import DrawBranchCompanyDetail from './DrawBranchCompanyDetail';//分公司详情
const FormItem = Form.Item;
@Form.create()
export default class BranchCompanyManager extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      visible: false,
      pageParm: {     //数据请求 分页信息
        pageSize: '10',//缴交情况
        pageNumber: "1",
        keyWord: "",
        startDate:"",
        endDate:"",
      },
    }
  }

  /******************************生命周期******************************/

  componentDidMount = () => {

  }

  /******************************ajax请求******************************/


  /******************************相关事件******************************/
  onDateChange = (date, [startDate, endDate]) => {
    const {pageParm} = this.state;
    pageParm.startDate = startDate;
    pageParm.endDate = endDate;
    this.setState({pageParm});
  }

  /******************************render******************************/
  renderTable = () => {


    const columns1 = [
      {
        title: '姓名',
        dataIndex: 'comName',
        key: 'comName',
        render: text => <a href="javascript:;">{text}</a>,
      },
      {
        title: '工号',
        dataIndex: 'comCerNo',
        key: 'comCerNo',
      },
      {
        title: '所在部门',
        dataIndex: 'address',
        key: 'address',
      },
      {
        title: '手机号',
        dataIndex: 't1',
        key: 't1',
      },
      {
        title: '入职日期',
        dataIndex: 't3',
        key: 't3',
      },
      {
        title: '离职日期',
        dataIndex: 't4',
        key: 't4',
      },
    ];
    {/*<PTable url="enterpriseComManagerListBranchComManager" columns={columns1}/>*/
    }

    return (
      <PTable
        url="enterpriseCompanyComBaseInfoGetBranch"
        pageParm={this.state.pageParm}
        columns={columns1}
        forceUpdate={this.state.forceUpdate}
      />
    );
  }

  render() {
    const {visible} = this.state;
    return (
      <Container>
        <SearchItem>
          关键字：
          <Input className="input" placeholder="请输入负责人/手机号/备案机关"/>
          注册日期：
          <DatePicker.RangePicker
            style={{width: 214, marginRight: 16}}
            onChange={this.onDateChange}
          />
          <Button className="btn" type="primary">搜索</Button>
          <Button>重置</Button>
        </SearchItem>

        {this.renderTable()}


      </Container>
    );
  }
}


