import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import {
  // Button,
  Popover,
  Input,
  Select,
  DatePicker
} from 'antd';
import { withRouter } from 'dva/router';
import moment from 'moment';
import locale from 'antd/lib/date-picker/locale/zh_CN';
import ExcelButtonOline from '../../../../../components/ExcelButtonOline';
import DepartSelect from '../../../../../components/user/DepartSelect';
import PSelect from '../../../../../components/Pro/PSelect';
import { getPerType } from '../../../../../services/api';
import columnFun from './columns';
import tablePage from '../../../../../utils/hoc/tablePage';

const { Option } = Select;
const { RangePicker } = DatePicker;
@connect(state => ({
  global: state.global
}))
@tablePage()
@withRouter
export default class Submitted extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      params: null,
      perTypeList: [], // 人员类别
      agesRange: [], //年龄范围
    };
  }

  componentDidMount() {

  }
  componentWillMount() {
    const agesRange = [];
    for(let i = 0; i <= 80; i ++) {
      agesRange.push({
        value: i,
        label: i
      });
    }
    this.setState({
      agesRange
    });
    getPerType({ codeType: 'perType' }).then(
      response => {
        if (response.data) {
          if (response.data) {
            const firstValue = {
              codeType: "perType",
              codeValue: "",
              label: "全部"
            };
            const perTypeList = [firstValue, ...response.data];
            this.setState({
              perTypeList,
              perType: perTypeList[0].codeValue
            });
          }
        }
      },
      err => {
        console.log(err);
      }
    );
  }

  // 表格渲染
  __renderOrderList = () => {
    const columns = columnFun.call(this);
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        columns={columns}
        url="pageForPerInfo"
        scroll={{ x: '3200px' }}
        pagination={{ showTotal: total => `总共 ${total} 条` }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator, setFieldsValue } = this.props.form;
    const { agesRange } = this.state;
    return (
      <div className="tab_inner">
        {/* <Alert
          message={<div style={{ color: '#333' }}>
            <span>本页面为已提交保安岗位适应性培训记录页面，您可以实时查询学员的信息及状态。</span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        /> */}
        <SearchForm
          arrange={values => {
            values.departIds = values.departIds.map(item => item.split('-')[0]).join(',');
            const { date } = values;
            if(date.length == 2) {
              values.entryStartDate = moment(date[0]).format('YYYY-MM-DD');
              values.entryEndDate = moment(date[1]).format('YYYY-MM-DD');
            }else {
              values.entryStartDate = '';
              values.entryEndDate = '';
            }
            Reflect.deleteProperty(values, 'date');
            this.setState({
              params: values //储存参数，供导出使用
            });
            return values;
          }}
          Btns={FormBtns}
        >
          <FormContainer>
            <Form.Item label="关键词">
              {getFieldDecorator('keyWord', {
                initialValue: ''
              })(
                <Input style={{ width: 240 }} placeholder="请输入姓名/手机号码/身份证" />
              )}
            </Form.Item>
            <Form.Item label="部门">
              {getFieldDecorator('departIds', {
                initialValue: []
              })(
                <DepartSelect
                  style={{ width: 240 }}
                  className="w-400 ipt-h"
                  dropdownStyle={{ maxHeight: 250, overflow: 'auto' }}
                  placeholder="请选择部门(默认为全部)"
                  treeDefaultExpandAll
                  showSearch={true}
                  allowClear
                  multiple
                  showCheckedStrategy={'SHOW_ALL'}
                  onChange={values => {
                    setFieldsValue({ departIds: values });
                  }}
                />
              )}
            </Form.Item>
            <Form.Item label="人员类别">
              {getFieldDecorator('perType', {
                initialValue: ''
              })(
                <Select
                  style={{ width: 240 }}
                  placeholder="请选择"
                  onChange={(value) => {
                    setFieldsValue({ perType: value });
                  }}
                // disabled={this.props.companyInfo.industryType === '02' && this.state.perId !== ''}
                >
                  {(() => {
                    return this.state.perTypeList.map((val, key) => {
                      return (
                        <Option key={key} value={val.codeValue + ''}>
                          {val.label}
                        </Option>
                      );
                    });
                  })()}
                </Select>
              )}
            </Form.Item>
            <Form.Item label="APP激活状态">
              {getFieldDecorator('isAppActive', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 240 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未激活</Option>
                  <Option value="1">已激活</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="认证状态">
              {getFieldDecorator('authStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 240 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未认证 </Option>
                  <Option value="1">已认证</Option>
                  <Option value="2">认证中</Option>
                  <Option value="3">认证失败</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="申诉状态">
              {getFieldDecorator('sszt', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 240 }} >
                  <Option value="">全部</Option>
                  <Option value="0">申诉中 </Option>
                  <Option value="1">申诉通过</Option>
                  <Option value="2">申诉不通过</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="入职时间">
              {getFieldDecorator('date', {
                initialValue: []
              })(
                <RangePicker
                  locale={locale}
                  style={{ width: 240 }}
                  // defaultValue={[moment('2015/01/01', 'YYYY/MM/DD'), moment('2015/01/01', 'YYYY/MM/DD')]}
                  format={'YYYY-MM-DD'}
                  // onChange={(date, strings) => {
                  //   setFieldsValue({ date });
                  // }}
                />
              )}
            </Form.Item>
            <Form.Item label="最小年龄">
              {getFieldDecorator('minAge', {
                initialValue: agesRange[0]? agesRange[0].value: ''
              })(
                <Select style={{ minWidth: 240 }} >
                  {
                    agesRange.map((item, index) => {
                      return (
                      <Option key={index + moment().valueOf()} value={item.value}>{item.label}</Option>
                      );
                    })
                  }
                </Select>
              )}
            </Form.Item>
            <Form.Item label="最大年龄">
              {getFieldDecorator('maxAge', {
                initialValue: agesRange[agesRange.length - 1]? agesRange[agesRange.length - 1].value: ''
              })(
                <Select style={{ minWidth: 240 }} >
                  {
                    agesRange.map((item, index) => {
                      return (
                      <Option key={index + moment().valueOf()} value={item.value}>{item.label}</Option>
                      );
                    })
                  }
                </Select>
              )}
            </Form.Item>
            <Form.Item label="投保状态">
              {getFieldDecorator('tbzt', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 240 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未投保</Option>
                  <Option value="1">已投保</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="持证状态">
              {getFieldDecorator('czzt', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 240 }} >
                  <Option value="">全部</Option>
                  <Option value="1">已持证</Option>
                  <Option value="0">未持证</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="保安等级">
              {getFieldDecorator('perCerLevel', {
                initialValue: ''
              })(
                <PSelect addOption style={{ width: 240 }} type="perCerLevel" />
              )}
            </Form.Item>
          </FormContainer>
        </SearchForm>
        <Btns>
          <Popover content={<span style={{ display: 'block', padding: 10 }}>搜索后可导出搜索结果</span>}>
            <ExcelButtonOline
              disabled={!this.props.clicked}
              params={this.state.params}
              downloadname={`${this.props.global.companyInfo.comName}_人员.xls`}
              apiurl="system/per-base-info/export-security-staff-info"
            >
              导出检索结果
            </ExcelButtonOline>
            {/* <Button
                style={{marginLeft: 10}}
                onClick={() => {
                    this.props.history.push(
                      '/PersonnelRecruitment/StaffQuery/import'
                    );
                  }}
                >
                  证书导入
              </Button> */}
          </Popover>
        </Btns>
        {/* 表格 */}
        {this.__renderOrderList()}
      </div >
    );
  }
}

const FormBtns = st.div`
  background: #f9f9f9;
  padding-left: 50px;
  padding-bottom: 10px;
  button{
    margin-right: 15px;
  }
`;
const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;
const FormContainer = st.div`
  display: flex;
  background: #f9f9f9;
  padding: 15px 100px 15px 15px;
  flex-wrap: wrap;
  .ant-form-item{
    width: 30%;
    margin-bottom: 10px;
    margin-right: 0;
    box-sizing: border-box;
    text-align: right;
  }
`;