import React, { Component } from "react";
import { connect } from "dva";
import { Tabs } from "antd";
import queryString from "query-string";

import BasicInformationPage from "./BasicInformationPage";
import DetailedInformationPage from "./DetailedInformationPage";
import CertificateInformationPage from "./CertificateInformationPage";
import ContractInfo from "./ContractInfo";

// import styles from './less/PersonnelInformationNav.less';

const { TabPane } = Tabs;

@connect(state => ({
  profile: state.profile
}))
export default class PersonnelInformationNav extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      tabPane_two: true,
      perId: ""
    };
  }

  componentDidMount() {
    const sd = queryString.parse(this.props.location.search).perId;
    if (sd !== undefined) {
      this.setState({
        perId: sd,
        tabPane_two: false
      });
    }
  }

  //改变tab详细信息是否可以点击
  changeTabTwo = () => {
    this.setState({
      tabPane_two: false
    });
  };

  //基础信息向详细信息传值
  getChildId = event_id => {
    this.setState(
      {
        perId: event_id
      }
    );
  };

  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: "form/submitRegularForm",
          payload: values
        });
      }
    });
  };
  callback = key => {
  };
  render() {
    return (
      <div>
        <Tabs
          tabBarStyle={{ marginLeft: 24, marginRight: 24 }}
          defaultActiveKey="1"
          onChange={this.callback}
        >
          <TabPane tab="基础信息" key="1">
            <BasicInformationPage
              props={this.props}
              handleChangeTab={this.changeTabTwo}
              getId={this.getChildId.bind(this)}
              perId={this.state.perId}
            />
          </TabPane>
          <TabPane tab="详细信息" key="2" disabled={this.state.tabPane_two}>
            <DetailedInformationPage
              props={this.props}
              perId={this.state.perId}
            />
          </TabPane>
          <TabPane tab="证书信息" key="3" disabled={this.state.tabPane_two}>
            <CertificateInformationPage
              props={this.props}
              perId={this.state.perId}
            />
          </TabPane>
          <TabPane tab="合同信息" key="4" disabled={this.state.tabPane_two}>
            <ContractInfo
              props={this.props}
              perId={this.state.perId}
            />
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
