import React, { Component } from 'react';
import { connect } from 'dva';
import { Alert, Form } from 'antd';
import st from 'styled-components';
import { systemPerBaseInfoGetPerBaseInfo } from '../../../services/api';
import $nModal from '../../../utils/modal/nModal';
// import PFromUpload from '../../../components/Pro/PFromUpload';
const formLayout = {
  labelCol: {
    span: 24
  },
  wrapperCol: {
    span: 24
  }
};

@connect(state => ({
  profile: state.profile
}))
@Form.create()
export default class ContractList extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      idCardFrontUrl: '',
      idCardReverseUrl: ''
    };
  }
  componentWillMount() {
    systemPerBaseInfoGetPerBaseInfo({ perId: this.props.perId }).then(res => {
      // log(res, 'res');
      this.setState({
        idCardFrontUrl: res.data.idCardFrontUrl,
        idCardReverseUrl: res.data.idCardReverseUrl
      });
    });
  }

  render() {
    // const { getFieldDecorator } = this.props.form;
    const { idCardFrontUrl, idCardReverseUrl } = this.state;
    return (
      <div className="contractWrapper">
        <Alert
          message={<div>
            人员可通过App-我的-个人信息-身份证正反面拍照上传身份证照片；
            <br />
            在进行资格证、等级证报名时，系统会自动获取已上传的身份证照片，无需额外上传。
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        {/* <Form>
          <Form.Item {...formLayout} label="身份证人面像">
            {getFieldDecorator('idCardReverseUrl', {
              initialValue: this.state.idCardReverseUrl,
              rules: []
            })(
              <PFromUpload
                style={{
                  width: 300,
                  height: 220
                }}
                disabled
                num={1}
                onChange={() => {}}
              />
            )}
          </Form.Item>
        </Form> */}
        <IDWrap>
        <h3>身份证人像面:</h3>
          <div onClick={() => {
            if(idCardFrontUrl) {
              $nModal({
                title: ' ',
                width: 888,
                footer: null,
                content: (
                  <div style={{textAlign: 'center'}}>
                    <img style={{maxWidth: '100%'}} src={idCardFrontUrl} alt=""/>
                  </div>
                ),
              });
            }
          }} className="img_wrap">
            {
              !idCardFrontUrl && 
              <span>未上传</span>
            }
            {
              idCardFrontUrl && 
              <img src={idCardFrontUrl} alt=""/>
            }
          </div>
          <h3 style={{marginTop: 15}}>身份证国徽面:</h3>
          <div onClick={() => {
            if(idCardReverseUrl) {
              $nModal({
                title: ' ',
                width: 888,
                footer: null,
                content: (
                  <div style={{textAlign: 'center'}}>
                    <img style={{maxWidth: '100%'}} src={idCardReverseUrl} alt=""/>
                  </div>
                ),
              });
            }
          }} className="img_wrap">
            {
              !idCardReverseUrl &&
              <span >未上传</span>
            }
            {
              idCardReverseUrl &&
              <img src={idCardReverseUrl} alt=""/>
            }
          </div>
          
        </IDWrap>
      </div>
    );
  }
}

const IDWrap = st.div`
h3{
  padding-left: 10px;
}
>.img_wrap{
  width: 240px;
  height: 151px;
  line-height: 151px;
  border-radius: 2px;
  background: #f5f5f5;
  text-align: center;
  cursor: pointer;
  >img{
    width: 100%;
    height: 100%;
  }
}
`;