import React, { Component } from "react";
import { connect } from "dva";
import { Alert, Form, Button, Modal,Upload,message } from "antd";
import st from "styled-components";
import {
  uploadUrl,
  updatePerColorPhotoUrl,
  systemPerBaseInfoGetPerBaseInfo,
  deletePerColorPhotoUrl,
} from "../../../services/api";
import $loading from '../../../utils/loading';
import $nModal from "../../../utils/modal/nModal";
const formLayout = {
  labelCol: {
    span: 24,
  },
  wrapperCol: {
    span: 24,
  },
};
const { confirm } = Modal;
@connect((state) => ({
  profile: state.profile,
}))
@Form.create()
export default class IDPhoto extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      colourPhotoUrl: "",
      perId: props.perId,
    };
  }
  componentWillMount() {
    this.getPerBaseInfoGetPerBaseInfo(this.state.perId);
  }

  //获取基本信息页面数据
  getPerBaseInfoGetPerBaseInfo = (perId) => {
    systemPerBaseInfoGetPerBaseInfo({ perId }).then(
      (data) => {
        this.setState({
          colourPhotoUrl: data.data.colourPhotoUrl,
        });
      },
      (err) => {
        console.log("errerr", err);
      }
    );
  };
  //删除证件照
  deletePerColorPhotoUrl = (perId) => {
    deletePerColorPhotoUrl({perId}).then((data) => {
      if (data.retType == "0") {
        // this.setState({
        //   colourPhotoUrl: "",
        // });
        this.getPerBaseInfoGetPerBaseInfo(this.state.perId);
      }
    });
  };
  render() {
    const { colourPhotoUrl } = this.state;
    return (
      <div className="contractWrapper">
        <Alert
          message={
            <div>
              以下证件照将用于资格证证书使用，请务必上传标准的证件照照片。建议让保安员到照相馆拍照后，提供电子版给企业，企业管理员审核后再上传。
              <br />
              保安员若先前上传过本照片，则无法进行联名卡办理，需补传。
            </div>
          }
          type="warning"
          showIcon
          style={{ marginBottom: "15px" }}
        />
        <IDWrap>
          <h3>标准一寸免冠白底证件照照片:</h3>
          <div
            onClick={() => {
              if (colourPhotoUrl) {
                $nModal({
                  title: "预览",
                  width: 888,
                  footer: null,
                  content: (
                    <div style={{ textAlign: "center" }}>
                      <img
                        style={{ maxWidth: "100%" }}
                        src={colourPhotoUrl}
                        alt=""
                      />
                    </div>
                  ),
                });
              }
            }}
            className="img_wrap"
          >
            {!colourPhotoUrl && <span>未上传</span>}
            {colourPhotoUrl && <img src={colourPhotoUrl} alt="" />}
          </div>
          {/* {colourPhotoUrl && (
            <Button
              type="danger"
              style={{ marginTop: "10px" }}
              onClick={() => {
                const _this = this;
                confirm({
                  title: "确定删除一寸免冠彩照照片?",
                  okText: "删除",
                  okType: "danger",
                  cancelText: "取消",
                  onOk() {
                    _this.deletePerColorPhotoUrl(_this.state.perId);
                  },
                  onCancel() {
                    console.log("Cancel");
                  },
                });
              }}
            >
              删除
            </Button>
          )} */}
          <div style={{marginTop:'5px'}}>
             <Upload
              showUploadList={false}
              action={uploadUrl}
              name="xfile"
              beforeUpload={file=>{
                let ifError = true;
                if (!(file.name + '').toLocaleLowerCase().match(/(\.jpeg)|(\.jpg)/)) {
                  message.error('请上传拓展名为.jpeg\.jpg图片!');
                  ifError = false;
                }
                if(ifError && 1024 * 1024 < file.size){
                  message.error('请上传1M以内的图片!');
                  ifError = false;
                }
                return ifError;
              }}
              onChange={info => {
                const { status ,response} = info.file;
                if (status === 'done') {
                  $loading.open('文件上传中,请稍后。。。');
                  if (response.retType !== '0') {
                      message.error(info.file.response.msg);
                      return;
                  }
                  if (info.fileList.length === 0) {
                      return;
                  }
                  const result = info.file.response.data
                  if(result){
                    updatePerColorPhotoUrl({colourPhotoUrl:result,perId:this.state.perId}).then(res=>{
                      if(res.retType=='0'){
                        message.success(`文件上传成功。`);
                        this.getPerBaseInfoGetPerBaseInfo(this.state.perId);
                        $loading.close();
                      }
                    }).catch(err=>{
                      message.error(err.msg)
                      $loading.close();
                    })
                  }
              } else if (status === 'error') {
                    message.error(`${info.file.name} 文件上传失败。`);
                }
              }}
            >
              <Button style={{ marginLeft: 10 }} type="primary">{colourPhotoUrl?'重新上传':'上传'}</Button>
            </Upload>
            <h1 style={{color:'red'}}>
              请上传1M以内的jpeg/jpg的标准一寸免冠白底证件照照片，上传前注意核对照片是否本人；<br/>
              该照片将用于保安员资格证使用，建议让保安员到照相馆拍摄，取得电子档照片，确保符合证件照标准。
            </h1>
          </div>
        
        </IDWrap>
      </div>
    );
  }
}

const IDWrap = st.div`
h3{
  padding-left: 10px;
}
>.img_wrap{
  width: 150px;
  height: 210px;
  line-height: 151px;
  border-radius: 2px;
  background: #f5f5f5;
  text-align: center;
  cursor: pointer;
  >img{
    width: 100%;
    height: 100%;
  }
}
`;
